/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.caches;

import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Glossary;
import com.atlan.samples.loaders.caches.AssetCache;
import com.atlan.samples.loaders.models.GlossaryEnrichmentDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryCache
extends AssetCache {
    private static final Logger log = LoggerFactory.getLogger(GlossaryCache.class);

    @Override
    protected Asset lookupAsset(String identity) {
        String glossaryName = GlossaryEnrichmentDetails.getNameFromIdentity(identity);
        try {
            return Glossary.findByName((String)glossaryName, null);
        }
        catch (AtlanException e) {
            log.error("Unable to lookup or find glossary: {}", (Object)identity, (Object)e);
            return null;
        }
    }
}

