/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.caches;

import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.samples.loaders.caches.AssetCache;
import com.atlan.samples.loaders.models.TermEnrichmentDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermCache
extends AssetCache {
    private static final Logger log = LoggerFactory.getLogger(TermCache.class);

    @Override
    protected Asset lookupAsset(String identity) {
        String termName = TermEnrichmentDetails.getNameFromIdentity(identity);
        String glossaryName = TermEnrichmentDetails.getGlossaryNameFromIdentity(identity);
        try {
            return GlossaryTerm.findByName((String)termName, (String)glossaryName, null);
        }
        catch (AtlanException e) {
            log.error("Unable to lookup or find term: {}", (Object)identity, (Object)e);
            return null;
        }
    }
}

