/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.ADLSAccount;
import com.atlan.model.assets.Asset;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(AccountDetails.class);
    public static final String COL_ACCOUNT = "ACCOUNT NAME";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "ACCOUNT NAME");
    private static final List<String> REQUIRED_EMPTY = List.of("BUCKET NAME", "OBJECT NAME");
    private String connectionQualifiedName;
    private String name;

    @Override
    public String getIdentity() {
        return this.connectionQualifiedName + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        String accountName;
        String connectionQN = ConnectionDetails.getQualifiedName(connectionCache, row);
        if (connectionQN != null && (accountName = row.get(COL_ACCOUNT)) != null) {
            return connectionQN + "/" + accountName;
        }
        return null;
    }

    public static AccountDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        if (AccountDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String connectionQualifiedName = ConnectionDetails.getQualifiedName(connectionCache, row);
            if (AccountDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((AccountDetailsBuilder)((AccountDetailsBuilder)AccountDetails.getFromRow(AccountDetails.builder(), row, delim).connectionQualifiedName(connectionQualifiedName)).name(row.get(COL_ACCOUNT))).build();
            }
            return ((AccountDetailsBuilder)((AccountDetailsBuilder)AccountDetails.builder().connectionQualifiedName(connectionQualifiedName)).name(row.get(COL_ACCOUNT))).build();
        }
        return null;
    }

    public static void upsert(Map<String, AccountDetails> accounts, int batchSize, boolean updateOnly) {
        AssetBatch batch = new AssetBatch("ADLSAccount", batchSize);
        HashMap<String, List<String>> toClassify = new HashMap<String, List<String>>();
        try {
            for (AccountDetails details : accounts.values()) {
                String connectionQualifiedName = details.getConnectionQualifiedName();
                String accountName = details.getName();
                if (updateOnly) {
                    String qualifiedName = ADLSAccount.generateQualifiedName((String)accountName, (String)connectionQualifiedName);
                    try {
                        Asset.retrieveMinimal((String)"ADLSAccount", (String)qualifiedName);
                        ADLSAccount toUpdate = ((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)ADLSAccount.updater((String)qualifiedName, (String)accountName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassify.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                        }
                        batch.add((Asset)toUpdate);
                    }
                    catch (NotFoundException e) {
                        log.warn("Unable to find existing account \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to lookup whether account exists or not.", (Throwable)e);
                    }
                    continue;
                }
                ADLSAccount account = ((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)((ADLSAccount.ADLSAccountBuilder)ADLSAccount.creator((String)accountName, (String)connectionQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                if (!details.getAtlanTags().isEmpty()) {
                    toClassify.put(account.getQualifiedName(), details.getAtlanTags());
                }
                batch.add((Asset)account);
            }
            batch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert account details.", (Throwable)e);
        }
        AccountDetails.appendAtlanTags(toClassify, "ADLSAccount");
    }

    protected AccountDetails(AccountDetailsBuilder<?, ?> b) {
        super(b);
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.name = b.name;
    }

    public static AccountDetailsBuilder<?, ?> builder() {
        return new AccountDetailsBuilderImpl();
    }

    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AccountDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AccountDetails(super=" + super.toString() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", name=" + this.getName() + ")";
    }

    private static final class AccountDetailsBuilderImpl
    extends AccountDetailsBuilder<AccountDetails, AccountDetailsBuilderImpl> {
        private AccountDetailsBuilderImpl() {
        }

        @Override
        protected AccountDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public AccountDetails build() {
            return new AccountDetails(this);
        }
    }

    public static abstract class AccountDetailsBuilder<C extends AccountDetails, B extends AccountDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String connectionQualifiedName;
        private String name;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AccountDetails.AccountDetailsBuilder(super=" + super.toString() + ", connectionQualifiedName=" + this.connectionQualifiedName + ", name=" + this.name + ")";
        }
    }
}

