/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.api.EntityUniqueAttributesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(AssetDetails.class);
    private static final String COL_DESCRIPTION = "DESCRIPTION";
    private static final String COL_CERTIFICATE = "CERTIFICATE";
    private static final String COL_CERT_MESSAGE = "CERTIFICATE MESSAGE";
    private static final String COL_ANNOUNCEMENT = "ANNOUNCEMENT";
    private static final String COL_ANN_TITLE = "ANNOUNCEMENT TITLE";
    private static final String COL_ANN_MESSAGE = "ANNOUNCEMENT MESSAGE";
    private static final String COL_OWN_USERS = "OWNER USERS";
    private static final String COL_OWN_GROUPS = "OWNER GROUPS";
    private static final String COL_ATLAN_TAGS = "ATLAN TAGS";
    private String description;
    private CertificateStatus certificate;
    private String certificateStatusMessage;
    private AtlanAnnouncementType announcementType;
    private String announcementTitle;
    private String announcementMessage;
    private List<String> ownerUsers;
    private List<String> ownerGroups;
    private List<String> atlanTags;
    private boolean stub;

    public abstract String getIdentity();

    protected static <T extends AssetDetailsBuilder<?, ?>> T getFromRow(T builder, Map<String, String> row, String delim) {
        ((AssetDetailsBuilder)((AssetDetailsBuilder)((AssetDetailsBuilder)((AssetDetailsBuilder)((AssetDetailsBuilder)((AssetDetailsBuilder)builder.description(row.get(COL_DESCRIPTION))).certificateStatusMessage(row.get(COL_CERT_MESSAGE))).announcementTitle(row.get(COL_ANN_TITLE))).announcementMessage(row.get(COL_ANN_MESSAGE))).ownerUsers(AssetDetails.getMultiValuedList(row.get(COL_OWN_USERS), delim))).ownerGroups(AssetDetails.getMultiValuedList(row.get(COL_OWN_GROUPS), delim))).atlanTags(AssetDetails.getMultiValuedList(row.get(COL_ATLAN_TAGS), delim));
        String certificate = row.get(COL_CERTIFICATE);
        String announcement = row.get(COL_ANNOUNCEMENT);
        if (certificate != null && certificate.length() > 0) {
            builder.certificate(CertificateStatus.fromValue((String)certificate));
        }
        if (announcement != null && announcement.length() > 0) {
            builder.announcementType(AtlanAnnouncementType.fromValue((String)announcement));
        }
        return builder;
    }

    protected static boolean getBoolean(String candidate) {
        if (candidate == null || candidate.length() == 0) {
            return false;
        }
        String upper = candidate.toUpperCase(Locale.ROOT);
        return upper.equals("X") || upper.equals("Y") || upper.equals("YES") || upper.equals("TRUE");
    }

    protected static List<String> getMultiValuedList(String candidate, String delim) {
        if (candidate != null && candidate.length() > 0) {
            return Arrays.asList(candidate.split(Pattern.quote(delim)));
        }
        return Collections.emptyList();
    }

    protected static List<String> getMissingFields(Map<String, String> row, Collection<String> requiredFields) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (String columnName : requiredFields) {
            String candidate = row.get(columnName);
            if (candidate != null && candidate.length() != 0) continue;
            missingFields.add(columnName);
        }
        return missingFields;
    }

    protected static List<String> getRequiredEmptyFields(Map<String, String> row, Collection<String> requiredEmptyFields) {
        ArrayList<String> nonEmptyFields = new ArrayList<String>();
        for (String columnName : requiredEmptyFields) {
            String candidate = row.get(columnName);
            if (candidate == null || candidate.length() <= 0) continue;
            nonEmptyFields.add(columnName);
        }
        return nonEmptyFields;
    }

    protected static void appendAtlanTags(Map<String, List<String>> assetMap, String typeName) {
        List<Object> atlanTags;
        String qn;
        HashMap<String, List<Object>> toRetag = new HashMap<String, List<Object>>();
        if (!assetMap.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : assetMap.entrySet()) {
                qn = entry.getKey();
                atlanTags = new ArrayList(entry.getValue());
                try {
                    Asset column = Asset.retrieveMinimal((String)typeName, (String)qn);
                    SortedSet existing = column.getAtlanTags();
                    ArrayList<String> toRemove = new ArrayList<String>();
                    for (AtlanTag one : existing) {
                        if (!atlanTags.contains(one.getTypeName())) continue;
                        toRemove.add(one.getTypeName());
                    }
                    atlanTags.removeAll(toRemove);
                    if (atlanTags.isEmpty()) continue;
                    toRetag.put(qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to find {} {} \u2014 cannot retag it.", new Object[]{typeName, qn, e});
                }
            }
        }
        if (!toRetag.isEmpty()) {
            log.info("... tagging {} {}s:", (Object)toRetag.size(), (Object)typeName);
            for (Map.Entry<String, List<String>> entry : toRetag.entrySet()) {
                qn = entry.getKey();
                atlanTags = entry.getValue();
                try {
                    log.info("...... tagging: {}", (Object)qn);
                    EntityUniqueAttributesEndpoint.addAtlanTags((String)typeName, (String)qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to tag {} {} with: {}", new Object[]{typeName, qn, atlanTags, e});
                }
            }
        }
    }

    protected static void selectivelyUpdateCustomMetadata(Map<String, Map<String, CustomMetadataAttributes>> guidMap) {
        if (guidMap != null) {
            for (Map.Entry<String, Map<String, CustomMetadataAttributes>> outer : guidMap.entrySet()) {
                String guid = outer.getKey();
                Map<String, CustomMetadataAttributes> attrMap = outer.getValue();
                for (Map.Entry<String, CustomMetadataAttributes> inner : attrMap.entrySet()) {
                    String cmName = inner.getKey();
                    CustomMetadataAttributes cma = inner.getValue();
                    if (cmName == null || cma == null || cma.isEmpty()) continue;
                    try {
                        log.info("... selectively updating custom metadata {} on asset {}", (Object)cmName, (Object)guid);
                        Asset.updateCustomMetadataAttributes((String)guid, (String)cmName, (CustomMetadataAttributes)cma);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to update custom metadata {} on {} with: {}", new Object[]{cmName, guid, cma, e});
                    }
                }
            }
        }
    }

    private static List<String> $default$ownerUsers() {
        return Collections.emptyList();
    }

    private static List<String> $default$ownerGroups() {
        return Collections.emptyList();
    }

    private static List<String> $default$atlanTags() {
        return Collections.emptyList();
    }

    private static boolean $default$stub() {
        return true;
    }

    protected AssetDetails(AssetDetailsBuilder<?, ?> b) {
        this.description = b.description;
        this.certificate = b.certificate;
        this.certificateStatusMessage = b.certificateStatusMessage;
        this.announcementType = b.announcementType;
        this.announcementTitle = b.announcementTitle;
        this.announcementMessage = b.announcementMessage;
        this.ownerUsers = b.ownerUsers$set ? b.ownerUsers$value : AssetDetails.$default$ownerUsers();
        this.ownerGroups = b.ownerGroups$set ? b.ownerGroups$value : AssetDetails.$default$ownerGroups();
        this.atlanTags = b.atlanTags$set ? b.atlanTags$value : AssetDetails.$default$atlanTags();
        this.stub = b.stub$set ? b.stub$value : AssetDetails.$default$stub();
    }

    public String getDescription() {
        return this.description;
    }

    public CertificateStatus getCertificate() {
        return this.certificate;
    }

    public String getCertificateStatusMessage() {
        return this.certificateStatusMessage;
    }

    public AtlanAnnouncementType getAnnouncementType() {
        return this.announcementType;
    }

    public String getAnnouncementTitle() {
        return this.announcementTitle;
    }

    public String getAnnouncementMessage() {
        return this.announcementMessage;
    }

    public List<String> getOwnerUsers() {
        return this.ownerUsers;
    }

    public List<String> getOwnerGroups() {
        return this.ownerGroups;
    }

    public List<String> getAtlanTags() {
        return this.atlanTags;
    }

    public boolean isStub() {
        return this.stub;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetDetails)) {
            return false;
        }
        AssetDetails other = (AssetDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStub() != other.isStub()) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CertificateStatus this$certificate = this.getCertificate();
        CertificateStatus other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        String this$certificateStatusMessage = this.getCertificateStatusMessage();
        String other$certificateStatusMessage = other.getCertificateStatusMessage();
        if (this$certificateStatusMessage == null ? other$certificateStatusMessage != null : !this$certificateStatusMessage.equals(other$certificateStatusMessage)) {
            return false;
        }
        AtlanAnnouncementType this$announcementType = this.getAnnouncementType();
        AtlanAnnouncementType other$announcementType = other.getAnnouncementType();
        if (this$announcementType == null ? other$announcementType != null : !this$announcementType.equals(other$announcementType)) {
            return false;
        }
        String this$announcementTitle = this.getAnnouncementTitle();
        String other$announcementTitle = other.getAnnouncementTitle();
        if (this$announcementTitle == null ? other$announcementTitle != null : !this$announcementTitle.equals(other$announcementTitle)) {
            return false;
        }
        String this$announcementMessage = this.getAnnouncementMessage();
        String other$announcementMessage = other.getAnnouncementMessage();
        if (this$announcementMessage == null ? other$announcementMessage != null : !this$announcementMessage.equals(other$announcementMessage)) {
            return false;
        }
        List<String> this$ownerUsers = this.getOwnerUsers();
        List<String> other$ownerUsers = other.getOwnerUsers();
        if (this$ownerUsers == null ? other$ownerUsers != null : !((Object)this$ownerUsers).equals(other$ownerUsers)) {
            return false;
        }
        List<String> this$ownerGroups = this.getOwnerGroups();
        List<String> other$ownerGroups = other.getOwnerGroups();
        if (this$ownerGroups == null ? other$ownerGroups != null : !((Object)this$ownerGroups).equals(other$ownerGroups)) {
            return false;
        }
        List<String> this$atlanTags = this.getAtlanTags();
        List<String> other$atlanTags = other.getAtlanTags();
        return !(this$atlanTags == null ? other$atlanTags != null : !((Object)this$atlanTags).equals(other$atlanTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStub() ? 79 : 97);
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CertificateStatus $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        String $certificateStatusMessage = this.getCertificateStatusMessage();
        result = result * 59 + ($certificateStatusMessage == null ? 43 : $certificateStatusMessage.hashCode());
        AtlanAnnouncementType $announcementType = this.getAnnouncementType();
        result = result * 59 + ($announcementType == null ? 43 : $announcementType.hashCode());
        String $announcementTitle = this.getAnnouncementTitle();
        result = result * 59 + ($announcementTitle == null ? 43 : $announcementTitle.hashCode());
        String $announcementMessage = this.getAnnouncementMessage();
        result = result * 59 + ($announcementMessage == null ? 43 : $announcementMessage.hashCode());
        List<String> $ownerUsers = this.getOwnerUsers();
        result = result * 59 + ($ownerUsers == null ? 43 : ((Object)$ownerUsers).hashCode());
        List<String> $ownerGroups = this.getOwnerGroups();
        result = result * 59 + ($ownerGroups == null ? 43 : ((Object)$ownerGroups).hashCode());
        List<String> $atlanTags = this.getAtlanTags();
        result = result * 59 + ($atlanTags == null ? 43 : ((Object)$atlanTags).hashCode());
        return result;
    }

    public String toString() {
        return "AssetDetails(description=" + this.getDescription() + ", certificate=" + this.getCertificate() + ", certificateStatusMessage=" + this.getCertificateStatusMessage() + ", announcementType=" + this.getAnnouncementType() + ", announcementTitle=" + this.getAnnouncementTitle() + ", announcementMessage=" + this.getAnnouncementMessage() + ", ownerUsers=" + this.getOwnerUsers() + ", ownerGroups=" + this.getOwnerGroups() + ", atlanTags=" + this.getAtlanTags() + ", stub=" + this.isStub() + ")";
    }

    public static abstract class AssetDetailsBuilder<C extends AssetDetails, B extends AssetDetailsBuilder<C, B>> {
        private String description;
        private CertificateStatus certificate;
        private String certificateStatusMessage;
        private AtlanAnnouncementType announcementType;
        private String announcementTitle;
        private String announcementMessage;
        private boolean ownerUsers$set;
        private List<String> ownerUsers$value;
        private boolean ownerGroups$set;
        private List<String> ownerGroups$value;
        private boolean atlanTags$set;
        private List<String> atlanTags$value;
        private boolean stub$set;
        private boolean stub$value;

        protected abstract B self();

        public abstract C build();

        public B description(String description) {
            this.description = description;
            return this.self();
        }

        public B certificate(CertificateStatus certificate) {
            this.certificate = certificate;
            return this.self();
        }

        public B certificateStatusMessage(String certificateStatusMessage) {
            this.certificateStatusMessage = certificateStatusMessage;
            return this.self();
        }

        public B announcementType(AtlanAnnouncementType announcementType) {
            this.announcementType = announcementType;
            return this.self();
        }

        public B announcementTitle(String announcementTitle) {
            this.announcementTitle = announcementTitle;
            return this.self();
        }

        public B announcementMessage(String announcementMessage) {
            this.announcementMessage = announcementMessage;
            return this.self();
        }

        public B ownerUsers(List<String> ownerUsers) {
            this.ownerUsers$value = ownerUsers;
            this.ownerUsers$set = true;
            return this.self();
        }

        public B ownerGroups(List<String> ownerGroups) {
            this.ownerGroups$value = ownerGroups;
            this.ownerGroups$set = true;
            return this.self();
        }

        public B atlanTags(List<String> atlanTags) {
            this.atlanTags$value = atlanTags;
            this.atlanTags$set = true;
            return this.self();
        }

        public B stub(boolean stub) {
            this.stub$value = stub;
            this.stub$set = true;
            return this.self();
        }

        public String toString() {
            return "AssetDetails.AssetDetailsBuilder(description=" + this.description + ", certificate=" + this.certificate + ", certificateStatusMessage=" + this.certificateStatusMessage + ", announcementType=" + this.announcementType + ", announcementTitle=" + this.announcementTitle + ", announcementMessage=" + this.announcementMessage + ", ownerUsers$value=" + this.ownerUsers$value + ", ownerGroups$value=" + this.ownerGroups$value + ", atlanTags$value=" + this.atlanTags$value + ", stub$value=" + this.stub$value + ")";
        }
    }
}

