/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.View;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.samples.loaders.models.SchemaDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(ContainerDetails.class);
    public static final String COL_CONTAINER = "CONTAINER NAME";
    public static final String COL_CONTAINER_TYPE = "CONTAINER TYPE";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "DATABASE NAME", "SCHEMA NAME", "CONTAINER NAME", "CONTAINER TYPE");
    private static final List<String> REQUIRED_EMPTY = List.of("COLUMN NAME");
    private String schemaQualifiedName;
    private String name;
    private String type;

    @Override
    public String getIdentity() {
        return this.schemaQualifiedName + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        String containerName;
        String schemaQN = SchemaDetails.getQualifiedName(connectionCache, row);
        if (schemaQN != null && (containerName = row.get(COL_CONTAINER)) != null) {
            return schemaQN + "/" + containerName;
        }
        return null;
    }

    static ContainerDetails getHeader(String name, String type) {
        return ((ContainerDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ContainerDetailsBuilder)ContainerDetails.builder().name(name)).type(type)).stub(true)).build();
    }

    public static ContainerDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        if (ContainerDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String schemaQualifiedName = SchemaDetails.getQualifiedName(connectionCache, row);
            if (ContainerDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((ContainerDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ContainerDetailsBuilder)((ContainerDetailsBuilder)ContainerDetails.getFromRow(ContainerDetails.builder(), row, delim).schemaQualifiedName(schemaQualifiedName)).name(row.get(COL_CONTAINER))).type(row.get(COL_CONTAINER_TYPE))).stub(false)).build();
            }
            return ((ContainerDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ContainerDetailsBuilder)((ContainerDetailsBuilder)ContainerDetails.builder().schemaQualifiedName(schemaQualifiedName)).name(row.get(COL_CONTAINER))).type(row.get(COL_CONTAINER_TYPE))).stub(true)).build();
        }
        return null;
    }

    public static Set<String> upsert(Map<String, ContainerDetails> containers, int batchSize, boolean updateOnly) {
        HashSet<String> parents = new HashSet<String>();
        AssetBatch batchContainers = new AssetBatch("container", batchSize);
        HashMap<String, List<String>> toClassifyTables = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyViews = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyMVs = new HashMap<String, List<String>>();
        try {
            for (ContainerDetails details : containers.values()) {
                String schemaQualifiedName = details.getSchemaQualifiedName();
                String containerName = details.getName();
                String containerType = details.getType();
                parents.add(schemaQualifiedName);
                switch (containerType) {
                    case "Table": {
                        Table toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = Table.generateQualifiedName((String)containerName, (String)schemaQualifiedName);
                            try {
                                Asset.retrieveMinimal((String)"Table", (String)qualifiedName);
                                toUpdate = ((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)Table.updater((String)qualifiedName, (String)containerName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyTables.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                batchContainers.add((Asset)toUpdate);
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing table \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether table exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        Table table = ((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)((Table.TableBuilder)Table.creator((String)containerName, (String)schemaQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyTables.put(table.getQualifiedName(), details.getAtlanTags());
                        }
                        batchContainers.add((Asset)table);
                        break;
                    }
                    case "View": {
                        Table toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = View.generateQualifiedName((String)containerName, (String)schemaQualifiedName);
                            try {
                                Asset.retrieveMinimal((String)"View", (String)qualifiedName);
                                toUpdate = ((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)View.updater((String)qualifiedName, (String)containerName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyViews.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                batchContainers.add((Asset)toUpdate);
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing view \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether view exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        View view = ((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)((View.ViewBuilder)View.creator((String)containerName, (String)schemaQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyViews.put(view.getQualifiedName(), details.getAtlanTags());
                        }
                        batchContainers.add((Asset)view);
                        break;
                    }
                    case "MaterialisedView": {
                        Table toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = MaterializedView.generateQualifiedName((String)containerName, (String)schemaQualifiedName);
                            try {
                                Asset.retrieveMinimal((String)"MaterialisedView", (String)qualifiedName);
                                toUpdate = ((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)MaterializedView.updater((String)qualifiedName, (String)containerName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyMVs.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                batchContainers.add((Asset)toUpdate);
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing view \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether view exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        MaterializedView mv = ((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)((MaterializedView.MaterializedViewBuilder)MaterializedView.creator((String)containerName, (String)schemaQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyMVs.put(mv.getQualifiedName(), details.getAtlanTags());
                        }
                        batchContainers.add((Asset)mv);
                        break;
                    }
                    default: {
                        log.error("Invalid container type ({}) \u2014 skipping: {}", (Object)containerType, (Object)details);
                    }
                }
            }
            batchContainers.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert container details.", (Throwable)e);
        }
        ContainerDetails.appendAtlanTags(toClassifyTables, "Table");
        ContainerDetails.appendAtlanTags(toClassifyViews, "View");
        ContainerDetails.appendAtlanTags(toClassifyMVs, "MaterialisedView");
        return parents;
    }

    protected ContainerDetails(ContainerDetailsBuilder<?, ?> b) {
        super(b);
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.name = b.name;
        this.type = b.type;
    }

    public static ContainerDetailsBuilder<?, ?> builder() {
        return new ContainerDetailsBuilderImpl();
    }

    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerDetails)) {
            return false;
        }
        ContainerDetails other = (ContainerDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ContainerDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ContainerDetails(super=" + super.toString() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", name=" + this.getName() + ", type=" + this.getType() + ")";
    }

    private static final class ContainerDetailsBuilderImpl
    extends ContainerDetailsBuilder<ContainerDetails, ContainerDetailsBuilderImpl> {
        private ContainerDetailsBuilderImpl() {
        }

        @Override
        protected ContainerDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ContainerDetails build() {
            return new ContainerDetails(this);
        }
    }

    public static abstract class ContainerDetailsBuilder<C extends ContainerDetails, B extends ContainerDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String schemaQualifiedName;
        private String name;
        private String type;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContainerDetails.ContainerDetailsBuilder(super=" + super.toString() + ", schemaQualifiedName=" + this.schemaQualifiedName + ", name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

