/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.samples.loaders.caches.GlossaryCache;
import com.atlan.samples.loaders.models.EnrichmentDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryEnrichmentDetails
extends EnrichmentDetails {
    private static final Logger log = LoggerFactory.getLogger(GlossaryEnrichmentDetails.class);
    public static final String COL_GLOSSARY = "GLOSSARY NAME";
    private static final List<String> REQUIRED = List.of("GLOSSARY NAME");
    private String name;

    @Override
    public String getIdentity() {
        return this.name;
    }

    public static String getNameFromIdentity(String identity) {
        return identity;
    }

    public static GlossaryEnrichmentDetails getFromRow(Map<String, String> row, String delim) {
        GlossaryEnrichmentDetailsBuilder builder = GlossaryEnrichmentDetails.getFromRow(GlossaryEnrichmentDetails.builder(), row, delim);
        if (GlossaryEnrichmentDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            builder = (GlossaryEnrichmentDetailsBuilder)((GlossaryEnrichmentDetailsBuilder)((GlossaryEnrichmentDetailsBuilder)((EnrichmentDetails.EnrichmentDetailsBuilder)builder.name(row.get(COL_GLOSSARY))).userDescription(row.get("USER DESCRIPTION"))).readme(row.get("README"))).customMetadataValues(GlossaryEnrichmentDetails.getCustomMetadataValuesFromRow(row, delim));
            return ((GlossaryEnrichmentDetailsBuilder)builder.stub(false)).build();
        }
        return null;
    }

    public static GlossaryCache upsert(Map<String, GlossaryEnrichmentDetails> glossaries, int batchSize, boolean replaceClassifications, boolean replaceCM, boolean updateOnly) {
        HashMap<String, String> readmes = new HashMap<String, String>();
        HashMap<String, Map<String, CustomMetadataAttributes>> cmToUpdate = new HashMap<String, Map<String, CustomMetadataAttributes>>();
        GlossaryCache glossaryNameToResult = new GlossaryCache();
        for (GlossaryEnrichmentDetails details : glossaries.values()) {
            Asset resolved;
            String glossaryName = details.getName();
            Glossary.GlossaryBuilder builder = null;
            if (!glossaryNameToResult.containsKey(glossaryName)) {
                try {
                    Glossary found = Glossary.findByName((String)glossaryName, null);
                    builder = found.trimToRequired();
                }
                catch (NotFoundException e) {
                    if (updateOnly) {
                        log.warn("Unable to find existing glossary \u2014 skipping: {}", (Object)glossaryName);
                    } else {
                        builder = Glossary.creator((String)glossaryName);
                    }
                }
                catch (AtlanException e) {
                    log.error("Unable to even search for the glossary: {}", (Object)glossaryName, (Object)e);
                }
            }
            if (builder == null) continue;
            builder = (Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)((Glossary.GlossaryBuilder)builder.description(details.getDescription())).userDescription(details.getUserDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups());
            if (details.getCustomMetadataValues() != null) {
                builder = (Glossary.GlossaryBuilder)builder.customMetadataSets(details.getCustomMetadataValues());
            }
            Glossary glossary = builder.build();
            String readmeContents = details.getReadme();
            if (readmeContents != null && readmeContents.length() > 0) {
                readmes.put(details.getIdentity(), readmeContents);
            }
            try {
                AssetMutationResponse result;
                AssetMutationResponse assetMutationResponse = result = replaceCM ? glossary.upsertReplacingCM(replaceClassifications) : glossary.upsertMergingCM(replaceClassifications);
                if (result != null) {
                    List created = result.getCreatedAssets();
                    for (Asset one : created) {
                        if (!(one instanceof Glossary) || !one.getName().equals(glossaryName)) continue;
                        glossaryNameToResult.put(glossaryName, one);
                    }
                    List updated = result.getUpdatedAssets();
                    for (Asset one : updated) {
                        if (!(one instanceof Glossary) || !one.getName().equals(glossaryName)) continue;
                        glossaryNameToResult.put(glossaryName, one);
                    }
                }
                if (!glossaryNameToResult.containsKey(glossaryName)) {
                    glossaryNameToResult.put(glossaryName, (Asset)glossary);
                }
            }
            catch (AtlanException e) {
                log.error("Unable to upsert glossary: {}", (Object)details.getIdentity());
            }
            if (replaceCM || details.getCustomMetadataValues().isEmpty() || (resolved = glossaryNameToResult.get(details.getIdentity())) == null) continue;
            cmToUpdate.put(resolved.getGuid(), details.getCustomMetadataValues());
        }
        if (!replaceCM) {
            GlossaryEnrichmentDetails.selectivelyUpdateCustomMetadata(cmToUpdate);
        }
        try {
            AssetBatch readmeBatch = new AssetBatch("Readme", batchSize);
            for (Map.Entry entry : readmes.entrySet()) {
                String glossaryName = (String)entry.getKey();
                String readmeContent = (String)entry.getValue();
                Asset glossary = glossaryNameToResult.get(glossaryName);
                if (glossary != null) {
                    Readme readme = Readme.creator((Asset)glossary, (String)glossaryName, (String)readmeContent).build();
                    readmeBatch.add((Asset)readme);
                    continue;
                }
                log.error("Unable to find glossary GUID for {} \u2014 cannot add README.", (Object)glossaryName);
            }
            readmeBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert READMEs for glossaries.", (Throwable)e);
        }
        return glossaryNameToResult;
    }

    protected GlossaryEnrichmentDetails(GlossaryEnrichmentDetailsBuilder<?, ?> b) {
        super((EnrichmentDetails.EnrichmentDetailsBuilder<?, ?>)b);
        this.name = b.name;
    }

    public static GlossaryEnrichmentDetailsBuilder<?, ?> builder() {
        return new GlossaryEnrichmentDetailsBuilderImpl();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlossaryEnrichmentDetails)) {
            return false;
        }
        GlossaryEnrichmentDetails other = (GlossaryEnrichmentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GlossaryEnrichmentDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GlossaryEnrichmentDetails(super=" + super.toString() + ", name=" + this.getName() + ")";
    }

    private static final class GlossaryEnrichmentDetailsBuilderImpl
    extends GlossaryEnrichmentDetailsBuilder<GlossaryEnrichmentDetails, GlossaryEnrichmentDetailsBuilderImpl> {
        private GlossaryEnrichmentDetailsBuilderImpl() {
        }

        @Override
        protected GlossaryEnrichmentDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public GlossaryEnrichmentDetails build() {
            return new GlossaryEnrichmentDetails(this);
        }
    }

    public static abstract class GlossaryEnrichmentDetailsBuilder<C extends GlossaryEnrichmentDetails, B extends GlossaryEnrichmentDetailsBuilder<C, B>>
    extends EnrichmentDetails.EnrichmentDetailsBuilder<C, B> {
        private String name;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "GlossaryEnrichmentDetails.GlossaryEnrichmentDetailsBuilder(super=" + super.toString() + ", name=" + this.name + ")";
        }
    }
}

