/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.ADLSObject;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GCSObject;
import com.atlan.model.assets.IS3;
import com.atlan.model.assets.S3Object;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.BucketDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(ObjectDetails.class);
    public static final String COL_OBJECT_NAME = "OBJECT NAME";
    public static final String COL_OBJECT_ARN = "OBJECT ARN";
    public static final String COL_OBJECT_PATH = "OBJECT PATH";
    public static final String COL_OBJECT_SIZE = "OBJECT SIZE";
    public static final String COL_CONTENT_TYPE = "CONTENT TYPE";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "BUCKET NAME", "OBJECT NAME");
    private String connectionQualifiedName;
    private String containerQualifiedName;
    private String bucketName;
    private String name;
    private String arn;
    private String path;
    private Long size;
    private String contentType;

    @Override
    public String getIdentity() {
        return this.containerQualifiedName + "/" + this.name;
    }

    public static ObjectDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        Object builder = ObjectDetails.getFromRow(ObjectDetails.builder(), row, delim);
        if (ObjectDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String connectionQN = ConnectionDetails.getQualifiedName(connectionCache, row);
            String bucketQN = BucketDetails.getQualifiedName(connectionCache, row);
            if (bucketQN != null && bucketQN.length() > 0) {
                builder = ((ObjectDetailsBuilder)((ObjectDetailsBuilder)((ObjectDetailsBuilder)((ObjectDetailsBuilder)((ObjectDetailsBuilder)((ObjectDetailsBuilder)((ObjectDetailsBuilder)builder).connectionQualifiedName(connectionQN)).containerQualifiedName(bucketQN)).bucketName(row.get("BUCKET NAME"))).name(row.get(COL_OBJECT_NAME))).arn(row.get(COL_OBJECT_ARN))).path(row.get(COL_OBJECT_PATH))).contentType(row.get(COL_CONTENT_TYPE));
                String size = row.get(COL_OBJECT_SIZE);
                try {
                    builder = ((ObjectDetailsBuilder)builder).size(Double.valueOf(size).longValue());
                }
                catch (NumberFormatException e) {
                    log.error("Unable to translate provided object size to a number: {}", (Object)size, (Object)e);
                }
                return ((ObjectDetailsBuilder)((AssetDetails.AssetDetailsBuilder)builder).stub(false)).build();
            }
        }
        return null;
    }

    public static Set<String> upsert(Map<String, ObjectDetails> objects, int batchSize, boolean updateOnly) {
        HashSet<String> parents = new HashSet<String>();
        AssetBatch batch = new AssetBatch("object", batchSize);
        HashMap<String, List<String>> toClassifyS3 = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyGCS = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyADLS = new HashMap<String, List<String>>();
        try {
            for (ObjectDetails details : objects.values()) {
                String parentQN = details.getContainerQualifiedName();
                String bucketName = details.getBucketName();
                String objectName = details.getName();
                String objectARN = details.getArn();
                AtlanConnectorType objectType = Connection.getConnectorTypeFromQualifiedName((String)parentQN);
                switch (objectType) {
                    case S3: {
                        GCSObject toUpdate;
                        String qualifiedName;
                        String connectionQN = details.getConnectionQualifiedName();
                        if (objectARN != null && objectARN.length() > 0) {
                            if (updateOnly) {
                                qualifiedName = IS3.generateQualifiedName((String)connectionQN, (String)objectARN);
                                try {
                                    Asset.retrieveMinimal((String)"S3Object", (String)qualifiedName);
                                    toUpdate = ((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)S3Object.updater((String)qualifiedName, (String)objectName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).s3ObjectKey(details.getPath()).s3ObjectSize(details.getSize()).s3ObjectContentType(details.getContentType()).build();
                                    if (!details.getAtlanTags().isEmpty()) {
                                        toClassifyS3.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                    }
                                    parents.add(parentQN);
                                    batch.add((Asset)toUpdate);
                                }
                                catch (NotFoundException e) {
                                    log.warn("Unable to find existing object \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                                }
                                catch (AtlanException e) {
                                    log.error("Unable to lookup whether object exists or not.", (Throwable)e);
                                }
                                break;
                            }
                            S3Object s3 = ((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)((S3Object.S3ObjectBuilder)S3Object.creator((String)objectName, (String)parentQN, (String)bucketName, (String)objectARN).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).s3ObjectKey(details.getPath()).s3ObjectSize(details.getSize()).s3ObjectContentType(details.getContentType()).build();
                            if (!details.getAtlanTags().isEmpty()) {
                                toClassifyS3.put(s3.getQualifiedName(), details.getAtlanTags());
                            }
                            parents.add(parentQN);
                            batch.add((Asset)s3);
                            break;
                        }
                        log.error("Unable to create an S3 object without an ARN: {}", (Object)details);
                        break;
                    }
                    case GCS: {
                        GCSObject toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = GCSObject.generateQualifiedName((String)objectName, (String)parentQN);
                            try {
                                Asset.retrieveMinimal((String)"GCSObject", (String)qualifiedName);
                                toUpdate = ((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)GCSObject.updater((String)qualifiedName, (String)objectName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).gcsObjectKey(details.getPath()).gcsObjectSize(details.getSize()).gcsObjectContentType(details.getContentType()).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyGCS.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                parents.add(parentQN);
                                batch.add((Asset)toUpdate);
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing object \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether object exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        GCSObject gcs = ((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)((GCSObject.GCSObjectBuilder)GCSObject.creator((String)objectName, (String)parentQN).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).gcsObjectKey(details.getPath()).gcsObjectSize(details.getSize()).gcsObjectContentType(details.getContentType()).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyGCS.put(gcs.getQualifiedName(), details.getAtlanTags());
                        }
                        parents.add(parentQN);
                        batch.add((Asset)gcs);
                        break;
                    }
                    case ADLS: {
                        GCSObject toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = ADLSObject.generateQualifiedName((String)objectName, (String)parentQN);
                            try {
                                Asset.retrieveMinimal((String)"ADLSObject", (String)qualifiedName);
                                toUpdate = ((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)ADLSObject.updater((String)qualifiedName, (String)objectName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).adlsObjectUrl(details.getPath()).adlsObjectSize(details.getSize()).adlsObjectContentType(details.getContentType()).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyADLS.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                parents.add(parentQN);
                                batch.add((Asset)toUpdate);
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing object \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether object exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        ADLSObject adls = ((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)((ADLSObject.ADLSObjectBuilder)ADLSObject.creator((String)objectName, (String)parentQN).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).adlsObjectUrl(details.getPath()).adlsObjectSize(details.getSize()).adlsObjectContentType(details.getContentType()).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyADLS.put(adls.getQualifiedName(), details.getAtlanTags());
                        }
                        parents.add(parentQN);
                        batch.add((Asset)adls);
                        break;
                    }
                    default: {
                        log.error("Invalid object type ({}) \u2014 skipping: {}", (Object)objectType, (Object)details);
                    }
                }
            }
            batch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert object details.", (Throwable)e);
        }
        ObjectDetails.appendAtlanTags(toClassifyS3, "S3Object");
        ObjectDetails.appendAtlanTags(toClassifyGCS, "GCSObject");
        ObjectDetails.appendAtlanTags(toClassifyADLS, "ADLSObject");
        return parents;
    }

    protected ObjectDetails(ObjectDetailsBuilder<?, ?> b) {
        super(b);
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.containerQualifiedName = b.containerQualifiedName;
        this.bucketName = b.bucketName;
        this.name = b.name;
        this.arn = b.arn;
        this.path = b.path;
        this.size = b.size;
        this.contentType = b.contentType;
    }

    public static ObjectDetailsBuilder<?, ?> builder() {
        return new ObjectDetailsBuilderImpl();
    }

    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    public String getContainerQualifiedName() {
        return this.containerQualifiedName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getName() {
        return this.name;
    }

    public String getArn() {
        return this.arn;
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectDetails)) {
            return false;
        }
        ObjectDetails other = (ObjectDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        String this$containerQualifiedName = this.getContainerQualifiedName();
        String other$containerQualifiedName = other.getContainerQualifiedName();
        if (this$containerQualifiedName == null ? other$containerQualifiedName != null : !this$containerQualifiedName.equals(other$containerQualifiedName)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$arn = this.getArn();
        String other$arn = other.getArn();
        if (this$arn == null ? other$arn != null : !this$arn.equals(other$arn)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        String $containerQualifiedName = this.getContainerQualifiedName();
        result = result * 59 + ($containerQualifiedName == null ? 43 : $containerQualifiedName.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $arn = this.getArn();
        result = result * 59 + ($arn == null ? 43 : $arn.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ObjectDetails(super=" + super.toString() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", containerQualifiedName=" + this.getContainerQualifiedName() + ", bucketName=" + this.getBucketName() + ", name=" + this.getName() + ", arn=" + this.getArn() + ", path=" + this.getPath() + ", size=" + this.getSize() + ", contentType=" + this.getContentType() + ")";
    }

    private static final class ObjectDetailsBuilderImpl
    extends ObjectDetailsBuilder<ObjectDetails, ObjectDetailsBuilderImpl> {
        private ObjectDetailsBuilderImpl() {
        }

        @Override
        protected ObjectDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ObjectDetails build() {
            return new ObjectDetails(this);
        }
    }

    public static abstract class ObjectDetailsBuilder<C extends ObjectDetails, B extends ObjectDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String connectionQualifiedName;
        private String containerQualifiedName;
        private String bucketName;
        private String name;
        private String arn;
        private String path;
        private Long size;
        private String contentType;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        public B containerQualifiedName(String containerQualifiedName) {
            this.containerQualifiedName = containerQualifiedName;
            return (B)this.self();
        }

        public B bucketName(String bucketName) {
            this.bucketName = bucketName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B arn(String arn) {
            this.arn = arn;
            return (B)this.self();
        }

        public B path(String path) {
            this.path = path;
            return (B)this.self();
        }

        public B size(Long size) {
            this.size = size;
            return (B)this.self();
        }

        public B contentType(String contentType) {
            this.contentType = contentType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ObjectDetails.ObjectDetailsBuilder(super=" + super.toString() + ", connectionQualifiedName=" + this.connectionQualifiedName + ", containerQualifiedName=" + this.containerQualifiedName + ", bucketName=" + this.bucketName + ", name=" + this.name + ", arn=" + this.arn + ", path=" + this.path + ", size=" + this.size + ", contentType=" + this.contentType + ")";
        }
    }
}

