/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Schema;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.samples.loaders.models.DatabaseDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(SchemaDetails.class);
    public static final String COL_SCHEMA = "SCHEMA NAME";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "DATABASE NAME", "SCHEMA NAME");
    private static final List<String> REQUIRED_EMPTY = List.of("CONTAINER NAME", "COLUMN NAME");
    private String databaseQualifiedName;
    private String name;

    @Override
    public String getIdentity() {
        return this.databaseQualifiedName + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        String schemaName;
        String databaseQN = DatabaseDetails.getQualifiedName(connectionCache, row);
        if (databaseQN != null && (schemaName = row.get(COL_SCHEMA)) != null) {
            return databaseQN + "/" + schemaName;
        }
        return null;
    }

    public static SchemaDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        if (SchemaDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String databaseQualifiedName = DatabaseDetails.getQualifiedName(connectionCache, row);
            if (SchemaDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((SchemaDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((SchemaDetailsBuilder)SchemaDetails.getFromRow(SchemaDetails.builder(), row, delim).databaseQualifiedName(databaseQualifiedName)).name(row.get(COL_SCHEMA))).stub(false)).build();
            }
            return ((SchemaDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((SchemaDetailsBuilder)SchemaDetails.builder().databaseQualifiedName(databaseQualifiedName)).name(row.get(COL_SCHEMA))).stub(true)).build();
        }
        return null;
    }

    public static Set<String> upsert(Map<String, SchemaDetails> schemas, int batchSize, boolean updateOnly) {
        HashSet<String> parents = new HashSet<String>();
        AssetBatch batch = new AssetBatch("Schema", batchSize);
        HashMap<String, List<String>> toClassify = new HashMap<String, List<String>>();
        try {
            for (SchemaDetails details : schemas.values()) {
                String databaseQualifiedName = details.getDatabaseQualifiedName();
                String schemaName = details.getName();
                if (updateOnly) {
                    String qualifiedName = Schema.generateQualifiedName((String)schemaName, (String)databaseQualifiedName);
                    try {
                        Asset.retrieveMinimal((String)"Schema", (String)qualifiedName);
                        Schema toUpdate = ((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)Schema.updater((String)qualifiedName, (String)schemaName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassify.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                        }
                        batch.add((Asset)toUpdate);
                        parents.add(databaseQualifiedName);
                    }
                    catch (NotFoundException e) {
                        log.warn("Unable to find existing schema \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to lookup whether schema exists or not.", (Throwable)e);
                    }
                    continue;
                }
                Schema schema = ((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)((Schema.SchemaBuilder)Schema.creator((String)schemaName, (String)databaseQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                if (!details.getAtlanTags().isEmpty()) {
                    toClassify.put(schema.getQualifiedName(), details.getAtlanTags());
                }
                batch.add((Asset)schema);
                parents.add(databaseQualifiedName);
            }
            batch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert schema details.", (Throwable)e);
        }
        SchemaDetails.appendAtlanTags(toClassify, "Schema");
        return parents;
    }

    protected SchemaDetails(SchemaDetailsBuilder<?, ?> b) {
        super(b);
        this.databaseQualifiedName = b.databaseQualifiedName;
        this.name = b.name;
    }

    public static SchemaDetailsBuilder<?, ?> builder() {
        return new SchemaDetailsBuilderImpl();
    }

    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaDetails)) {
            return false;
        }
        SchemaDetails other = (SchemaDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SchemaDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SchemaDetails(super=" + super.toString() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", name=" + this.getName() + ")";
    }

    private static final class SchemaDetailsBuilderImpl
    extends SchemaDetailsBuilder<SchemaDetails, SchemaDetailsBuilderImpl> {
        private SchemaDetailsBuilderImpl() {
        }

        @Override
        protected SchemaDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public SchemaDetails build() {
            return new SchemaDetails(this);
        }
    }

    public static abstract class SchemaDetailsBuilder<C extends SchemaDetails, B extends SchemaDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String databaseQualifiedName;
        private String name;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SchemaDetails.SchemaDetailsBuilder(super=" + super.toString() + ", databaseQualifiedName=" + this.databaseQualifiedName + ", name=" + this.name + ")";
        }
    }
}

