/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.samples.loaders.caches.CategoryCache;
import com.atlan.samples.loaders.caches.GlossaryCache;
import com.atlan.samples.loaders.caches.TermCache;
import com.atlan.samples.loaders.models.CategoryEnrichmentDetails;
import com.atlan.samples.loaders.models.EnrichmentDetails;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermEnrichmentDetails
extends EnrichmentDetails {
    private static final Logger log = LoggerFactory.getLogger(TermEnrichmentDetails.class);
    public static final String COL_GLOSSARY = "GLOSSARY NAME";
    public static final String COL_TERM_NAME = "TERM NAME*";
    public static final String COL_CATEGORIES = "CATEGORIES";
    public static final String COL_T_RELATED = "RELATED TERMS";
    public static final String COL_T_RECOMMENDED = "RECOMMENDED TERMS";
    public static final String COL_T_SYNONYMS = "SYNONYMS";
    public static final String COL_T_ANTONYMS = "ANTONYMS";
    public static final String COL_T_TRANSLATED = "TRANSLATED TERMS";
    public static final String COL_T_VALID_VALUES = "VALID VALUES FOR";
    public static final String COL_T_CLASSIFIES = "CLASSIFIES";
    private static final List<String> REQUIRED = List.of("GLOSSARY NAME", "TERM NAME*");
    static final String glossaryDelimiter = "@";
    private Asset glossary;
    private String name;
    private String userDescription;
    private List<Asset> categories;
    private String readme;
    private List<String> relatedTerms;
    private List<String> recommendedTerms;
    private List<String> synonyms;
    private List<String> antonyms;
    private List<String> translatedTerms;
    private List<String> validValuesFor;
    private List<String> classifies;

    private boolean hasTermToTermRelationships() {
        return !this.relatedTerms.isEmpty() || !this.recommendedTerms.isEmpty() || !this.synonyms.isEmpty() || !this.antonyms.isEmpty() || !this.translatedTerms.isEmpty() || !this.validValuesFor.isEmpty() || !this.classifies.isEmpty();
    }

    @Override
    public String getIdentity() {
        return this.name + glossaryDelimiter + this.glossary.getName();
    }

    public static String getNameFromIdentity(String identity) {
        if (identity != null && identity.contains(glossaryDelimiter)) {
            return identity.substring(0, identity.indexOf(glossaryDelimiter));
        }
        return null;
    }

    public static String getGlossaryNameFromIdentity(String identity) {
        if (identity != null && identity.contains(glossaryDelimiter)) {
            return identity.substring(identity.indexOf(glossaryDelimiter) + glossaryDelimiter.length());
        }
        return null;
    }

    public static TermEnrichmentDetails getFromRow(GlossaryCache glossaryCache, CategoryCache categoryCache, Map<String, String> row, String delim) {
        TermEnrichmentDetailsBuilder<Object, Object> builder = TermEnrichmentDetails.getFromRow(TermEnrichmentDetails.builder(), row, delim);
        if (TermEnrichmentDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            Asset glossary = glossaryCache.get(row.get(COL_GLOSSARY));
            if (glossary != null) {
                String termName = row.get(COL_TERM_NAME);
                List<String> categoryPaths = TermEnrichmentDetails.getMultiValuedList(row.get(COL_CATEGORIES), delim);
                ArrayList<Asset> categories = new ArrayList<Asset>();
                for (String categoryPath : categoryPaths) {
                    String categoryIdentity = CategoryEnrichmentDetails.getIdentity(categoryPath, glossary);
                    Asset category = categoryCache.get(categoryIdentity);
                    if (category != null) {
                        categories.add(category);
                        continue;
                    }
                    log.warn("Unable to find category {} for term {} \u2014 skipping this categorization.", (Object)categoryIdentity, (Object)termName);
                }
                builder = ((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)((TermEnrichmentDetailsBuilder)builder.glossary(glossary)).name(termName)).userDescription(row.get("USER DESCRIPTION"))).readme(row.get("README")).customMetadataValues(TermEnrichmentDetails.getCustomMetadataValuesFromRow(row, delim))).categories(categories)).relatedTerms(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_RELATED), delim))).recommendedTerms(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_RECOMMENDED), delim))).synonyms(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_SYNONYMS), delim))).antonyms(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_ANTONYMS), delim))).translatedTerms(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_TRANSLATED), delim))).validValuesFor(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_VALID_VALUES), delim))).classifies(TermEnrichmentDetails.getMultiValuedList(row.get(COL_T_CLASSIFIES), delim));
                return ((TermEnrichmentDetailsBuilder)builder.stub(false)).build();
            }
            log.warn("Unknown glossary {} \u2014 skipping term: {}", (Object)row.get(COL_GLOSSARY), (Object)row.get(COL_TERM_NAME));
        }
        return null;
    }

    public static TermCache upsert(Map<String, TermEnrichmentDetails> terms, int batchSize, boolean replaceAtlanTags, boolean replaceCM, boolean updateOnly) {
        Asset term;
        TermCache termIdentityToResult = new TermCache();
        HashMap<String, List<String>> toTag = new HashMap<String, List<String>>();
        HashMap<String, Map<String, CustomMetadataAttributes>> cmToUpdate = new HashMap<String, Map<String, CustomMetadataAttributes>>();
        HashMap<String, String> readmes = new HashMap<String, String>();
        HashMap<String, TermEnrichmentDetails> termToTerm = new HashMap<String, TermEnrichmentDetails>();
        for (TermEnrichmentDetails details : terms.values()) {
            String string;
            Asset asset;
            Asset asset2;
            Asset glossary = details.getGlossary();
            if (glossary == null) continue;
            String termName = details.getName();
            GlossaryTerm.GlossaryTermBuilder builder = null;
            try {
                GlossaryTerm found = GlossaryTerm.findByNameFast((String)termName, (String)glossary.getQualifiedName(), List.of("anchor"));
                builder = (GlossaryTerm.GlossaryTermBuilder)found.trimToRequired().guid(found.getGuid());
            }
            catch (NotFoundException e) {
                if (updateOnly) {
                    log.warn("Unable to find existing term \u2014 skipping: {}@{}", (Object)termName, (Object)glossary.getName());
                } else {
                    builder = GlossaryTerm.creator((String)termName, (String)glossary.getGuid(), (String)glossary.getQualifiedName());
                }
            }
            catch (AtlanException e) {
                log.error("Unable to even search for the term: {}", (Object)details.getIdentity(), (Object)e);
            }
            if (builder == null) continue;
            builder = (GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)builder.description(details.getDescription())).userDescription(details.getUserDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups());
            for (Asset asset3 : details.getCategories()) {
                builder = builder.category((IGlossaryCategory)GlossaryCategory.refByGuid((String)asset3.getGuid()));
            }
            if (details.getCustomMetadataValues() != null) {
                builder = (GlossaryTerm.GlossaryTermBuilder)builder.customMetadataSets(details.getCustomMetadataValues());
            }
            if (details.getAtlanTags() != null) {
                List<String> clsNames = details.getAtlanTags();
                for (String clsName : clsNames) {
                    builder = (GlossaryTerm.GlossaryTermBuilder)builder.atlanTag(AtlanTag.of((String)clsName));
                }
            }
            term = builder.build();
            try {
                AssetMutationResponse assetMutationResponse;
                AssetMutationResponse assetMutationResponse2 = assetMutationResponse = replaceCM ? term.upsertReplacingCM(replaceAtlanTags) : term.upsertMergingCM(replaceAtlanTags);
                if (assetMutationResponse != null) {
                    List updated;
                    List created = assetMutationResponse.getCreatedAssets();
                    if (created != null) {
                        for (Asset one : created) {
                            if (!one.getName().equals(termName)) continue;
                            termIdentityToResult.put(details.getIdentity(), (Asset)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)term.toBuilder().qualifiedName(one.getQualifiedName())).guid(one.getGuid())).build());
                        }
                    }
                    if ((updated = assetMutationResponse.getUpdatedAssets()) != null) {
                        Asset one;
                        one = updated.iterator();
                        while (one.hasNext()) {
                            Asset one2 = (Asset)one.next();
                            if (!one2.getName().equals(termName)) continue;
                            termIdentityToResult.put(details.getIdentity(), (Asset)((GlossaryTerm.GlossaryTermBuilder)((GlossaryTerm.GlossaryTermBuilder)term.toBuilder().qualifiedName(one2.getQualifiedName())).guid(one2.getGuid())).build());
                        }
                    }
                }
                if (!termIdentityToResult.containsKey(details.getIdentity())) {
                    termIdentityToResult.put(details.getIdentity(), term);
                }
            }
            catch (AtlanException atlanException) {
                log.error("Unable to upsert term: {}", (Object)details.getIdentity(), (Object)atlanException);
            }
            if (!replaceAtlanTags && !details.getAtlanTags().isEmpty() && (asset2 = termIdentityToResult.get(details.getIdentity())) != null) {
                toTag.put(asset2.getQualifiedName(), details.getAtlanTags());
            }
            if (!replaceCM && !details.getCustomMetadataValues().isEmpty() && (asset = termIdentityToResult.get(details.getIdentity())) != null) {
                cmToUpdate.put(asset.getGuid(), details.getCustomMetadataValues());
            }
            if ((string = details.getReadme()) != null && string.length() > 0) {
                readmes.put(details.getIdentity(), string);
            }
            if (!details.hasTermToTermRelationships()) continue;
            termToTerm.put(details.getIdentity(), details);
        }
        if (!replaceAtlanTags) {
            TermEnrichmentDetails.appendAtlanTags(toTag, "AtlasGlossaryTerm");
        }
        if (!replaceCM) {
            TermEnrichmentDetails.selectivelyUpdateCustomMetadata(cmToUpdate);
        }
        try {
            AssetBatch readmeBatch = new AssetBatch("Readme", batchSize);
            for (Map.Entry entry : readmes.entrySet()) {
                String termIdentity = (String)entry.getKey();
                String readmeContent = (String)entry.getValue();
                term = termIdentityToResult.get(termIdentity);
                if (term != null) {
                    Readme readme = Readme.creator((Asset)term, (String)term.getName(), (String)readmeContent).build();
                    readmeBatch.add((Asset)readme);
                    continue;
                }
                log.error("Unable to find term GUID for {} \u2014 cannot add README.", (Object)termIdentity);
            }
            readmeBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert READMEs for terms.", (Throwable)e);
        }
        try {
            AssetBatch termToTermBatch = new AssetBatch("term-to-term relationship", batchSize);
            for (Map.Entry entry : termToTerm.entrySet()) {
                String identity = (String)entry.getKey();
                TermEnrichmentDetails t2tDetails = (TermEnrichmentDetails)entry.getValue();
                Asset asset = termIdentityToResult.get(identity);
                if (!(asset instanceof GlossaryTerm)) continue;
                GlossaryTerm glossaryTerm = (GlossaryTerm)asset;
                try {
                    GlossaryTerm.GlossaryTermBuilder toUpdate = glossaryTerm.trimToRequired();
                    for (String t2tRelated : t2tDetails.getRelatedTerms()) {
                        Asset related = termIdentityToResult.get(t2tRelated);
                        if (related != null) {
                            toUpdate = toUpdate.seeAlsoOne((IGlossaryTerm)GlossaryTerm.refByGuid((String)related.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find related term: {}", (Object)t2tRelated);
                    }
                    for (String t2tRecommended : t2tDetails.getRecommendedTerms()) {
                        Asset recommended = termIdentityToResult.get(t2tRecommended);
                        if (recommended != null) {
                            toUpdate = toUpdate.preferredTerm((IGlossaryTerm)GlossaryTerm.refByGuid((String)recommended.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find recommended term: {}", (Object)t2tRecommended);
                    }
                    for (String t2tSynonym : t2tDetails.getSynonyms()) {
                        Asset synonym = termIdentityToResult.get(t2tSynonym);
                        if (synonym != null) {
                            toUpdate = toUpdate.synonym((IGlossaryTerm)GlossaryTerm.refByGuid((String)synonym.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find synonym: {}", (Object)t2tSynonym);
                    }
                    for (String t2tAntonym : t2tDetails.getAntonyms()) {
                        Asset antonym = termIdentityToResult.get(t2tAntonym);
                        if (antonym != null) {
                            toUpdate = toUpdate.antonym((IGlossaryTerm)GlossaryTerm.refByGuid((String)antonym.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find antonym: {}", (Object)t2tAntonym);
                    }
                    for (String t2tTranslated : t2tDetails.getTranslatedTerms()) {
                        Asset translated = termIdentityToResult.get(t2tTranslated);
                        if (translated != null) {
                            toUpdate = toUpdate.translatedTerm((IGlossaryTerm)GlossaryTerm.refByGuid((String)translated.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find translated term: {}", (Object)t2tTranslated);
                    }
                    for (String t2tValidFor : t2tDetails.getValidValuesFor()) {
                        Asset valid = termIdentityToResult.get(t2tValidFor);
                        if (valid != null) {
                            toUpdate = toUpdate.validValueFor((IGlossaryTerm)GlossaryTerm.refByGuid((String)valid.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find related valid values for: {}", (Object)t2tValidFor);
                    }
                    for (String t2tClassifies : t2tDetails.getClassifies()) {
                        Asset classifies = termIdentityToResult.get(t2tClassifies);
                        if (classifies != null) {
                            toUpdate = toUpdate.classify((IGlossaryTerm)GlossaryTerm.refByGuid((String)classifies.getGuid()));
                            continue;
                        }
                        log.warn("Unable to find related classifies: {}", (Object)t2tClassifies);
                    }
                    termToTermBatch.add((Asset)toUpdate.build());
                }
                catch (InvalidRequestException e) {
                    log.error("Missing key information to be able to set term-to-term relationships for: {}", (Object)identity, (Object)e);
                }
            }
            termToTermBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert term-to-term relationships.", (Throwable)e);
        }
        return termIdentityToResult;
    }

    protected TermEnrichmentDetails(TermEnrichmentDetailsBuilder<?, ?> b) {
        super((EnrichmentDetails.EnrichmentDetailsBuilder<?, ?>)b);
        this.glossary = b.glossary;
        this.name = b.name;
        this.userDescription = b.userDescription;
        this.categories = b.categories;
        this.readme = b.readme;
        this.relatedTerms = b.relatedTerms;
        this.recommendedTerms = b.recommendedTerms;
        this.synonyms = b.synonyms;
        this.antonyms = b.antonyms;
        this.translatedTerms = b.translatedTerms;
        this.validValuesFor = b.validValuesFor;
        this.classifies = b.classifies;
    }

    public static TermEnrichmentDetailsBuilder<?, ?> builder() {
        return new TermEnrichmentDetailsBuilderImpl();
    }

    public Asset getGlossary() {
        return this.glossary;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getUserDescription() {
        return this.userDescription;
    }

    public List<Asset> getCategories() {
        return this.categories;
    }

    @Override
    public String getReadme() {
        return this.readme;
    }

    public List<String> getRelatedTerms() {
        return this.relatedTerms;
    }

    public List<String> getRecommendedTerms() {
        return this.recommendedTerms;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public List<String> getAntonyms() {
        return this.antonyms;
    }

    public List<String> getTranslatedTerms() {
        return this.translatedTerms;
    }

    public List<String> getValidValuesFor() {
        return this.validValuesFor;
    }

    public List<String> getClassifies() {
        return this.classifies;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TermEnrichmentDetails)) {
            return false;
        }
        TermEnrichmentDetails other = (TermEnrichmentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asset this$glossary = this.getGlossary();
        Asset other$glossary = other.getGlossary();
        if (this$glossary == null ? other$glossary != null : !this$glossary.equals(other$glossary)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$userDescription = this.getUserDescription();
        String other$userDescription = other.getUserDescription();
        if (this$userDescription == null ? other$userDescription != null : !this$userDescription.equals(other$userDescription)) {
            return false;
        }
        List<Asset> this$categories = this.getCategories();
        List<Asset> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        String this$readme = this.getReadme();
        String other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !this$readme.equals(other$readme)) {
            return false;
        }
        List<String> this$relatedTerms = this.getRelatedTerms();
        List<String> other$relatedTerms = other.getRelatedTerms();
        if (this$relatedTerms == null ? other$relatedTerms != null : !((Object)this$relatedTerms).equals(other$relatedTerms)) {
            return false;
        }
        List<String> this$recommendedTerms = this.getRecommendedTerms();
        List<String> other$recommendedTerms = other.getRecommendedTerms();
        if (this$recommendedTerms == null ? other$recommendedTerms != null : !((Object)this$recommendedTerms).equals(other$recommendedTerms)) {
            return false;
        }
        List<String> this$synonyms = this.getSynonyms();
        List<String> other$synonyms = other.getSynonyms();
        if (this$synonyms == null ? other$synonyms != null : !((Object)this$synonyms).equals(other$synonyms)) {
            return false;
        }
        List<String> this$antonyms = this.getAntonyms();
        List<String> other$antonyms = other.getAntonyms();
        if (this$antonyms == null ? other$antonyms != null : !((Object)this$antonyms).equals(other$antonyms)) {
            return false;
        }
        List<String> this$translatedTerms = this.getTranslatedTerms();
        List<String> other$translatedTerms = other.getTranslatedTerms();
        if (this$translatedTerms == null ? other$translatedTerms != null : !((Object)this$translatedTerms).equals(other$translatedTerms)) {
            return false;
        }
        List<String> this$validValuesFor = this.getValidValuesFor();
        List<String> other$validValuesFor = other.getValidValuesFor();
        if (this$validValuesFor == null ? other$validValuesFor != null : !((Object)this$validValuesFor).equals(other$validValuesFor)) {
            return false;
        }
        List<String> this$classifies = this.getClassifies();
        List<String> other$classifies = other.getClassifies();
        return !(this$classifies == null ? other$classifies != null : !((Object)this$classifies).equals(other$classifies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TermEnrichmentDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asset $glossary = this.getGlossary();
        result = result * 59 + ($glossary == null ? 43 : $glossary.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $userDescription = this.getUserDescription();
        result = result * 59 + ($userDescription == null ? 43 : $userDescription.hashCode());
        List<Asset> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        String $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : $readme.hashCode());
        List<String> $relatedTerms = this.getRelatedTerms();
        result = result * 59 + ($relatedTerms == null ? 43 : ((Object)$relatedTerms).hashCode());
        List<String> $recommendedTerms = this.getRecommendedTerms();
        result = result * 59 + ($recommendedTerms == null ? 43 : ((Object)$recommendedTerms).hashCode());
        List<String> $synonyms = this.getSynonyms();
        result = result * 59 + ($synonyms == null ? 43 : ((Object)$synonyms).hashCode());
        List<String> $antonyms = this.getAntonyms();
        result = result * 59 + ($antonyms == null ? 43 : ((Object)$antonyms).hashCode());
        List<String> $translatedTerms = this.getTranslatedTerms();
        result = result * 59 + ($translatedTerms == null ? 43 : ((Object)$translatedTerms).hashCode());
        List<String> $validValuesFor = this.getValidValuesFor();
        result = result * 59 + ($validValuesFor == null ? 43 : ((Object)$validValuesFor).hashCode());
        List<String> $classifies = this.getClassifies();
        result = result * 59 + ($classifies == null ? 43 : ((Object)$classifies).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TermEnrichmentDetails(super=" + super.toString() + ", glossary=" + this.getGlossary() + ", name=" + this.getName() + ", userDescription=" + this.getUserDescription() + ", categories=" + this.getCategories() + ", readme=" + this.getReadme() + ", relatedTerms=" + this.getRelatedTerms() + ", recommendedTerms=" + this.getRecommendedTerms() + ", synonyms=" + this.getSynonyms() + ", antonyms=" + this.getAntonyms() + ", translatedTerms=" + this.getTranslatedTerms() + ", validValuesFor=" + this.getValidValuesFor() + ", classifies=" + this.getClassifies() + ")";
    }

    private static final class TermEnrichmentDetailsBuilderImpl
    extends TermEnrichmentDetailsBuilder<TermEnrichmentDetails, TermEnrichmentDetailsBuilderImpl> {
        private TermEnrichmentDetailsBuilderImpl() {
        }

        @Override
        protected TermEnrichmentDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public TermEnrichmentDetails build() {
            return new TermEnrichmentDetails(this);
        }
    }

    public static abstract class TermEnrichmentDetailsBuilder<C extends TermEnrichmentDetails, B extends TermEnrichmentDetailsBuilder<C, B>>
    extends EnrichmentDetails.EnrichmentDetailsBuilder<C, B> {
        private Asset glossary;
        private String name;
        private String userDescription;
        private List<Asset> categories;
        private String readme;
        private List<String> relatedTerms;
        private List<String> recommendedTerms;
        private List<String> synonyms;
        private List<String> antonyms;
        private List<String> translatedTerms;
        private List<String> validValuesFor;
        private List<String> classifies;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B glossary(Asset glossary) {
            this.glossary = glossary;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public B userDescription(String userDescription) {
            this.userDescription = userDescription;
            return (B)this.self();
        }

        public B categories(List<Asset> categories) {
            this.categories = categories;
            return (B)this.self();
        }

        @Override
        public B readme(String readme) {
            this.readme = readme;
            return (B)this.self();
        }

        public B relatedTerms(List<String> relatedTerms) {
            this.relatedTerms = relatedTerms;
            return (B)this.self();
        }

        public B recommendedTerms(List<String> recommendedTerms) {
            this.recommendedTerms = recommendedTerms;
            return (B)this.self();
        }

        public B synonyms(List<String> synonyms) {
            this.synonyms = synonyms;
            return (B)this.self();
        }

        public B antonyms(List<String> antonyms) {
            this.antonyms = antonyms;
            return (B)this.self();
        }

        public B translatedTerms(List<String> translatedTerms) {
            this.translatedTerms = translatedTerms;
            return (B)this.self();
        }

        public B validValuesFor(List<String> validValuesFor) {
            this.validValuesFor = validValuesFor;
            return (B)this.self();
        }

        public B classifies(List<String> classifies) {
            this.classifies = classifies;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TermEnrichmentDetails.TermEnrichmentDetailsBuilder(super=" + super.toString() + ", glossary=" + this.glossary + ", name=" + this.name + ", userDescription=" + this.userDescription + ", categories=" + this.categories + ", readme=" + this.readme + ", relatedTerms=" + this.relatedTerms + ", recommendedTerms=" + this.recommendedTerms + ", synonyms=" + this.synonyms + ", antonyms=" + this.antonyms + ", translatedTerms=" + this.translatedTerms + ", validValuesFor=" + this.validValuesFor + ", classifies=" + this.classifies + ")";
        }
    }
}

