/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.readers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader {
    private final Workbook workbook;
    private final String caseSensitiveDelimiter;

    public ExcelReader(String fileLocation) throws IOException {
        this(fileLocation, "|");
    }

    public ExcelReader(String fileLocation, String caseSensitiveDelimiter) throws IOException {
        FileInputStream file = new FileInputStream(fileLocation);
        this.workbook = new XSSFWorkbook((InputStream)file);
        this.caseSensitiveDelimiter = caseSensitiveDelimiter;
    }

    public List<Map<String, String>> getRowsFromSheet(int index) {
        return this.getRowsFromSheet(index, 0);
    }

    public List<Map<String, String>> getRowsFromSheet(int index, int headerRow) {
        return this.getRowsFromSheet(this.workbook.getSheetAt(index), headerRow);
    }

    public List<Map<String, String>> getRowsFromSheet(String name) throws IOException {
        return this.getRowsFromSheet(name, 0);
    }

    public List<Map<String, String>> getRowsFromSheet(String name, int headerRow) throws IOException {
        Sheet sheet = this.workbook.getSheet(name);
        if (sheet == null) {
            throw new IOException("Could not find sheet with name '" + name + "' in the provided Excel file.");
        }
        return this.getRowsFromSheet(sheet, headerRow);
    }

    private List<Map<String, String>> getRowsFromSheet(Sheet data, int headerRow) {
        ArrayList<Map<String, String>> allRows = new ArrayList<Map<String, String>>();
        List<String> header = this.getHeaders(data.getRow(headerRow));
        for (Row row : data) {
            int rowIdx = row.getRowNum();
            if (rowIdx <= headerRow) continue;
            HashMap<String, Object> rowMapping = new HashMap<String, Object>();
            for (Cell cell : row) {
                Object value;
                int colIdx = cell.getColumnIndex();
                String colName = header.get(colIdx);
                switch (cell.getCellType()) {
                    case NUMERIC: {
                        value = new BigDecimal("" + cell.getNumericCellValue()).toPlainString();
                        break;
                    }
                    case BOOLEAN: {
                        value = "" + cell.getBooleanCellValue();
                        break;
                    }
                    case FORMULA: {
                        value = cell.getCellFormula();
                        break;
                    }
                    default: {
                        value = cell.getRichStringCellValue().getString();
                    }
                }
                rowMapping.put(colName, value);
            }
            if (rowMapping.isEmpty()) continue;
            allRows.add(rowMapping);
        }
        return allRows;
    }

    private List<String> getHeaders(Row header) {
        ArrayList<String> columns = new ArrayList<String>();
        for (Cell cell : header) {
            String name = cell.getRichStringCellValue().getString();
            if (name == null) continue;
            if (name.contains(this.caseSensitiveDelimiter)) {
                columns.add(name);
                continue;
            }
            if (name.length() <= 0) continue;
            columns.add(name.toUpperCase(Locale.ROOT));
        }
        return columns;
    }
}

