/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.readers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.OpenAPIV3Parser;

public class OpenAPISpecReader {
    private final OpenAPI spec;
    private final boolean hasInfo;
    private final boolean hasContact;
    private final boolean hasLicense;
    private final boolean hasExternalDocs;

    public OpenAPISpecReader(String url) {
        this.spec = new OpenAPIV3Parser().read(url);
        this.hasInfo = this.spec.getInfo() != null;
        this.hasContact = this.hasInfo && this.spec.getInfo().getContact() != null;
        this.hasLicense = this.hasInfo && this.spec.getInfo().getLicense() != null;
        this.hasExternalDocs = this.spec.getExternalDocs() != null;
    }

    public String getOpenAPIVersion() {
        return this.spec.getOpenapi();
    }

    public String getTitle() {
        return this.hasInfo ? this.spec.getInfo().getTitle() : null;
    }

    public String getDescription() {
        return this.hasInfo ? this.spec.getInfo().getDescription() : null;
    }

    public String getTermsOfServiceURL() {
        return this.hasInfo ? this.spec.getInfo().getTermsOfService() : null;
    }

    public String getContactEmail() {
        return this.hasContact ? this.spec.getInfo().getContact().getEmail() : null;
    }

    public String getContactName() {
        return this.hasContact ? this.spec.getInfo().getContact().getName() : null;
    }

    public String getContactURL() {
        return this.hasContact ? this.spec.getInfo().getContact().getUrl() : null;
    }

    public String getLicenseName() {
        return this.hasLicense ? this.spec.getInfo().getLicense().getName() : null;
    }

    public String getLicenseURL() {
        return this.hasLicense ? this.spec.getInfo().getLicense().getUrl() : null;
    }

    public String getVersion() {
        return this.hasInfo ? this.spec.getInfo().getVersion() : null;
    }

    public String getExternalDocsURL() {
        return this.hasExternalDocs ? this.spec.getExternalDocs().getUrl() : null;
    }

    public String getExternalDocsDescription() {
        return this.hasExternalDocs ? this.spec.getExternalDocs().getDescription() : null;
    }

    public Paths getPaths() {
        return this.spec.getPaths();
    }
}

