/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import com.atlan.Atlan;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IReadme;
import com.atlan.model.core.AtlanTag;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporter.class);
    public static final double BYTES_IN_GB = 1.073741824E9;
    public static final String TIMESTAMP_FORMAT = "uuuuMMdd-HHmmss-SSS";
    private int _batchSize = 50;
    private String _delimiter = "|";
    private Region _region = null;
    private String _bucket = null;
    private String _filename = null;

    protected void parseParametersFromEvent(Map<String, String> event) {
        if (event != null) {
            log.debug(" ... event: {}", event);
            String batchSize = event.getOrDefault("BATCH_SIZE", "50");
            try {
                this._batchSize = Integer.parseInt(batchSize);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the BATCH_SIZE value of '{}', falling back to a default of 50.", (Object)batchSize);
                this._batchSize = 50;
            }
            this._delimiter = event.getOrDefault("DELIMITER", "|");
            String region = event.getOrDefault("REGION", "ap-south-1");
            this._region = Region.of((String)region);
            this._bucket = event.getOrDefault("BUCKET", null);
            Atlan.setBaseUrl((String)event.getOrDefault("ATLAN_BASE_URL", null));
            Atlan.setApiToken((String)event.getOrDefault("ATLAN_API_KEY", null));
            String maxRetries = event.getOrDefault("MAX_RETRIES", "20");
            int _maxRetries = 20;
            try {
                _maxRetries = Integer.parseInt(maxRetries);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the MAX_RETRIES value of '{}', falling back to a default of 20.", (Object)maxRetries);
            }
            Atlan.setMaxNetworkRetries((int)_maxRetries);
        }
    }

    protected void setFilenameWithPrefix(Map<String, String> event, String prefix) {
        String timestamp = ZonedDateTime.now(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(TIMESTAMP_FORMAT));
        Object filename = event.getOrDefault("FILE_PREFIX", prefix);
        if (((String)filename).endsWith(".xls") || ((String)filename).endsWith(".xlsx")) {
            filename = ((String)filename).substring(0, ((String)filename).lastIndexOf(".xls"));
        }
        filename = (String)filename + "-" + timestamp + ".xlsx";
        this.setFilename((String)filename);
    }

    protected static String getFormattedDateTime(Long ts) {
        if (ts != null && ts > 0L) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return "";
    }

    protected static String getAssetLink(String guid) {
        return Atlan.getBaseUrlSafe() + "/assets/" + guid + "/overview";
    }

    protected static String getDescription(Asset asset) {
        String description = asset.getUserDescription();
        if (description == null || description.length() == 0) {
            description = asset.getDescription();
        }
        return description == null ? "" : description;
    }

    protected static String getUserOwners(Asset asset, String delimiter) {
        return AbstractReporter.getDelimitedList(asset.getOwnerUsers(), delimiter);
    }

    protected static String getGroupOwners(Asset asset, String delimiter) {
        return AbstractReporter.getDelimitedList(asset.getOwnerGroups(), delimiter);
    }

    protected static int getCount(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    protected static String getREADME(Asset asset) {
        String content;
        IReadme readme = asset.getReadme();
        if (readme != null && (content = readme.getDescription()) != null && content.length() > 0) {
            return content;
        }
        return "";
    }

    protected static String getAtlanTags(Asset asset, String delimiter) {
        SortedSet atlanTags = asset.getAtlanTags();
        if (atlanTags != null) {
            Set<String> atlanTagNames = atlanTags.stream().map(AtlanTag::getTypeName).collect(Collectors.toSet());
            return AbstractReporter.getDelimitedList(atlanTagNames, delimiter);
        }
        return "";
    }

    protected static String getDirectAtlanTags(Asset asset, String delimiter) {
        SortedSet atlanTags;
        TreeSet<String> atlanTagNames = new TreeSet<String>();
        if (asset != null && (atlanTags = asset.getAtlanTags()) != null) {
            for (AtlanTag classification : atlanTags) {
                String classifiedEntity = classification.getEntityGuid();
                if (!asset.getGuid().equals(classifiedEntity)) continue;
                atlanTagNames.add(classification.getTypeName());
            }
        }
        return AbstractReporter.getDelimitedList(atlanTagNames, delimiter);
    }

    protected static String getDelimitedList(Collection<String> items, String delimiter) {
        if (items == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, items);
    }

    public void setFilename(String _filename) {
        this._filename = _filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getBucket() {
        return this._bucket;
    }

    public Region getRegion() {
        return this._region;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public String getDelimiter() {
        return this._delimiter;
    }
}

