/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.Atlan;
import com.atlan.cache.CustomMetadataCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.ADLSContainer;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IADLSObject;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IGCSObject;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILookerExplore;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerQuery;
import com.atlan.model.assets.ILookerTile;
import com.atlan.model.assets.ILookerView;
import com.atlan.model.assets.IMetabaseDashboard;
import com.atlan.model.assets.IMetabaseQuestion;
import com.atlan.model.assets.IModeChart;
import com.atlan.model.assets.IModeCollection;
import com.atlan.model.assets.IModeQuery;
import com.atlan.model.assets.IModeReport;
import com.atlan.model.assets.IPowerBIColumn;
import com.atlan.model.assets.IPowerBIDashboard;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IPowerBIDataset;
import com.atlan.model.assets.IPowerBIDatasource;
import com.atlan.model.assets.IPowerBIMeasure;
import com.atlan.model.assets.IPowerBIPage;
import com.atlan.model.assets.IPowerBIReport;
import com.atlan.model.assets.IPowerBITable;
import com.atlan.model.assets.IPowerBITile;
import com.atlan.model.assets.IPresetChart;
import com.atlan.model.assets.IPresetDashboard;
import com.atlan.model.assets.IPresetDataset;
import com.atlan.model.assets.IS3Object;
import com.atlan.model.assets.ISalesforceDashboard;
import com.atlan.model.assets.ISalesforceField;
import com.atlan.model.assets.ISalesforceObject;
import com.atlan.model.assets.ISalesforceReport;
import com.atlan.model.assets.ITableauDashboard;
import com.atlan.model.assets.ITableauDatasource;
import com.atlan.model.assets.ITableauDatasourceField;
import com.atlan.model.assets.ITableauField;
import com.atlan.model.assets.ITableauFlow;
import com.atlan.model.assets.ITableauProject;
import com.atlan.model.assets.ITableauWorkbook;
import com.atlan.model.assets.ITableauWorksheet;
import com.atlan.model.assets.LookerDashboard;
import com.atlan.model.assets.LookerExplore;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.assets.LookerQuery;
import com.atlan.model.assets.LookerView;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.MetabaseCollection;
import com.atlan.model.assets.MetabaseDashboard;
import com.atlan.model.assets.MetabaseQuestion;
import com.atlan.model.assets.ModeCollection;
import com.atlan.model.assets.ModeQuery;
import com.atlan.model.assets.ModeReport;
import com.atlan.model.assets.ModeWorkspace;
import com.atlan.model.assets.PowerBIDashboard;
import com.atlan.model.assets.PowerBIDataflow;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIDatasource;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.assets.PowerBITable;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.assets.PresetWorkspace;
import com.atlan.model.assets.S3Bucket;
import com.atlan.model.assets.SalesforceDashboard;
import com.atlan.model.assets.SalesforceObject;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.assets.SalesforceReport;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.TableauCalculatedField;
import com.atlan.model.assets.TableauDashboard;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauDatasourceField;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.assets.TableauSite;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.assets.View;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.enums.AtlanSearchableField;
import com.atlan.model.enums.KeywordFields;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.samples.reporters.AbstractReporter;
import com.atlan.samples.writers.ExcelWriter;
import com.atlan.samples.writers.S3Writer;
import com.atlan.util.QueryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class EnrichmentReporter
extends AbstractReporter
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(EnrichmentReporter.class);
    private static final String CM_DELIMITER = "|";
    private static Map<String, List<String>> CM_ATTRIBUTE_ORDER;
    private static Map<String, String> CM_ATTRIBUTE_HEADERS;
    private static Set<String> CM_ATTRIBUTES_FOR_SEARCH;
    private static Set<String> autoSizeSheets;
    private static FilterType FILTER_TYPE;
    private static List<String> ATLAN_TAG_LIST;
    private static String PREFIX;
    private static boolean INCLUDE_FIELD_LEVEL;
    private static boolean DIRECT_ATLAN_TAG_ONLY;
    private static final Map<String, String> categoryGuidToPath;
    private static final Map<String, Glossary> glossaryGuidToDetails;
    private static final Map<String, GlossaryTerm> termGuidToDetails;
    private static final Map<String, String> processed;
    static final List<String> ENRICHMENT_ATTRIBUTES;
    private static final List<String> assetTypes;
    private static final List<String> childRelationships;
    static final List<String> RELATION_ATTRIBUTES;

    public static void main(String[] args) {
        EnrichmentReporter er = new EnrichmentReporter();
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("FILTER_BY")) {
            event.put("FILTER_BY", "GROUP");
        }
        if (!event.containsKey("DELIMITER")) {
            event.put("DELIMITER", ",");
        }
        er.handleRequest(event, null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            String prefix;
            this.setFilenameWithPrefix(event, "enrichment-report");
            String filterBy = event.getOrDefault("FILTER_BY", "GROUP");
            FILTER_TYPE = filterBy.toUpperCase(Locale.ROOT).equals("GROUP") ? FilterType.BY_GROUP : (filterBy.toUpperCase(Locale.ROOT).equals("ATLAN_TAG") ? FilterType.BY_ATLAN_TAG : FilterType.BY_PREFIX);
            String atlanTag = event.getOrDefault("ATLAN_TAG", null);
            if (atlanTag != null && atlanTag.length() > 0) {
                ATLAN_TAG_LIST = List.of(atlanTag);
            }
            if ((prefix = (String)event.getOrDefault("PREFIX", null)) != null && prefix.length() > 0) {
                PREFIX = prefix;
            }
            String includeFieldLevel = event.getOrDefault("INCLUDE_FIELD_LEVEL", "false");
            INCLUDE_FIELD_LEVEL = includeFieldLevel.toUpperCase(Locale.ROOT).equals("TRUE");
            String directAtlanTagsOnly = event.getOrDefault("DIRECT_ATLAN_TAGS_ONLY", "false");
            DIRECT_ATLAN_TAG_ONLY = directAtlanTagsOnly.toUpperCase(Locale.ROOT).equals("TRUE");
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            log.info("Creating Excel file (in-memory)...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            this.parseParametersFromEvent(event);
            EnrichmentReporter.getOrderedCustomMetadata();
            Map<String, String> ASSET_ENRICHMENT = EnrichmentReporter.createAssetEnrichmentHeader();
            Map<String, String> GLOSSARY_ENRICHMENT = EnrichmentReporter.createGlossaryEnrichmentHeader();
            Map<String, String> CATEGORY_ENRICHMENT = EnrichmentReporter.createCategoryEnrichmentHeader();
            Map<String, String> TERM_ENRICHMENT = EnrichmentReporter.createTermEnrichmentHeader();
            ExcelWriter xlsx = new ExcelWriter();
            this.cacheGlossaries();
            this.cacheTerms();
            Sheet assets = xlsx.createSheet("Asset enrichment");
            autoSizeSheets.add("Asset enrichment");
            xlsx.addHeader(assets, ASSET_ENRICHMENT);
            this.getAssets(xlsx, assets);
            Sheet glossaries = xlsx.createSheet("Glossary enrichment");
            autoSizeSheets.add("Glossary enrichment");
            xlsx.addHeader(glossaries, GLOSSARY_ENRICHMENT);
            this.getGlossaries(xlsx, glossaries);
            Sheet categories = xlsx.createSheet("Category enrichment");
            autoSizeSheets.add("Category enrichment");
            xlsx.addHeader(categories, CATEGORY_ENRICHMENT);
            this.findCategories(xlsx, categories);
            Sheet terms = xlsx.createSheet("Term enrichment");
            autoSizeSheets.add("Term enrichment");
            xlsx.addHeader(terms, TERM_ENRICHMENT);
            this.getTerms(xlsx, terms);
            if (this.getBucket() != null) {
                S3Client s3Client = (S3Client)((S3ClientBuilder)S3Client.builder().region(this.getRegion())).build();
                S3Writer s3 = new S3Writer(s3Client);
                s3.putExcelFile(xlsx.asByteArray(), this.getBucket(), this.getFilename());
            } else {
                log.info("Writing report to file: {}", (Object)this.getFilename());
                xlsx.create(this.getFilename(), autoSizeSheets);
            }
        }
        catch (AtlanException e) {
            log.error("Failed to retrieve asset details from: {}", (Object)Atlan.getBaseUrlSafe(), (Object)e);
            System.exit(1);
        }
        catch (IOException e) {
            log.error("Failed to write Excel file to: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }

    void cacheGlossaries() throws AtlanException {
        log.info("Finding glossaries...");
        Query query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"AtlasGlossary")).build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((IndexSearchDSL)IndexSearchDSL.builder((Query)query).size(Integer.valueOf(this.getBatchSize())).sortOption(QueryFactory.Sort.by((AtlanSearchableField)KeywordFields.NAME)).build()).attributes(ENRICHMENT_ATTRIBUTES).attributes(CM_ATTRIBUTES_FOR_SEARCH).relationAttributes(RELATION_ATTRIBUTES).build();
        IndexSearchResponse response = request.search();
        List results = response.getAssets();
        while (results != null) {
            for (Asset result : results) {
                if (!(result instanceof Glossary)) continue;
                glossaryGuidToDetails.put(result.getGuid(), (Glossary)result);
            }
            response = response.getNextPage();
            results = response.getAssets();
        }
    }

    void cacheTerms() throws AtlanException {
        log.info("Finding terms...");
        Query query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"AtlasGlossaryTerm")).build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((IndexSearchDSL)IndexSearchDSL.builder((Query)query).size(Integer.valueOf(this.getBatchSize())).sortOption(QueryFactory.Sort.by((AtlanSearchableField)KeywordFields.NAME)).build()).attributes(ENRICHMENT_ATTRIBUTES).attributes(CM_ATTRIBUTES_FOR_SEARCH).attribute("anchor").attribute("categories").attribute("seeAlso").attribute("preferredTerms").attribute("synonyms").attribute("antonyms").attribute("translatedTerms").attribute("validValuesFor").attribute("classifies").relationAttributes(RELATION_ATTRIBUTES).build();
        IndexSearchResponse response = request.search();
        List results = response.getAssets();
        while (results != null) {
            for (Asset result : results) {
                if (!(result instanceof GlossaryTerm)) continue;
                termGuidToDetails.put(result.getGuid(), (GlossaryTerm)result);
            }
            response = response.getNextPage();
            results = response.getAssets();
        }
    }

    void getAssets(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        QueryFactory.CompoundQuery.CompoundQueryBuilder builder = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive());
        if (!INCLUDE_FIELD_LEVEL) {
            builder = builder.must(QueryFactory.beOneOfTypes(assetTypes));
        }
        if (FILTER_TYPE == FilterType.BY_GROUP) {
            builder = builder.must(QueryFactory.have((AtlanSearchableField)KeywordFields.OWNER_GROUPS).present());
        } else if (FILTER_TYPE == FilterType.BY_ATLAN_TAG) {
            builder = builder.must(QueryFactory.beTaggedByAtLeastOneOf(ATLAN_TAG_LIST));
        } else if (FILTER_TYPE == FilterType.BY_PREFIX) {
            builder = builder.must(QueryFactory.have((AtlanSearchableField)KeywordFields.QUALIFIED_NAME).startingWith(PREFIX));
        }
        Query query = builder.build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((IndexSearchDSL)IndexSearchDSL.builder((Query)query).size(Integer.valueOf(this.getBatchSize())).sortOption(QueryFactory.Sort.by((AtlanSearchableField)KeywordFields.GUID, (SortOrder)SortOrder.Asc)).build()).attributes(ENRICHMENT_ATTRIBUTES).attributes(childRelationships).attributes(CM_ATTRIBUTES_FOR_SEARCH).relationAttribute("description").relationAttribute("userDescription").build();
        log.info("Retrieving first {} asset details from: {}", (Object)this.getBatchSize(), (Object)Atlan.getBaseUrlSafe());
        IndexSearchResponse response = request.search();
        List results = response.getAssets();
        while (results != null) {
            for (Asset result : results) {
                String guid = result.getGuid();
                if (processed.containsKey(guid)) continue;
                List<Asset> childAssets = EnrichmentReporter.getChildAssets(result);
                long descriptionCounts = 0L;
                for (Asset child : childAssets) {
                    String childDesc = EnrichmentReporter.getDescription(child);
                    descriptionCounts += childDesc.length() > 0 ? 1L : 0L;
                }
                ArrayList<ExcelWriter.DataCell> row = new ArrayList<ExcelWriter.DataCell>();
                row.add(ExcelWriter.DataCell.of((AtlanEnum)result.getConnectorType()));
                row.add(ExcelWriter.DataCell.of(result.getQualifiedName()));
                row.add(ExcelWriter.DataCell.of(result.getTypeName()));
                row.add(ExcelWriter.DataCell.of(result.getName()));
                row.add(ExcelWriter.DataCell.of(result.getDescription()));
                row.add(ExcelWriter.DataCell.of(result.getUserDescription()));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getUserOwners(result, this.getDelimiter())));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getGroupOwners(result, this.getDelimiter())));
                row.add(ExcelWriter.DataCell.of((AtlanEnum)result.getCertificateStatus()));
                row.add(ExcelWriter.DataCell.of(result.getCertificateStatusMessage()));
                row.add(ExcelWriter.DataCell.of(result.getCertificateUpdatedBy()));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(result.getCertificateUpdatedAt())));
                row.add(ExcelWriter.DataCell.of((AtlanEnum)result.getAnnouncementType()));
                row.add(ExcelWriter.DataCell.of(result.getAnnouncementTitle()));
                row.add(ExcelWriter.DataCell.of(result.getAnnouncementMessage()));
                row.add(ExcelWriter.DataCell.of(result.getAnnouncementUpdatedBy()));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(result.getAnnouncementUpdatedAt())));
                row.add(ExcelWriter.DataCell.of(result.getCreatedBy()));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(result.getCreateTime())));
                row.add(ExcelWriter.DataCell.of(result.getUpdatedBy()));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(result.getUpdateTime())));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getREADME(result)));
                row.add(ExcelWriter.DataCell.of(this.getTerms(result.getAssignedTerms(), termGuidToDetails)));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getCount(result.getLinks())));
                row.add(ExcelWriter.DataCell.of(DIRECT_ATLAN_TAG_ONLY ? EnrichmentReporter.getDirectAtlanTags(result, this.getDelimiter()) : EnrichmentReporter.getAtlanTags(result, this.getDelimiter())));
                row.add(ExcelWriter.DataCell.of(childAssets.size()));
                row.add(ExcelWriter.DataCell.of(descriptionCounts));
                row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getAssetLink(guid)));
                this.addCustomMetadata(row, result);
                xlsx.appendRow(sheet, row);
                processed.put(guid, result.getQualifiedName());
            }
            log.info(" retrieving next {} asset details from: {}", (Object)this.getBatchSize(), (Object)Atlan.getBaseUrlSafe());
            response = response.getNextPage();
            results = response.getAssets();
        }
    }

    void getGlossaries(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        for (Glossary glossary : glossaryGuidToDetails.values()) {
            ArrayList<ExcelWriter.DataCell> row = new ArrayList<ExcelWriter.DataCell>();
            row.add(ExcelWriter.DataCell.of(glossary.getName()));
            row.add(ExcelWriter.DataCell.of(glossary.getDescription()));
            row.add(ExcelWriter.DataCell.of(glossary.getUserDescription()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getUserOwners((Asset)glossary, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getGroupOwners((Asset)glossary, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)glossary.getCertificateStatus()));
            row.add(ExcelWriter.DataCell.of(glossary.getCertificateStatusMessage()));
            row.add(ExcelWriter.DataCell.of(glossary.getCertificateUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(glossary.getCertificateUpdatedAt())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)glossary.getAnnouncementType()));
            row.add(ExcelWriter.DataCell.of(glossary.getAnnouncementTitle()));
            row.add(ExcelWriter.DataCell.of(glossary.getAnnouncementMessage()));
            row.add(ExcelWriter.DataCell.of(glossary.getAnnouncementUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(glossary.getAnnouncementUpdatedAt())));
            row.add(ExcelWriter.DataCell.of(glossary.getCreatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(glossary.getCreateTime())));
            row.add(ExcelWriter.DataCell.of(glossary.getUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(glossary.getUpdateTime())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getREADME((Asset)glossary)));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getCount(glossary.getLinks())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getAssetLink(glossary.getGuid())));
            this.addCustomMetadata(row, (Asset)glossary);
            xlsx.appendRow(sheet, row);
        }
    }

    void findCategories(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        log.info("Finding categories...");
        Query query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"AtlasGlossaryCategory")).build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((IndexSearchDSL)IndexSearchDSL.builder((Query)query).size(Integer.valueOf(this.getBatchSize())).sortOption(QueryFactory.Sort.by((AtlanSearchableField)KeywordFields.NAME)).build()).attributes(ENRICHMENT_ATTRIBUTES).attributes(CM_ATTRIBUTES_FOR_SEARCH).attribute("anchor").attribute("parentCategory").relationAttributes(RELATION_ATTRIBUTES).build();
        IndexSearchResponse response = request.search();
        List results = response.getAssets();
        HashMap<String, GlossaryCategory> categoryGuidToDetails = new HashMap<String, GlossaryCategory>();
        while (results != null) {
            for (Asset result : results) {
                if (!(result instanceof GlossaryCategory)) continue;
                categoryGuidToDetails.put(result.getGuid(), (GlossaryCategory)result);
            }
            response = response.getNextPage();
            results = response.getAssets();
        }
        for (GlossaryCategory category : categoryGuidToDetails.values()) {
            String categoryPath = EnrichmentReporter.getCategoryPath(category, categoryGuidToDetails);
            categoryGuidToPath.put(category.getGuid(), categoryPath);
            Glossary glossary = glossaryGuidToDetails.get(category.getAnchor().getGuid());
            ArrayList<ExcelWriter.DataCell> row = new ArrayList<ExcelWriter.DataCell>();
            row.add(ExcelWriter.DataCell.of(glossary == null ? "" : glossary.getName()));
            row.add(ExcelWriter.DataCell.of(categoryPath));
            row.add(ExcelWriter.DataCell.of(category.getDescription()));
            row.add(ExcelWriter.DataCell.of(category.getUserDescription()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getUserOwners((Asset)category, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getGroupOwners((Asset)category, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)category.getCertificateStatus()));
            row.add(ExcelWriter.DataCell.of(category.getCertificateStatusMessage()));
            row.add(ExcelWriter.DataCell.of(category.getCertificateUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(category.getCertificateUpdatedAt())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)category.getAnnouncementType()));
            row.add(ExcelWriter.DataCell.of(category.getAnnouncementTitle()));
            row.add(ExcelWriter.DataCell.of(category.getAnnouncementMessage()));
            row.add(ExcelWriter.DataCell.of(category.getAnnouncementUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(category.getAnnouncementUpdatedAt())));
            row.add(ExcelWriter.DataCell.of(category.getCreatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(category.getCreateTime())));
            row.add(ExcelWriter.DataCell.of(category.getUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(category.getUpdateTime())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getREADME((Asset)category)));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getCount(category.getLinks())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getAssetLink(category.getGuid())));
            this.addCustomMetadata(row, (Asset)category);
            xlsx.appendRow(sheet, row);
        }
    }

    static String getCategoryPath(GlossaryCategory category, Map<String, GlossaryCategory> guidMap) {
        IGlossaryCategory parent = category.getParentCategory();
        if (parent == null || parent.getGuid() == null) {
            return category.getName();
        }
        return EnrichmentReporter.getCategoryPath(guidMap.get(parent.getGuid()), guidMap) + "@" + category.getName();
    }

    void getTerms(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        for (GlossaryTerm term : termGuidToDetails.values()) {
            Glossary glossary = glossaryGuidToDetails.get(term.getAnchor().getGuid());
            ArrayList<ExcelWriter.DataCell> row = new ArrayList<ExcelWriter.DataCell>();
            row.add(ExcelWriter.DataCell.of(glossary == null ? "" : glossary.getName()));
            row.add(ExcelWriter.DataCell.of(term.getName()));
            row.add(ExcelWriter.DataCell.of(term.getDescription()));
            row.add(ExcelWriter.DataCell.of(term.getUserDescription()));
            row.add(ExcelWriter.DataCell.of(this.getCategories(term)));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getUserOwners((Asset)term, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getGroupOwners((Asset)term, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)term.getCertificateStatus()));
            row.add(ExcelWriter.DataCell.of(DIRECT_ATLAN_TAG_ONLY ? EnrichmentReporter.getDirectAtlanTags((Asset)term, this.getDelimiter()) : EnrichmentReporter.getAtlanTags((Asset)term, this.getDelimiter())));
            row.add(ExcelWriter.DataCell.of(term.getCertificateStatusMessage()));
            row.add(ExcelWriter.DataCell.of(term.getCertificateUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(term.getCertificateUpdatedAt())));
            row.add(ExcelWriter.DataCell.of((AtlanEnum)term.getAnnouncementType()));
            row.add(ExcelWriter.DataCell.of(term.getAnnouncementTitle()));
            row.add(ExcelWriter.DataCell.of(term.getAnnouncementMessage()));
            row.add(ExcelWriter.DataCell.of(term.getAnnouncementUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(term.getAnnouncementUpdatedAt())));
            row.add(ExcelWriter.DataCell.of(term.getCreatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(term.getCreateTime())));
            row.add(ExcelWriter.DataCell.of(term.getUpdatedBy()));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getFormattedDateTime(term.getUpdateTime())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getREADME((Asset)term)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getSeeAlso(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getPreferredTerms(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getSynonyms(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getAntonyms(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getTranslatedTerms(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getValidValuesFor(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(this.getTerms(term.getClassifies(), termGuidToDetails)));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getCount(term.getLinks())));
            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getAssetLink(term.getGuid())));
            this.addCustomMetadata(row, (Asset)term);
            xlsx.appendRow(sheet, row);
        }
    }

    String getCategories(GlossaryTerm term) {
        SortedSet categories = term.getCategories();
        ArrayList<String> categoryPaths = new ArrayList<String>(categories.size());
        for (IGlossaryCategory category : categories) {
            String path = categoryGuidToPath.getOrDefault(category.getGuid(), null);
            if (path == null) continue;
            categoryPaths.add(path);
        }
        return EnrichmentReporter.getDelimitedList(categoryPaths, this.getDelimiter());
    }

    String getTerms(Set<IGlossaryTerm> terms, Map<String, GlossaryTerm> guidMap) {
        ArrayList<String> qualifiedTerms = new ArrayList<String>(terms.size());
        for (IGlossaryTerm term : terms) {
            GlossaryTerm related = guidMap.getOrDefault(term.getGuid(), null);
            if (related == null) continue;
            Glossary glossary = glossaryGuidToDetails.get(related.getAnchor().getGuid());
            qualifiedTerms.add(related.getName() + "@" + (glossary == null ? "" : glossary.getName()));
        }
        return EnrichmentReporter.getDelimitedList(qualifiedTerms, this.getDelimiter());
    }

    private void addCustomMetadata(List<ExcelWriter.DataCell> row, Asset result) {
        Map map = result.getCustomMetadataSets();
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : CM_ATTRIBUTE_ORDER.entrySet()) {
                String cmName = entry.getKey();
                List<String> attrOrder = entry.getValue();
                CustomMetadataAttributes attrs = (CustomMetadataAttributes)map.get(cmName);
                if (attrs != null) {
                    Map active = attrs.getAttributes();
                    for (String attrName : attrOrder) {
                        Object value = active.get(attrName);
                        if (value == null) {
                            row.add(ExcelWriter.DataCell.of(""));
                            continue;
                        }
                        if (value instanceof Collection) {
                            row.add(ExcelWriter.DataCell.of(EnrichmentReporter.getDelimitedList((Collection)value, this.getDelimiter())));
                            continue;
                        }
                        if (value instanceof Boolean) {
                            row.add(ExcelWriter.DataCell.of((Boolean)value));
                            continue;
                        }
                        if (value instanceof Long) {
                            row.add(ExcelWriter.DataCell.of((Long)value));
                            continue;
                        }
                        if (value instanceof Double) {
                            row.add(ExcelWriter.DataCell.of((Double)value));
                            continue;
                        }
                        row.add(ExcelWriter.DataCell.of(value.toString()));
                    }
                    continue;
                }
                for (int i = 0; i < attrOrder.size(); ++i) {
                    row.add(ExcelWriter.DataCell.of(""));
                }
            }
        }
    }

    static List<Asset> getChildAssets(Asset asset) {
        String assetType;
        ArrayList<Asset> childAssets = new ArrayList();
        switch (assetType = asset.getTypeName()) {
            case "Table": {
                for (IColumn column : ((Table)asset).getColumns()) {
                    childAssets.add((Asset)column);
                }
                break;
            }
            case "View": {
                for (IColumn column : ((View)asset).getColumns()) {
                    childAssets.add((Asset)column);
                }
                break;
            }
            case "MaterialisedView": {
                for (IColumn column : ((MaterializedView)asset).getColumns()) {
                    childAssets.add((Asset)column);
                }
                break;
            }
            case "LookerDashboard": {
                LookerDashboard dashboard = (LookerDashboard)asset;
                for (ILookerTile tile : dashboard.getTiles()) {
                    childAssets.add((Asset)tile);
                }
                for (ILookerLook look : dashboard.getLooks()) {
                    childAssets.add((Asset)look);
                }
                break;
            }
            case "LookerModel": {
                LookerModel model = (LookerModel)asset;
                for (ILookerExplore explore : model.getExplores()) {
                    childAssets.add((Asset)explore);
                }
                for (ILookerField field : model.getFields()) {
                    childAssets.add((Asset)field);
                }
                for (ILookerQuery query : model.getQueries()) {
                    childAssets.add((Asset)query);
                }
                break;
            }
            case "LookerProject": {
                LookerProject project = (LookerProject)asset;
                for (ILookerModel lModel : project.getModels()) {
                    childAssets.add((Asset)lModel);
                }
                for (ILookerExplore explore : project.getExplores()) {
                    childAssets.add((Asset)explore);
                }
                for (ILookerField field : project.getFields()) {
                    childAssets.add((Asset)field);
                }
                for (ILookerView view : project.getViews()) {
                    childAssets.add((Asset)view);
                }
                break;
            }
            case "LookerExplore": {
                for (ILookerField field : ((LookerExplore)asset).getFields()) {
                    childAssets.add((Asset)field);
                }
                break;
            }
            case "LookerQuery": {
                LookerQuery query = (LookerQuery)asset;
                for (ILookerTile tile : query.getTiles()) {
                    childAssets.add((Asset)tile);
                }
                for (ILookerLook look : query.getLooks()) {
                    childAssets.add((Asset)look);
                }
                break;
            }
            case "LookerView": {
                for (ILookerField field : ((LookerView)asset).getFields()) {
                    childAssets.add((Asset)field);
                }
                break;
            }
            case "MetabaseCollection": {
                MetabaseCollection collection = (MetabaseCollection)asset;
                for (IMetabaseDashboard mDashboard : collection.getMetabaseDashboards()) {
                    childAssets.add((Asset)mDashboard);
                }
                for (IMetabaseQuestion question : collection.getMetabaseQuestions()) {
                    childAssets.add((Asset)question);
                }
                break;
            }
            case "MetabaseDashboard": {
                for (IMetabaseQuestion question : ((MetabaseDashboard)asset).getMetabaseQuestions()) {
                    childAssets.add((Asset)question);
                }
                break;
            }
            case "MetabaseQuestion": {
                for (IMetabaseDashboard mDashboard : ((MetabaseQuestion)asset).getMetabaseDashboards()) {
                    childAssets.add((Asset)mDashboard);
                }
                break;
            }
            case "ModeWorkspace": {
                for (IModeCollection mCollection : ((ModeWorkspace)asset).getModeCollections()) {
                    childAssets.add((Asset)mCollection);
                }
                break;
            }
            case "ModeCollection": {
                for (IModeReport report : ((ModeCollection)asset).getModeReports()) {
                    childAssets.add((Asset)report);
                }
                break;
            }
            case "ModeQuery": {
                for (IModeChart chart : ((ModeQuery)asset).getModeCharts()) {
                    childAssets.add((Asset)chart);
                }
                break;
            }
            case "ModeReport": {
                ModeReport modeReport = (ModeReport)asset;
                for (IModeCollection mCollection : modeReport.getModeCollections()) {
                    childAssets.add((Asset)mCollection);
                }
                for (IModeQuery mQuery : modeReport.getModeQueries()) {
                    childAssets.add((Asset)mQuery);
                }
                break;
            }
            case "PowerBIWorkspace": {
                PowerBIWorkspace workspace = (PowerBIWorkspace)asset;
                for (IPowerBIReport report : workspace.getReports()) {
                    childAssets.add((Asset)report);
                }
                for (IPowerBIDataset dataset : workspace.getDatasets()) {
                    childAssets.add((Asset)dataset);
                }
                for (IPowerBIDashboard pDashboard : workspace.getDashboards()) {
                    childAssets.add((Asset)pDashboard);
                }
                for (IPowerBIDataflow dataflow : workspace.getDataflows()) {
                    childAssets.add((Asset)dataflow);
                }
                break;
            }
            case "PowerBIDashboard": {
                for (IPowerBITile tile : ((PowerBIDashboard)asset).getTiles()) {
                    childAssets.add((Asset)tile);
                }
                break;
            }
            case "PowerBIDataflow": {
                for (IPowerBIDataset dataset : ((PowerBIDataflow)asset).getDatasets()) {
                    childAssets.add((Asset)dataset);
                }
                break;
            }
            case "PowerBIDataset": {
                PowerBIDataset dataset = (PowerBIDataset)asset;
                for (IPowerBIReport report : dataset.getReports()) {
                    childAssets.add((Asset)report);
                }
                for (IPowerBITile tile : dataset.getTiles()) {
                    childAssets.add((Asset)tile);
                }
                for (IPowerBITable table : dataset.getTables()) {
                    childAssets.add((Asset)table);
                }
                for (IPowerBIDatasource datasource : dataset.getDatasources()) {
                    childAssets.add((Asset)datasource);
                }
                for (IPowerBIDataflow dataflow : dataset.getDataflows()) {
                    childAssets.add((Asset)dataflow);
                }
                break;
            }
            case "PowerBIDatasource": {
                for (IPowerBIDataset pDataset : ((PowerBIDatasource)asset).getDatasets()) {
                    childAssets.add((Asset)pDataset);
                }
                break;
            }
            case "PowerBIReport": {
                PowerBIReport pbiReport = (PowerBIReport)asset;
                for (IPowerBITile tile : pbiReport.getTiles()) {
                    childAssets.add((Asset)tile);
                }
                for (IPowerBIPage page : pbiReport.getPages()) {
                    childAssets.add((Asset)page);
                }
                break;
            }
            case "PowerBITable": {
                PowerBITable pbiTable = (PowerBITable)asset;
                for (IPowerBIMeasure measure : pbiTable.getMeasures()) {
                    childAssets.add((Asset)measure);
                }
                for (IPowerBIColumn column : pbiTable.getColumns()) {
                    childAssets.add((Asset)column);
                }
                break;
            }
            case "PresetWorkspace": {
                for (IPresetDashboard pDashboard : ((PresetWorkspace)asset).getPresetDashboards()) {
                    childAssets.add((Asset)pDashboard);
                }
                break;
            }
            case "PresetDashboard": {
                PresetDashboard presetDashboard = (PresetDashboard)asset;
                for (IPresetDataset pDataset : presetDashboard.getPresetDatasets()) {
                    childAssets.add((Asset)pDataset);
                }
                for (IPresetChart chart : presetDashboard.getPresetCharts()) {
                    childAssets.add((Asset)chart);
                }
                break;
            }
            case "ADLSContainer": {
                for (IADLSObject object : ((ADLSContainer)asset).getAdlsObjects()) {
                    childAssets.add((Asset)object);
                }
                break;
            }
            case "GCSBucket": {
                for (IGCSObject object : ((GCSBucket)asset).getGcsObjects()) {
                    childAssets.add((Asset)object);
                }
                break;
            }
            case "S3Bucket": {
                for (IS3Object object : ((S3Bucket)asset).getObjects()) {
                    childAssets.add((Asset)object);
                }
                break;
            }
            case "SalesforceOrganization": {
                SalesforceOrganization org = (SalesforceOrganization)asset;
                for (ISalesforceReport report : org.getReports()) {
                    childAssets.add((Asset)report);
                }
                for (ISalesforceObject object : org.getObjects()) {
                    childAssets.add((Asset)object);
                }
                for (ISalesforceDashboard sDashboard : org.getDashboards()) {
                    childAssets.add((Asset)sDashboard);
                }
                break;
            }
            case "SalesforceDashboard": {
                for (ISalesforceReport report : ((SalesforceDashboard)asset).getReports()) {
                    childAssets.add((Asset)report);
                }
                break;
            }
            case "SalesforceReport": {
                for (ISalesforceDashboard sDashboard : ((SalesforceReport)asset).getDashboards()) {
                    childAssets.add((Asset)sDashboard);
                }
                break;
            }
            case "SalesforceObject": {
                SalesforceObject object = (SalesforceObject)asset;
                for (ISalesforceField field : object.getLookupFields()) {
                    childAssets.add((Asset)field);
                }
                for (ISalesforceField field : object.getFields()) {
                    childAssets.add((Asset)field);
                }
                break;
            }
            case "TableauSite": {
                for (ITableauProject tProject : ((TableauSite)asset).getProjects()) {
                    childAssets.add((Asset)tProject);
                }
                break;
            }
            case "TableauProject": {
                TableauProject tableauProject = (TableauProject)asset;
                for (ITableauWorkbook workbook : tableauProject.getWorkbooks()) {
                    childAssets.add((Asset)workbook);
                }
                for (ITableauDatasource datasource : tableauProject.getDatasources()) {
                    childAssets.add((Asset)datasource);
                }
                for (ITableauFlow flow : tableauProject.getFlows()) {
                    childAssets.add((Asset)flow);
                }
                break;
            }
            case "TableauWorkbook": {
                TableauWorkbook tableauWorkbook = (TableauWorkbook)asset;
                for (ITableauWorksheet worksheet : tableauWorkbook.getWorksheets()) {
                    childAssets.add((Asset)worksheet);
                }
                for (ITableauDatasource datasource : tableauWorkbook.getDatasources()) {
                    childAssets.add((Asset)datasource);
                }
                for (ITableauDashboard tDashboard : tableauWorkbook.getDashboards()) {
                    childAssets.add((Asset)tDashboard);
                }
                break;
            }
            case "TableauWorksheet": {
                TableauWorksheet worksheet = (TableauWorksheet)asset;
                for (ITableauDatasourceField field : worksheet.getDatasourceFields()) {
                    childAssets.add((Asset)field);
                }
                for (ITableauDatasourceField field : worksheet.getCalculatedFields()) {
                    childAssets.add((Asset)field);
                }
                for (ITableauDashboard tDashboard : worksheet.getDashboards()) {
                    childAssets.add((Asset)tDashboard);
                }
                break;
            }
            case "TableauCalculatedField": {
                for (ITableauWorksheet tWorksheet : ((TableauCalculatedField)asset).getWorksheets()) {
                    childAssets.add((Asset)tWorksheet);
                }
                break;
            }
            case "TableauDashboard": {
                for (ITableauWorksheet tWorksheet : ((TableauDashboard)asset).getWorksheets()) {
                    childAssets.add((Asset)tWorksheet);
                }
                break;
            }
            case "TableauDatasource": {
                for (ITableauField field : ((TableauDatasource)asset).getFields()) {
                    childAssets.add((Asset)field);
                }
                break;
            }
            case "TableauDatasourceField": {
                for (ITableauWorksheet tWorksheet : ((TableauDatasourceField)asset).getWorksheets()) {
                    childAssets.add((Asset)tWorksheet);
                }
                break;
            }
            default: {
                childAssets = Collections.emptyList();
            }
        }
        return childAssets;
    }

    static void getOrderedCustomMetadata() {
        CM_ATTRIBUTE_ORDER = new LinkedHashMap<String, List<String>>();
        CM_ATTRIBUTE_HEADERS = new LinkedHashMap<String, String>();
        CM_ATTRIBUTES_FOR_SEARCH = new HashSet<String>();
        try {
            Map allAttrs = CustomMetadataCache.getAllCustomAttributes();
            List sortedNames = allAttrs.keySet().stream().sorted().collect(Collectors.toList());
            for (String cmName : sortedNames) {
                CM_ATTRIBUTES_FOR_SEARCH.addAll(CustomMetadataCache.getAttributesForSearchResults((String)cmName));
                List attrs = (List)allAttrs.get(cmName);
                ArrayList<String> attrNames = new ArrayList<String>();
                for (AttributeDef attr : attrs) {
                    boolean multiValued;
                    String attrName = attr.getDisplayName();
                    attrNames.add(attrName);
                    boolean bl = multiValued = attr.getOptions().getMultiValueSelect() != null && attr.getOptions().getMultiValueSelect() != false;
                    if (multiValued) {
                        CM_ATTRIBUTE_HEADERS.put(cmName + CM_DELIMITER + attrName, "Comma-separated list of " + attr.getDescription());
                        continue;
                    }
                    CM_ATTRIBUTE_HEADERS.put(cmName + CM_DELIMITER + attrName, attr.getDescription());
                }
                CM_ATTRIBUTE_ORDER.put(cmName, attrNames);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to retrieve custom metadata definitions.", (Throwable)e);
        }
    }

    static Map<String, String> createAssetEnrichmentHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Connector", "Type of the data source");
        map.put("Qualified name", "Unique name of the asset");
        map.put("Type", "Type of asset");
        map.put("Name", "Name of the asset");
        map.put("Description", "Explanation of the asset");
        map.put("User Description", "Explanation of the asset, as provided by a user in the UI");
        map.put("Owner Users", "Comma-separated list of the usernames who are owners of this asset");
        map.put("Owner Groups", "Comma-separated list of the group names who are owners of this asset");
        map.put("Certificate", "Certificate associated with this asset, one of: Verified, Draft, Deprecated");
        map.put("Certificate Message", "Message associated with the certificate (if any)");
        map.put("Certificate Updated By", "User who last updated the certificate");
        map.put("Certificate Updated At", "Date and time when the certificate was last updated");
        map.put("Announcement", "Type of announcement associated with this asset");
        map.put("Announcement Title", "Title of the announcement");
        map.put("Announcement Message", "Message associated with the announcement (if any)");
        map.put("Announcement Updated By", "User who last updated the announcement");
        map.put("Announcement Updated At", "Date and time when the announcement was last updated");
        map.put("Created By", "User who created this asset");
        map.put("Created At", "Date and time when this asset was created");
        map.put("Updated By", "User who last updated this asset");
        map.put("Updated At", "Date and time when the asset was last updated");
        map.put("README", "README contents for this asset (as HTML)");
        map.put("Assigned Terms", "Terms that have been linked to the asset");
        map.put("Resources", "Count of resources (links) associated with the asset");
        map.put("Atlan Tags", "Comma-separated list of the names of Atlan tags applied to the asset, if any (blank means no Atlan tags)");
        map.put("Children", "Count of children of this asset (for example, columns in a table)");
        map.put("Children with descriptions", "Count of children of this asset with a description present, whether system-provided or user-provided");
        map.put("Link", "Link to the detailed asset within Atlan");
        map.putAll(CM_ATTRIBUTE_HEADERS);
        return map;
    }

    static Map<String, String> createGlossaryEnrichmentHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Glossary Name", "Name of the glossary");
        map.put("Description", "Explanation of the glossary's contained terminology");
        map.put("User Description", "Explanation of the glossary's meaning, as provided by a user in the UI");
        map.put("Owner Users", "Comma-separated list of the usernames who are owners of this glossary");
        map.put("Owner Groups", "Comma-separated list of the group names who are owners of this glossary");
        map.put("Certificate", "Certificate associated with this glossary, one of: Verified, Draft, Deprecated");
        map.put("Certificate Message", "Message associated with the certificate (if any)");
        map.put("Certificate Updated By", "User who last updated the certificate");
        map.put("Certificate Updated At", "Date and time when the certificate was last updated");
        map.put("Announcement", "Type of announcement associated with this glossary");
        map.put("Announcement Title", "Title of the announcement");
        map.put("Announcement Message", "Message associated with the announcement (if any)");
        map.put("Announcement Updated By", "User who last updated the announcement");
        map.put("Announcement Updated At", "Date and time when the announcement was last updated");
        map.put("Created By", "User who created this glossary");
        map.put("Created At", "Date and time when this glossary was created");
        map.put("Updated By", "User who last updated this glossary");
        map.put("Updated At", "Date and time when the glossary was last updated");
        map.put("README", "README contents for this glossary (as HTML)");
        map.put("Resources", "Count of resources (links) associated with the glossary");
        map.put("Link", "Link to the detailed glossary within Atlan");
        map.putAll(CM_ATTRIBUTE_HEADERS);
        return map;
    }

    static Map<String, String> createCategoryEnrichmentHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Glossary Name", "Name of the glossary in which the category exists");
        map.put("Category Path", "Path of the category, separated by '@'");
        map.put("Description", "Explanation of the category's meaning");
        map.put("User Description", "Explanation of the category's meaning, as provided by a user in the UI");
        map.put("Owner Users", "Comma-separated list of the usernames who are owners of this term");
        map.put("Owner Groups", "Comma-separated list of the group names who are owners of this term");
        map.put("Certificate", "Certificate associated with this term, one of: Verified, Draft, Deprecated");
        map.put("Certificate Message", "Message associated with the certificate (if any)");
        map.put("Certificate Updated By", "User who last updated the certificate");
        map.put("Certificate Updated At", "Date and time when the certificate was last updated");
        map.put("Announcement", "Type of announcement associated with this category");
        map.put("Announcement Title", "Title of the announcement");
        map.put("Announcement Message", "Message associated with the announcement (if any)");
        map.put("Announcement Updated By", "User who last updated the announcement");
        map.put("Announcement Updated At", "Date and time when the announcement was last updated");
        map.put("Created By", "User who created this category");
        map.put("Created At", "Date and time when this category was created");
        map.put("Updated By", "User who last updated this category");
        map.put("Updated At", "Date and time when the category was last updated");
        map.put("README", "README contents for this category (as HTML)");
        map.put("Resources", "Count of resources (links) associated with the category");
        map.put("Link", "Link to the detailed category within Atlan");
        map.putAll(CM_ATTRIBUTE_HEADERS);
        return map;
    }

    static Map<String, String> createTermEnrichmentHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Glossary Name", "Name of the glossary in which the term exists");
        map.put("Term Name*", "Name of the term, which cannot include '@'");
        map.put("Description", "Explanation of the term's meaning");
        map.put("User Description", "Explanation of the term's meaning, as provided by a user in the UI");
        map.put("Categories", "Comma-separated list of categories the term is organized within");
        map.put("Owner Users", "Comma-separated list of the usernames who are owners of this term");
        map.put("Owner Groups", "Comma-separated list of the group names who are owners of this term");
        map.put("Certificate", "Certificate associated with this term, one of: Verified, Draft, Deprecated");
        map.put("Atlan Tags", "Comma-separated list of the Atlan tags associated with this term");
        map.put("Certificate Message", "Message associated with the certificate (if any)");
        map.put("Certificate Updated By", "User who last updated the certificate");
        map.put("Certificate Updated At", "Date and time when the certificate was last updated");
        map.put("Announcement", "Type of announcement associated with this term");
        map.put("Announcement Title", "Title of the announcement");
        map.put("Announcement Message", "Message associated with the announcement (if any)");
        map.put("Announcement Updated By", "User who last updated the announcement");
        map.put("Announcement Updated At", "Date and time when the announcement was last updated");
        map.put("Created By", "User who created this term");
        map.put("Created At", "Date and time when this term was created");
        map.put("Updated By", "User who last updated this term");
        map.put("Updated At", "Date and time when the term was last updated");
        map.put("README", "README contents for this term (as HTML)");
        map.put("Related Terms", "Comma-separated list of this term's related terms");
        map.put("Recommended Terms", "Comma-separated list of this term's recommended terms");
        map.put("Synonyms", "Comma-separated list of this term's synonyms");
        map.put("Antonyms", "Comma-separated list of this term's antonyms");
        map.put("Translated Terms", "Comma-separated list of this term's translated terms");
        map.put("Valid Values For", "Comma-separated list of the terms this term is a valid value for");
        map.put("Classifies", "Comma-separated list of the terms this term classifies");
        map.put("Resources", "Count of resources (links) associated with the term");
        map.put("Link", "Link to the detailed term within Atlan");
        map.putAll(CM_ATTRIBUTE_HEADERS);
        return map;
    }

    static {
        autoSizeSheets = new HashSet<String>();
        FILTER_TYPE = null;
        ATLAN_TAG_LIST = null;
        PREFIX = null;
        INCLUDE_FIELD_LEVEL = false;
        DIRECT_ATLAN_TAG_ONLY = false;
        categoryGuidToPath = new HashMap<String, String>();
        glossaryGuidToDetails = new HashMap<String, Glossary>();
        termGuidToDetails = new HashMap<String, GlossaryTerm>();
        processed = new HashMap<String, String>();
        ENRICHMENT_ATTRIBUTES = List.of("name", "description", "userDescription", "ownerUsers", "ownerGroups", "certificateStatus", "certificateStatusMessage", "certificateUpdatedBy", "certificateUpdatedAt", "announcementType", "announcementTitle", "announcementMessage", "announcementUpdatedBy", "announcementUpdatedAt", "createdBy", "createTime", "updatedBy", "updateTime", "readme", "classificationNames", "links", "connectorName", "meanings");
        assetTypes = List.of("Table", "View", "MaterialisedView", "LookerDashboard", "LookerModel", "LookerProject", "LookerQuery", "LookerExplore", "LookerView", "MetabaseCollection", "MetabaseDashboard", "MetabaseQuestion", "ModeWorkspace", "ModeCollection", "ModeQuery", "ModeReport", "PowerBIWorkspace", "PowerBIDashboard", "PowerBIDataflow", "PowerBIDataset", "PowerBIDatasource", "PowerBIReport", "PowerBITable", "PresetWorkspace", "PresetDashboard", "DataStudioAsset", "ADLSAccount", "ADLSContainer", "ADLSObject", "GCSBucket", "GCSObject", "S3Bucket", "S3Object", "SalesforceOrganization", "SalesforceDashboard", "SalesforceReport", "SalesforceObject", "TableauSite", "TableauProject", "TableauWorkbook", "TableauWorksheet", "TableauCalculatedField", "TableauDashboard", "TableauDatasource", "TableauDatasourceField");
        childRelationships = List.of("columns", "looks", "tiles", "fields", "explores", "queries", "models", "views", "metabaseDashboards", "metabaseQuestions", "modeCollections", "modeReports", "modeCharts", "modeCollections", "modeQueries", "dashboards", "datasets", "reports", "tables", "datasources", "dataflows", "pages", "measures", "presetDashboards", "presetDatasets", "presetCharts", "adlsObjects", "gcsObjects", "objects", "lookupFields", "projects", "workbooks", "flows", "worksheets", "datasourceFields", "calculatedFields");
        RELATION_ATTRIBUTES = List.of("name", "description");
    }

    private static enum FilterType {
        BY_GROUP,
        BY_ATLAN_TAG,
        BY_PREFIX;

    }
}

