/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.Link;
import com.atlan.model.enums.AtlanSearchableField;
import com.atlan.model.enums.KeywordFields;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.samples.reporters.AbstractReporter;
import com.atlan.samples.writers.ExcelWriter;
import com.atlan.samples.writers.S3Writer;
import com.atlan.util.QueryFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class SlackDiscussionReporter
extends AbstractReporter
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(SlackDiscussionReporter.class);
    private static final Map<String, String> SLACK_DISCUSSIONS = SlackDiscussionReporter.createSlackDiscussionHeader();
    private static final Set<String> autoSizeSheets = new HashSet<String>();
    private static final HashMap<String, Long> assetToSlackDiscussions = new HashMap();
    private static final HashMap<String, IAsset> guidToLinkedAsset = new HashMap();

    public static void main(String[] args) {
        SlackDiscussionReporter sdr = new SlackDiscussionReporter();
        sdr.handleRequest(System.getenv(), null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            this.setFilenameWithPrefix(event, "slack-discussion-report");
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            log.info("Creating Excel file (in-memory)...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            this.parseParametersFromEvent(event);
            ExcelWriter xlsx = new ExcelWriter();
            Sheet assets = xlsx.createSheet("Slack discussions");
            autoSizeSheets.add("Slack discussions");
            xlsx.addHeader(assets, SLACK_DISCUSSIONS);
            this.getSlackDiscussions(xlsx, assets);
            if (this.getBucket() != null) {
                S3Client s3Client = (S3Client)((S3ClientBuilder)S3Client.builder().region(this.getRegion())).build();
                S3Writer s3 = new S3Writer(s3Client);
                s3.putExcelFile(xlsx.asByteArray(), this.getBucket(), this.getFilename());
            } else {
                log.info("Writing report to file: {}", (Object)this.getFilename());
                xlsx.create(this.getFilename(), autoSizeSheets);
            }
        }
        catch (AtlanException e) {
            log.error("Failed to retrieve asset details from: {}", (Object)Atlan.getBaseUrlSafe(), (Object)e);
            System.exit(1);
        }
        catch (IOException e) {
            log.error("Failed to write Excel file to: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }

    void getSlackDiscussions(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        Query query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"Link")).build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((IndexSearchDSL)IndexSearchDSL.builder((Query)query).size(Integer.valueOf(this.getBatchSize())).sortOption(QueryFactory.Sort.by((AtlanSearchableField)KeywordFields.GUID, (SortOrder)SortOrder.Asc)).build()).attribute("asset").attribute("link").attribute("reference").relationAttribute("qualifiedName").relationAttribute("typeName").relationAttribute("name").build();
        log.info("Retrieving first {} link details from: {}", (Object)this.getBatchSize(), (Object)Atlan.getBaseUrlSafe());
        IndexSearchResponse response = request.search();
        List results = response.getAssets();
        while (results != null) {
            for (Asset asset : results) {
                Link link;
                if (!(asset instanceof Link) || (link = (Link)asset).getAsset() == null) continue;
                String assetGuid = link.getAsset().getGuid();
                String url = link.getLink();
                if (!url.contains("slack.com")) continue;
                if (!assetToSlackDiscussions.containsKey(assetGuid)) {
                    assetToSlackDiscussions.put(assetGuid, 0L);
                }
                assetToSlackDiscussions.put(assetGuid, assetToSlackDiscussions.get(assetGuid) + 1L);
                guidToLinkedAsset.put(assetGuid, link.getAsset());
            }
            log.info(" retrieving next {} link details from: {}", (Object)this.getBatchSize(), (Object)Atlan.getBaseUrlSafe());
            response = response.getNextPage();
            results = response.getAssets();
        }
        for (Map.Entry entry : assetToSlackDiscussions.entrySet()) {
            String assetGuid = (String)entry.getKey();
            Long linkCount = (Long)entry.getValue();
            IAsset asset = guidToLinkedAsset.get(assetGuid);
            if (asset == null) continue;
            xlsx.appendRow(sheet, List.of(ExcelWriter.DataCell.of(asset.getUniqueAttributes().getQualifiedName()), ExcelWriter.DataCell.of(asset.getTypeName()), ExcelWriter.DataCell.of(asset.getName()), ExcelWriter.DataCell.of(linkCount), ExcelWriter.DataCell.of(SlackDiscussionReporter.getAssetLink(assetGuid))));
        }
    }

    static Map<String, String> createSlackDiscussionHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Qualified name", "Unique name of the asset");
        map.put("Type", "Type of asset");
        map.put("Name", "Name of the asset");
        map.put("Slack", "Number of discussions through Slack linked to this asset");
        map.put("Link", "Link to the detailed asset within Atlan");
        return map;
    }
}

