/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.writers;

import com.atlan.model.enums.AtlanEnum;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter {
    private final Workbook workbook = new XSSFWorkbook();
    private final CellStyle headerStyle = this.createHeaderStyle();
    private final CellStyle dataStyle = this.createDataStyle();
    private final CellStyle linkStyle = this.createLinkStyle();

    public Sheet createSheet(String name) {
        return this.workbook.createSheet(name);
    }

    public void create(String fileLocation) throws IOException {
        this.create(fileLocation, null);
    }

    public void create(String fileLocation, Collection<String> autoSizeSheets) throws IOException {
        if (autoSizeSheets != null && !autoSizeSheets.isEmpty()) {
            for (String sheetName : autoSizeSheets) {
                Sheet worksheet = this.workbook.getSheet(sheetName);
                Row header = worksheet.getRow(0);
                int colCount = header.getLastCellNum();
                int rowCount = worksheet.getLastRowNum();
                for (int i = 0; i < colCount; ++i) {
                    int maxLength = 0;
                    block6: for (int j = 0; j < rowCount; ++j) {
                        Cell cell = worksheet.getRow(j).getCell(i);
                        if (cell == null) continue;
                        switch (cell.getCellType()) {
                            case BOOLEAN: {
                                maxLength = Math.max(maxLength, 5);
                                continue block6;
                            }
                            case NUMERIC: {
                                String tmp = "" + cell.getNumericCellValue();
                                maxLength = Math.max(maxLength, tmp.length());
                                continue block6;
                            }
                            default: {
                                maxLength = Math.max(maxLength, cell.getStringCellValue().length());
                            }
                        }
                    }
                    worksheet.setColumnWidth(i, Math.min(maxLength * 256, 65280));
                }
            }
        }
        FileOutputStream fos = new FileOutputStream(fileLocation);
        this.workbook.write((OutputStream)fos);
        this.workbook.close();
        fos.close();
    }

    public ByteArrayOutputStream asByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.workbook.write((OutputStream)baos);
        this.workbook.close();
        return baos;
    }

    private CellStyle createHeaderStyle() {
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setBorderBottom(BorderStyle.THICK);
        style.setBottomBorderColor(IndexedColors.BLACK1.getIndex());
        Font font = this.workbook.createFont();
        font.setFontName("Helvetica");
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    private CellStyle createDataStyle() {
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        Font font = this.workbook.createFont();
        font.setFontName("Helvetica");
        font.setBold(false);
        style.setFont(font);
        return style;
    }

    private CellStyle createLinkStyle() {
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        Font font = this.workbook.createFont();
        font.setFontName("Helvetica");
        font.setBold(false);
        font.setUnderline((byte)1);
        font.setColor(IndexedColors.BLUE.getIndex());
        style.setFont(font);
        return style;
    }

    public void addHeader(Sheet worksheet, Map<String, String> headers) {
        Row header = worksheet.createRow(0);
        int colIdx = 0;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey();
            String desc = entry.getValue();
            this.addHeaderCell(header, colIdx, name, desc);
            ++colIdx;
        }
    }

    public void appendRow(Sheet worksheet, List<DataCell> data) {
        Row row = worksheet.createRow(worksheet.getLastRowNum() + 1);
        block5: for (int i = 0; i < data.size(); ++i) {
            DataCell datum = data.get(i);
            switch (datum.getType()) {
                case DOUBLE: {
                    this.addDataCell(row, i, datum.getDecValue());
                    continue block5;
                }
                case LONG: {
                    this.addDataCell(row, i, datum.getLongValue());
                    continue block5;
                }
                case BOOLEAN: {
                    this.addDataCell(row, i, datum.getBoolValue());
                    continue block5;
                }
                default: {
                    this.addDataCell(row, i, datum.getStrValue());
                }
            }
        }
    }

    public void addHeaderCell(Row header, int index, String name, String description) {
        Drawing drawing = header.getSheet().createDrawingPatriarch();
        CreationHelper factory = this.workbook.getCreationHelper();
        Cell cell = header.createCell(index, CellType.STRING);
        cell.setCellValue(name);
        cell.setCellStyle(this.headerStyle);
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 1);
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + 1);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString(description);
        comment.setVisible(false);
        comment.setString(str);
        cell.setCellComment(comment);
    }

    public void addDataCell(Row row, int index, String value) {
        Cell cell = row.createCell(index, CellType.STRING);
        if (value == null) {
            cell.setCellValue("");
            cell.setCellStyle(this.dataStyle);
        } else {
            if (value.length() > Short.MAX_VALUE) {
                cell.setCellValue(value.substring(0, 32764) + "...");
            } else {
                cell.setCellValue(value);
            }
            if (value.startsWith("https://")) {
                Hyperlink link = this.workbook.getCreationHelper().createHyperlink(HyperlinkType.URL);
                link.setAddress(value);
                cell.setHyperlink(link);
                cell.setCellStyle(this.linkStyle);
            } else {
                cell.setCellStyle(this.dataStyle);
            }
        }
    }

    public void addDataCell(Row row, int index, boolean value) {
        Cell cell = row.createCell(index, CellType.BOOLEAN);
        cell.setCellValue(value);
        cell.setCellStyle(this.dataStyle);
    }

    public void addDataCell(Row row, int index, long value) {
        Cell cell = row.createCell(index, CellType.NUMERIC);
        cell.setCellValue((double)value);
        cell.setCellStyle(this.dataStyle);
    }

    public void addDataCell(Row row, int index, double value) {
        Cell cell = row.createCell(index, CellType.NUMERIC);
        cell.setCellValue(value);
        cell.setCellStyle(this.dataStyle);
    }

    public static final class DataCell {
        private final TYPE type;
        private final Double decValue;
        private final Long longValue;
        private final Boolean boolValue;
        private final String strValue;

        private DataCell(TYPE type, Double d, Long l, Boolean b, String s) {
            this.type = type;
            this.decValue = d;
            this.longValue = l;
            this.boolValue = b;
            this.strValue = s;
        }

        public static DataCell of(double value) {
            return new DataCell(TYPE.DOUBLE, value, null, null, null);
        }

        public static DataCell of(long value) {
            return new DataCell(TYPE.LONG, null, value, null, null);
        }

        public static DataCell of(boolean value) {
            return new DataCell(TYPE.BOOLEAN, null, null, value, null);
        }

        public static DataCell of(String value) {
            return new DataCell(TYPE.STRING, null, null, null, value == null ? "" : value);
        }

        public static DataCell of(AtlanEnum value) {
            return new DataCell(TYPE.STRING, null, null, null, value == null ? "" : value.getValue());
        }

        public TYPE getType() {
            return this.type;
        }

        public Double getDecValue() {
            return this.decValue;
        }

        public Long getLongValue() {
            return this.longValue;
        }

        public Boolean getBoolValue() {
            return this.boolValue;
        }

        public String getStrValue() {
            return this.strValue;
        }

        static enum TYPE {
            DOUBLE,
            LONG,
            BOOLEAN,
            STRING;

        }
    }
}

