/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.writers;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Writer {
    private static final Logger log = LoggerFactory.getLogger(S3Writer.class);
    private S3Client s3Client;

    public S3Writer(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public void putExcelFile(ByteArrayOutputStream outputStream, String bucket, String key) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Length", Integer.toString(outputStream.size()));
        metadata.put("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.putFile(metadata, outputStream, bucket, key);
    }

    public void putFile(Map<String, String> metadata, ByteArrayOutputStream outputStream, String bucket, String key) {
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(key).metadata(metadata).build();
        log.info("Writing to: {}/{}", (Object)bucket, (Object)key);
        try {
            this.s3Client.putObject(putObjectRequest, RequestBody.fromBytes((byte[])outputStream.toByteArray()));
        }
        catch (AwsServiceException e) {
            log.error("Unable to create the S3 object.", (Throwable)e);
            System.exit(1);
        }
    }
}

