/*
 * Decompiled with CFR 0.152.
 */
package com.probable.guacamole.instances;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.api.EntityBulkEndpoint;
import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanSearchableField;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.AssetBatch;
import com.atlan.util.QueryFactory;
import com.probable.guacamole.AtlanRunner;
import com.probable.guacamole.model.assets.GuacamoleColumn;
import com.probable.guacamole.model.assets.GuacamoleTable;
import com.probable.guacamole.model.enums.GuacamoleTemperature;
import com.probable.guacamole.model.enums.KeywordFields;
import com.probable.guacamole.model.enums.NumericFields;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager
extends AtlanRunner {
    private static final Logger log = LoggerFactory.getLogger(InstanceManager.class);
    private static Connection connection = null;

    public static void main(String[] args) {
        InstanceManager im = new InstanceManager();
        im.createConnection();
        im.createEntities();
        im.readEntities();
        im.updateEntities();
        im.searchEntities();
        im.purgeEntities();
    }

    void createConnection() {
        try {
            List results = Connection.findByName((String)"guacamole", (AtlanConnectorType)AtlanConnectorType.MONGODB, null);
            if (results.size() > 0) {
                connection = (Connection)results.get(0);
                log.info("Connection already exists, reusing it: {}", (Object)connection.getQualifiedName());
            }
        }
        catch (NotFoundException err) {
            try {
                Connection toCreate = Connection.creator((String)"guacamole", (AtlanConnectorType)AtlanConnectorType.MONGODB, List.of(RoleCache.getIdForName((String)"$admin")), null, null).build();
                AssetMutationResponse response = toCreate.upsert().block();
                connection = (Connection)response.getCreatedAssets().get(0);
            }
            catch (AtlanException e) {
                log.error("Unable to create a new connection.", (Throwable)e);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to search for existing connection.", (Throwable)e);
        }
    }

    void createEntities() {
        Asset table = ((GuacamoleTable.GuacamoleTableBuilder)((Object)((GuacamoleTable.GuacamoleTableBuilder)((Object)((GuacamoleTable.GuacamoleTableBuilder)((Object)((GuacamoleTable.GuacamoleTableBuilder)((GuacamoleTable.GuacamoleTableBuilder)((GuacamoleTable.GuacamoleTableBuilder)((GuacamoleTable.GuacamoleTableBuilder)GuacamoleTable.builder().connectionQualifiedName(connection.getQualifiedName())).connectorType(AtlanConnectorType.MONGODB)).name("table")).qualifiedName(connection.getQualifiedName() + "/table")).guacamoleTemperature(GuacamoleTemperature.HOT))).guacamoleArchived(false))).guacamoleSize(123L))).build();
        try {
            AssetMutationResponse response = table.upsert();
            log.info("Created table entity: {}", (Object)response);
            table = (GuacamoleTable)response.getCreatedAssets().get(0);
        }
        catch (AtlanException e) {
            log.error("Failed to create new guacamole table.", (Throwable)e);
        }
        try {
            AssetBatch batch = new AssetBatch("GuacamoleColumn", 20);
            Asset child1 = ((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)GuacamoleColumn.builder().connectionQualifiedName(connection.getQualifiedName())).connectorType(AtlanConnectorType.MONGODB)).name("column1")).qualifiedName(table.getQualifiedName() + "/column1")).guacamoleTable(GuacamoleTable.refByGuid(table.getGuid())))).guacamoleConceptualized(123456789L))).guacamoleWidth(100L))).build();
            batch.add(child1);
            Asset child2 = ((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)((GuacamoleColumn.GuacamoleColumnBuilder)GuacamoleColumn.builder().connectionQualifiedName(connection.getQualifiedName())).connectorType(AtlanConnectorType.MONGODB)).name("column2")).qualifiedName(table.getQualifiedName() + "/column2")).guacamoleTable(GuacamoleTable.refByGuid(table.getGuid())))).guacamoleConceptualized(1234567890L))).guacamoleWidth(200L))).build();
            batch.add(child2);
            AssetMutationResponse response = batch.flush();
            log.info("Created child entities: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert Guacamole columns.", (Throwable)e);
        }
    }

    void readEntities() {
        String parentQN = connection.getQualifiedName() + "/table";
        String child1QN = parentQN + "/column1";
        String child2QN = parentQN + "/column2";
        try {
            GuacamoleTable table = GuacamoleTable.retrieveByQualifiedName(parentQN);
            assert (table.getQualifiedName().equals(parentQN));
            assert (table.getGuacamoleColumns().size() == 2);
            String tableGuid = table.getGuid();
            GuacamoleColumn one = GuacamoleColumn.retrieveByQualifiedName(child1QN);
            assert (one.getQualifiedName().equals(child1QN));
            assert (one.getGuacamoleTable().getGuid().equals(tableGuid));
            GuacamoleColumn two = GuacamoleColumn.retrieveByQualifiedName(child2QN);
            assert (two.getQualifiedName().equals(child2QN));
            assert (two.getGuacamoleTable().getGuid().equals(tableGuid));
        }
        catch (AtlanException e) {
            log.error("Unable to read entities.", (Throwable)e);
        }
    }

    void updateEntities() {
        Asset toUpdate = ((GuacamoleTable.GuacamoleTableBuilder)((GuacamoleTable.GuacamoleTableBuilder)GuacamoleTable.updater(connection.getQualifiedName() + "/table", "table").description("Now with a description!")).certificateStatus(CertificateStatus.DRAFT)).build();
        try {
            AssetMutationResponse response = toUpdate.upsert();
            log.info("Updated parent: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Unable to update entity.", (Throwable)e);
        }
    }

    void searchEntities() {
        IndexSearchResponse response;
        Query query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOneOfTypes(List.of("GuacamoleTable", "GuacamoleColumn"))).build()._toQuery();
        IndexSearchRequest request = IndexSearchRequest.builder((Query)query).build();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 3L);
            assert (response.getAssets().size() == 3);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"GuacamoleColumn")).must(QueryFactory.have((AtlanSearchableField)KeywordFields.NAME).eq("column1")).build()._toQuery();
        request = IndexSearchRequest.builder((Query)query).build();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"GuacamoleColumn")).must(QueryFactory.have((AtlanSearchableField)NumericFields.GUACAMOLE_WIDTH).gt((Number)150L)).build()._toQuery();
        request = IndexSearchRequest.builder((Query)query).build();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        query = QueryFactory.CompoundQuery.builder().must(QueryFactory.beActive()).must(QueryFactory.beOfType((String)"GuacamoleTable")).must(QueryFactory.have((AtlanSearchableField)KeywordFields.DESCRIPTION).startingWith("Now")).build()._toQuery();
        request = IndexSearchRequest.builder((Query)query).build();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
    }

    void purgeEntities() {
        String parentQN = connection.getQualifiedName() + "/table";
        String child1QN = parentQN + "/column1";
        String child2QN = parentQN + "/column2";
        try {
            GuacamoleTable parent = GuacamoleTable.retrieveByQualifiedName(parentQN);
            GuacamoleColumn one = GuacamoleColumn.retrieveByQualifiedName(child1QN);
            GuacamoleColumn two = GuacamoleColumn.retrieveByQualifiedName(child2QN);
            EntityBulkEndpoint.delete(List.of(parent.getGuid(), one.getGuid(), two.getGuid()), (AtlanDeleteType)AtlanDeleteType.PURGE);
            log.info("Entities purged.");
        }
        catch (AtlanException e) {
            log.error("Unable to purge entities.", (Throwable)e);
        }
    }
}

