/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.cache.ReflectionCache;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.fields.AtlanField;
import com.atlan.samples.loaders.AbstractLoader;
import com.atlan.samples.readers.AssetGenerator;
import com.atlan.samples.readers.CSVReader;
import com.atlan.serde.Serde;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssetLoader
extends AbstractLoader
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(AssetLoader.class);

    public abstract List<AtlanField> getAttributesToOverwrite();

    public AssetGenerator getRowToAssetTranslator() {
        return (row, header, typeIdx, qnIdx) -> {
            String typeName = (String)row.get(typeIdx);
            String qualifiedName = (String)row.get(qnIdx);
            if (typeName != null && !typeName.isEmpty() && qualifiedName != null && !qualifiedName.isEmpty()) {
                try {
                    Class assetClass = Serde.getAssetClassForType((String)typeName);
                    Method method = assetClass.getMethod("_internal", new Class[0]);
                    Asset.AssetBuilder builder = (Asset.AssetBuilder)method.invoke(null, new Object[0]);
                    HashMap<String, CustomMetadataAttributes.CustomMetadataAttributesBuilder> customMetadataMap = new HashMap<String, CustomMetadataAttributes.CustomMetadataAttributesBuilder>();
                    for (int i = 0; i < header.size(); ++i) {
                        String fieldName = (String)header.get(i);
                        if (fieldName == null || fieldName.isEmpty()) continue;
                        String rValue = (String)row.get(i);
                        if (fieldName.contains("::")) {
                            String[] tokens = fieldName.split(Pattern.quote("::"));
                            String setName = tokens[0];
                            String attrName = tokens[1];
                            if (!customMetadataMap.containsKey(setName)) {
                                customMetadataMap.put(setName, CustomMetadataAttributes.builder());
                            }
                            Object value = this.deserializeCMValueFromCSV(rValue);
                            ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)customMetadataMap.get(setName)).attribute(attrName, value);
                            continue;
                        }
                        String deserializedFieldName = ReflectionCache.getDeserializedName((Class)assetClass, (String)fieldName);
                        try {
                            Object value;
                            Method setter = ReflectionCache.getSetter(builder.getClass(), (String)deserializedFieldName);
                            if (setter == null || (value = this.deserializeValueFromCSV(rValue, setter)) == null) continue;
                            ReflectionCache.setValue((Asset.AssetBuilder)builder, (String)deserializedFieldName, (Object)value);
                            continue;
                        }
                        catch (IOException e) {
                            log.error("Unable to deserialize a value from the CSV.", (Throwable)e);
                            continue;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            log.error("Unable to set value for {} on: {}::{}", new Object[]{deserializedFieldName, typeName, qualifiedName, e});
                        }
                    }
                    if (!customMetadataMap.isEmpty()) {
                        for (Map.Entry entry : customMetadataMap.entrySet()) {
                            builder.customMetadata((String)entry.getKey(), ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)entry.getValue()).build());
                        }
                    }
                    Asset candidate = builder.build();
                    for (AtlanField field : this.getAttributesToOverwrite()) {
                        try {
                            Method getter = ReflectionCache.getGetter((Class)Serde.getAssetClassForType((String)candidate.getTypeName()), (String)field.getAtlanFieldName());
                            if (getter.invoke((Object)candidate, new Object[0]) != null) continue;
                            builder.nullField(field.getAtlanFieldName());
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Unknown type {} \u2014 cannot clear {}.", new Object[]{candidate.getTypeName(), field.getAtlanFieldName(), e});
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            log.error("Unable to clear {} on: {}::{}", new Object[]{field.getAtlanFieldName(), candidate.getTypeName(), candidate.getQualifiedName(), e});
                        }
                    }
                    return builder.build();
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("Unable to dynamically retrieve asset for typeName {}, skipping...", (Object)typeName, (Object)e);
                }
            }
            log.warn("Unable to parse any asset when either (or both) typeName ({}) and qualifiedName ({}) are empty.", (Object)typeName, (Object)qualifiedName);
            return null;
        };
    }

    public String handleRequest(Map<String, String> event, Context context) {
        log.info("Retrieving configuration and context...");
        if (context != null && context.getClientContext() != null) {
            log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
            log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
        }
        this.parseParametersFromEvent(event);
        log.info("Loading assets from: {}", (Object)this.getFilename());
        try (CSVReader csv = new CSVReader(this.getFilename());){
            long start = System.currentTimeMillis();
            csv.streamRows(this.getRowToAssetTranslator(), this.getBatchSize());
            long finish = System.currentTimeMillis();
            log.info("Total time taken: {} ms", (Object)(finish - start));
        }
        catch (IOException e) {
            log.error("Unable to read from file: {}", (Object)this.getFilename(), (Object)e);
        }
        return this.getFilename();
    }

    public static Map<String, String> prepEvent() {
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("DELIMITER")) {
            event.put("DELIMITER", "|");
        }
        if (!event.containsKey("FILENAME")) {
            event.put("FILENAME", "asset-reporter.csv");
        }
        return event;
    }
}

