/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.samples.loaders.AbstractLoader;
import com.atlan.samples.loaders.caches.CategoryCache;
import com.atlan.samples.loaders.caches.GlossaryCache;
import com.atlan.samples.loaders.caches.TermCache;
import com.atlan.samples.loaders.models.AssetEnrichmentDetails;
import com.atlan.samples.loaders.models.CategoryEnrichmentDetails;
import com.atlan.samples.loaders.models.EnrichmentDetails;
import com.atlan.samples.loaders.models.GlossaryEnrichmentDetails;
import com.atlan.samples.loaders.models.TermEnrichmentDetails;
import com.atlan.samples.readers.ExcelReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentLoader
extends AbstractLoader
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(EnrichmentLoader.class);
    private static final String GLOSSARY_ENRICHMENT = "Glossary enrichment";
    private static final String CATEGORY_ENRICHMENT = "Category enrichment";
    private static final String TERM_ENRICHMENT = "Term enrichment";
    private static final String ASSET_ENRICHMENT = "Asset enrichment";
    private static boolean REPLACE_CLASSIFICATIONS = false;
    private static boolean REPLACE_CUSTOM_METADATA = false;

    public static void main(String[] args) {
        EnrichmentLoader el = new EnrichmentLoader();
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("DELIMITER")) {
            event.put("DELIMITER", ",");
        }
        if (!event.containsKey("FILENAME")) {
            event.put("FILENAME", "atlan-enrichment.xlsx");
        }
        el.handleRequest(event, null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            String replaceClassifications = event.getOrDefault("REPLACE_CLASSIFICATIONS", "false");
            REPLACE_CLASSIFICATIONS = replaceClassifications.toUpperCase(Locale.ROOT).equals("TRUE");
            String replaceCM = event.getOrDefault("REPLACE_CUSTOM_METADATA", "false");
            REPLACE_CUSTOM_METADATA = replaceCM.toUpperCase(Locale.ROOT).equals("TRUE");
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            TermCache termCache;
            String identity;
            EnrichmentDetails existing;
            EnrichmentDetails details;
            GlossaryCache glossaryCache;
            log.info("Retrieving configuration and context...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            this.parseParametersFromEvent(event);
            log.info("Loading enrichment details from: {}", (Object)this.getFilename());
            ExcelReader xlsx = new ExcelReader(this.getFilename());
            try {
                List<Map<String, String>> glossaryData = xlsx.getRowsFromSheet(GLOSSARY_ENRICHMENT, 0);
                log.info("Processing sheet {}, with {} rows.", (Object)GLOSSARY_ENRICHMENT, (Object)glossaryData.size());
                LinkedHashMap<String, GlossaryEnrichmentDetails> glossaries = new LinkedHashMap<String, GlossaryEnrichmentDetails>();
                for (Map<String, String> row : glossaryData) {
                    String identity2;
                    GlossaryEnrichmentDetails existing2;
                    GlossaryEnrichmentDetails glossaryEnrichmentDetails = GlossaryEnrichmentDetails.getFromRow(row, this.getDelimiter());
                    if (glossaryEnrichmentDetails == null || (existing2 = (GlossaryEnrichmentDetails)glossaries.get(identity2 = glossaryEnrichmentDetails.getIdentity())) != null && !existing2.isStub()) continue;
                    glossaries.put(identity2, glossaryEnrichmentDetails);
                }
                glossaryCache = GlossaryEnrichmentDetails.upsert(glossaries, this.getBatchSize(), REPLACE_CLASSIFICATIONS, REPLACE_CUSTOM_METADATA, this.isUpdateOnly());
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping.", (Object)GLOSSARY_ENRICHMENT);
                glossaryCache = new GlossaryCache();
            }
            CategoryCache categoryCache = new CategoryCache();
            try {
                List<Map<String, String>> categoryData = xlsx.getRowsFromSheet(CATEGORY_ENRICHMENT, 0);
                log.info("Processing sheet {}, with {} rows.", (Object)CATEGORY_ENRICHMENT, (Object)categoryData.size());
                LinkedHashMap<String, CategoryEnrichmentDetails> categories = new LinkedHashMap<String, CategoryEnrichmentDetails>();
                for (Map map : categoryData) {
                    String identity3;
                    CategoryEnrichmentDetails existing3;
                    CategoryEnrichmentDetails details3 = CategoryEnrichmentDetails.getFromRow(glossaryCache, (Map<String, String>)map, this.getDelimiter());
                    if (details3 == null || (existing3 = (CategoryEnrichmentDetails)categories.get(identity3 = details3.getIdentity())) != null && !existing3.isStub()) continue;
                    categories.put(identity3, details3);
                }
                CategoryEnrichmentDetails.upsert(categoryCache, categories, this.getBatchSize(), 1, REPLACE_CLASSIFICATIONS, REPLACE_CUSTOM_METADATA, this.isUpdateOnly());
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping", (Object)CATEGORY_ENRICHMENT);
            }
            try {
                List<Map<String, String>> termData = xlsx.getRowsFromSheet(TERM_ENRICHMENT, 0);
                log.info("Processing sheet {}, with {} rows.", (Object)TERM_ENRICHMENT, (Object)termData.size());
                LinkedHashMap<String, TermEnrichmentDetails> terms = new LinkedHashMap<String, TermEnrichmentDetails>();
                for (Map<String, String> row : termData) {
                    details = TermEnrichmentDetails.getFromRow(glossaryCache, categoryCache, row, this.getDelimiter());
                    if (details == null || (existing = (TermEnrichmentDetails)terms.get(identity = ((TermEnrichmentDetails)details).getIdentity())) != null && !existing.isStub()) continue;
                    terms.put(identity, (TermEnrichmentDetails)details);
                }
                termCache = TermEnrichmentDetails.upsert(terms, this.getBatchSize(), REPLACE_CLASSIFICATIONS, REPLACE_CUSTOM_METADATA, this.isUpdateOnly());
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping", (Object)TERM_ENRICHMENT);
                termCache = new TermCache();
            }
            try {
                List<Map<String, String>> assetData = xlsx.getRowsFromSheet(ASSET_ENRICHMENT, 0);
                log.info("Processing sheet {}, with {} rows.", (Object)ASSET_ENRICHMENT, (Object)assetData.size());
                LinkedHashMap<String, AssetEnrichmentDetails> assets = new LinkedHashMap<String, AssetEnrichmentDetails>();
                for (Map<String, String> row : assetData) {
                    details = AssetEnrichmentDetails.getFromRow(termCache, row, this.getDelimiter());
                    if (details == null || (existing = (AssetEnrichmentDetails)assets.get(identity = ((AssetEnrichmentDetails)details).getIdentity())) != null && !existing.isStub()) continue;
                    assets.put(identity, (AssetEnrichmentDetails)details);
                }
                AssetEnrichmentDetails.upsert(assets, this.getBatchSize(), REPLACE_CLASSIFICATIONS, REPLACE_CUSTOM_METADATA, this.isUpdateOnly());
            }
            catch (IOException e) {
                log.warn("Could not find sheet: {} \u2014 skipping.", (Object)ASSET_ENRICHMENT);
            }
        }
        catch (IOException e) {
            log.error("Failed to read Excel file from: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }
}

