/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.caches;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.samples.loaders.caches.AssetCache;
import com.atlan.samples.loaders.models.CategoryEnrichmentDetails;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryCache
extends AssetCache {
    private static final Logger log = LoggerFactory.getLogger(CategoryCache.class);

    @Override
    protected Asset lookupAsset(String identity) {
        String glossaryName = CategoryEnrichmentDetails.getGlossaryNameFromIdentity(identity);
        try {
            Asset foundCategory = null;
            Glossary glossary = Glossary.findByName((String)glossaryName, List.of("name"));
            Glossary.CategoryHierarchy hierarchy = glossary.getHierarchy(List.of("anchor"));
            for (IGlossaryCategory category : hierarchy.breadthFirst()) {
                String categoryPath = this.getCategoryPath(hierarchy, category);
                String categoryId = CategoryEnrichmentDetails.getIdentity(categoryPath, (Asset)glossary);
                this.put(categoryId, (Asset)category);
                if (!categoryId.equals(identity)) continue;
                foundCategory = (Asset)category;
            }
            return foundCategory;
        }
        catch (NotFoundException e) {
            log.info("No existing categories found in glossary: {}", (Object)glossaryName);
        }
        catch (AtlanException e) {
            log.error("Unable to lookup or find category: {}", (Object)identity, (Object)e);
        }
        return null;
    }

    private String getCategoryPath(Glossary.CategoryHierarchy hierarchy, IGlossaryCategory category) {
        String parentPath = null;
        if (category.getParentCategory() != null) {
            GlossaryCategory parent = hierarchy.getCategory(category.getParentCategory().getGuid());
            parentPath = this.getCategoryPath(hierarchy, (IGlossaryCategory)parent);
        }
        return parentPath == null ? category.getName() : parentPath + "@" + category.getName();
    }
}

