/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.samples.loaders.caches.CategoryCache;
import com.atlan.samples.loaders.caches.GlossaryCache;
import com.atlan.samples.loaders.models.EnrichmentDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryEnrichmentDetails
extends EnrichmentDetails {
    private static final Logger log = LoggerFactory.getLogger(CategoryEnrichmentDetails.class);
    public static final String COL_GLOSSARY = "GLOSSARY NAME";
    public static final String COL_CATEGORY_PATH = "CATEGORY PATH";
    private static final List<String> REQUIRED = List.of("GLOSSARY NAME", "CATEGORY PATH");
    private static final String categoryGlossaryDelimiter = "@@@";
    private Asset glossary;
    private String categoryPath;

    @Override
    public String getIdentity() {
        return CategoryEnrichmentDetails.getIdentity(this.categoryPath, this.glossary);
    }

    public static String getPathFromIdentity(String identity) {
        if (identity != null && identity.contains(categoryGlossaryDelimiter)) {
            return identity.substring(0, identity.indexOf(categoryGlossaryDelimiter));
        }
        return null;
    }

    public static String getNameFromPath(String path) {
        if (path != null && path.contains("@")) {
            return path.substring(path.lastIndexOf("@"));
        }
        return path;
    }

    public static String getGlossaryNameFromIdentity(String identity) {
        if (identity != null && identity.contains(categoryGlossaryDelimiter)) {
            return identity.substring(identity.indexOf(categoryGlossaryDelimiter) + categoryGlossaryDelimiter.length());
        }
        return null;
    }

    public static String getIdentity(String categoryPath, Asset glossary) {
        return categoryPath + categoryGlossaryDelimiter + glossary.getName();
    }

    public static CategoryEnrichmentDetails getFromRow(GlossaryCache glossaryCache, Map<String, String> row, String delim) {
        CategoryEnrichmentDetailsBuilder builder = CategoryEnrichmentDetails.getFromRow(CategoryEnrichmentDetails.builder(), row, delim);
        if (CategoryEnrichmentDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            Asset glossary = glossaryCache.get(row.get(COL_GLOSSARY));
            if (glossary != null) {
                builder = (CategoryEnrichmentDetailsBuilder)((CategoryEnrichmentDetailsBuilder)((CategoryEnrichmentDetailsBuilder)((EnrichmentDetails.EnrichmentDetailsBuilder)((CategoryEnrichmentDetailsBuilder)builder.glossary(glossary)).categoryPath(row.get(COL_CATEGORY_PATH))).userDescription(row.get("USER DESCRIPTION"))).readme(row.get("README"))).customMetadataValues(CategoryEnrichmentDetails.getCustomMetadataValuesFromRow(row, delim));
                return ((CategoryEnrichmentDetailsBuilder)builder.stub(false)).build();
            }
            log.warn("Unknown glossary {} \u2014 skipping category: {}", (Object)row.get(COL_GLOSSARY), (Object)row.get(COL_CATEGORY_PATH));
        }
        return null;
    }

    public static void upsert(CategoryCache categoryCache, Map<String, CategoryEnrichmentDetails> categories, int batchSize, int level, boolean replaceClassifications, boolean replaceCM, boolean updateOnly) {
        HashMap<String, String> readmes = new HashMap<String, String>();
        HashMap<String, Map<String, CustomMetadataAttributes>> cmToUpdate = new HashMap<String, Map<String, CustomMetadataAttributes>>();
        LinkedHashMap<String, CategoryEnrichmentDetails> leftovers = new LinkedHashMap<String, CategoryEnrichmentDetails>();
        HashSet<String> bulkInitialized = new HashSet<String>();
        long localCount = 0L;
        long totalResults = categories.size();
        for (CategoryEnrichmentDetails details : categories.values()) {
            if (!bulkInitialized.contains(details.getGlossary().getQualifiedName())) {
                categoryCache.get(details.getIdentity());
                bulkInitialized.add(details.getGlossary().getQualifiedName());
            }
            Asset glossary = details.getGlossary();
            String categoryPath = details.getCategoryPath();
            String[] tokens = categoryPath.split(Pattern.quote("@"));
            if (tokens.length == level) {
                String readmeContents;
                Asset resolved;
                String categoryName = tokens[tokens.length - 1];
                GlossaryCategory.GlossaryCategoryBuilder builder = null;
                if (!categoryCache.containsKey(details.getIdentity()) || categoryCache.get(details.getIdentity()) == null) {
                    if (updateOnly) {
                        log.warn("Unable to find existing category \u2014 skipping: {}@{}", (Object)categoryName, (Object)glossary.getName());
                    } else {
                        builder = GlossaryCategory.creator((String)categoryName, (String)glossary.getGuid());
                    }
                } else {
                    builder = ((GlossaryCategory)categoryCache.get(details.getIdentity())).toBuilder();
                }
                if (builder == null) continue;
                builder = (GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)((GlossaryCategory.GlossaryCategoryBuilder)builder.description(details.getDescription())).userDescription(details.getUserDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups());
                if (details.getCustomMetadataValues() != null) {
                    builder = (GlossaryCategory.GlossaryCategoryBuilder)builder.customMetadataSets(details.getCustomMetadataValues());
                }
                if (tokens.length > 1) {
                    String parentPath = categoryPath.substring(0, categoryPath.lastIndexOf("@"));
                    String parentName = parentPath.contains("@") ? parentPath.substring(parentPath.lastIndexOf("@") + 1) : parentPath;
                    String parentIdentity = CategoryEnrichmentDetails.getIdentity(parentPath, glossary);
                    Asset parent = categoryCache.get(parentIdentity);
                    if (parent != null) {
                        builder = builder.parentCategory((IGlossaryCategory)GlossaryCategory.refByGuid((String)parent.getGuid()));
                    } else {
                        log.error("Parent category {} in glossary {} not defined in spreadsheet \u2014 cannot create {} as a child of this category.", new Object[]{parentName, glossary.getName(), categoryName});
                    }
                }
                GlossaryCategory category = builder.build();
                try {
                    AssetMutationResponse response;
                    AssetMutationResponse assetMutationResponse = response = replaceCM ? category.saveReplacingCM(replaceClassifications) : category.saveMergingCM(replaceClassifications);
                    if (response != null) {
                        List updated;
                        log.info(" ... processed {}/{} ({}%)", new Object[]{++localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                        List created = response.getCreatedAssets();
                        if (created != null) {
                            for (Asset one : created) {
                                if (!(one instanceof GlossaryCategory) || !one.getName().equals(categoryName)) continue;
                                categoryCache.put(details.getIdentity(), one);
                            }
                        }
                        if ((updated = response.getUpdatedAssets()) != null) {
                            for (Asset one : updated) {
                                if (!(one instanceof GlossaryCategory) || !one.getName().equals(categoryName)) continue;
                                categoryCache.put(details.getIdentity(), one);
                            }
                        }
                    }
                    if (!categoryCache.containsKey(details.getIdentity())) {
                        categoryCache.put(details.getIdentity(), (Asset)category);
                    }
                }
                catch (AtlanException e) {
                    log.error("Unable to upsert category: {}", (Object)details.getIdentity(), (Object)e);
                }
                if (!replaceCM && !details.getCustomMetadataValues().isEmpty() && (resolved = categoryCache.get(details.getIdentity())) != null) {
                    cmToUpdate.put(resolved.getGuid(), details.getCustomMetadataValues());
                }
                if ((readmeContents = details.getReadme()) == null || readmeContents.isEmpty()) continue;
                readmes.put(details.getIdentity(), readmeContents);
                continue;
            }
            leftovers.put(details.getIdentity(), details);
        }
        if (!replaceCM) {
            CategoryEnrichmentDetails.selectivelyUpdateCustomMetadata(cmToUpdate);
        }
        try {
            AssetBatch readmeBatch = new AssetBatch(Atlan.getDefaultClient(), "Readme", batchSize);
            for (Map.Entry entry : readmes.entrySet()) {
                String categoryIdentity = (String)entry.getKey();
                String readmeContent = (String)entry.getValue();
                Asset category = categoryCache.get(categoryIdentity);
                if (category != null) {
                    Readme readme = Readme.creator((Asset)category, (String)readmeContent).build();
                    readmeBatch.add((Asset)readme);
                    continue;
                }
                log.error("Unable to find category GUID for {} \u2014 cannot add README.", (Object)categoryIdentity);
            }
            readmeBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert READMEs for categories.", (Throwable)e);
        }
        if (!leftovers.isEmpty()) {
            CategoryEnrichmentDetails.upsert(categoryCache, leftovers, batchSize, level + 1, replaceClassifications, replaceCM, updateOnly);
        }
    }

    protected CategoryEnrichmentDetails(CategoryEnrichmentDetailsBuilder<?, ?> b) {
        super((EnrichmentDetails.EnrichmentDetailsBuilder<?, ?>)b);
        this.glossary = b.glossary;
        this.categoryPath = b.categoryPath;
    }

    public static CategoryEnrichmentDetailsBuilder<?, ?> builder() {
        return new CategoryEnrichmentDetailsBuilderImpl();
    }

    public Asset getGlossary() {
        return this.glossary;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryEnrichmentDetails)) {
            return false;
        }
        CategoryEnrichmentDetails other = (CategoryEnrichmentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asset this$glossary = this.getGlossary();
        Asset other$glossary = other.getGlossary();
        if (this$glossary == null ? other$glossary != null : !this$glossary.equals(other$glossary)) {
            return false;
        }
        String this$categoryPath = this.getCategoryPath();
        String other$categoryPath = other.getCategoryPath();
        return !(this$categoryPath == null ? other$categoryPath != null : !this$categoryPath.equals(other$categoryPath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CategoryEnrichmentDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asset $glossary = this.getGlossary();
        result = result * 59 + ($glossary == null ? 43 : $glossary.hashCode());
        String $categoryPath = this.getCategoryPath();
        result = result * 59 + ($categoryPath == null ? 43 : $categoryPath.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CategoryEnrichmentDetails(super=" + super.toString() + ", glossary=" + this.getGlossary() + ", categoryPath=" + this.getCategoryPath() + ")";
    }

    private static final class CategoryEnrichmentDetailsBuilderImpl
    extends CategoryEnrichmentDetailsBuilder<CategoryEnrichmentDetails, CategoryEnrichmentDetailsBuilderImpl> {
        private CategoryEnrichmentDetailsBuilderImpl() {
        }

        @Override
        protected CategoryEnrichmentDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public CategoryEnrichmentDetails build() {
            return new CategoryEnrichmentDetails(this);
        }
    }

    public static abstract class CategoryEnrichmentDetailsBuilder<C extends CategoryEnrichmentDetails, B extends CategoryEnrichmentDetailsBuilder<C, B>>
    extends EnrichmentDetails.EnrichmentDetailsBuilder<C, B> {
        private Asset glossary;
        private String categoryPath;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B glossary(Asset glossary) {
            this.glossary = glossary;
            return (B)this.self();
        }

        public B categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CategoryEnrichmentDetails.CategoryEnrichmentDetailsBuilder(super=" + super.toString() + ", glossary=" + this.glossary + ", categoryPath=" + this.categoryPath + ")";
        }
    }
}

