/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Column;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.samples.loaders.models.ContainerDetails;
import com.atlan.samples.loaders.models.DataTypeMapper;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(ColumnDetails.class);
    public static final String COL_COLUMN = "COLUMN NAME";
    public static final String COL_COLUMN_TYPE = "COLUMN DATA TYPE";
    public static final String COL_COLUMN_PK = "PRIMARY KEY?";
    public static final String COL_COLUMN_FK = "FOREIGN KEY?";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "DATABASE NAME", "SCHEMA NAME", "CONTAINER NAME", "CONTAINER TYPE", "COLUMN NAME");
    private int index;
    private String name;
    private String parentType;
    private String parentQualifiedName;
    private String rawType;
    private String mappedType;
    private Boolean primaryKey;
    private Boolean foreignKey;

    @Override
    public String getIdentity() {
        return this.parentQualifiedName + "/" + this.name;
    }

    public static ColumnDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim, int index) {
        Object builder = ColumnDetails.getFromRow(ColumnDetails.builder(), row, delim);
        if (ColumnDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String containerQualifiedName = ContainerDetails.getQualifiedName(connectionCache, row);
            builder = ((ColumnDetailsBuilder)((ColumnDetailsBuilder)((ColumnDetailsBuilder)((ColumnDetailsBuilder)((ColumnDetailsBuilder)((ColumnDetailsBuilder)builder).index(index)).name(row.get(COL_COLUMN))).parentQualifiedName(containerQualifiedName)).parentType(row.get("CONTAINER TYPE"))).primaryKey(ColumnDetails.getBoolean(row.get(COL_COLUMN_PK)))).foreignKey(ColumnDetails.getBoolean(row.get(COL_COLUMN_FK)));
            String rawType = row.get(COL_COLUMN_TYPE);
            String rawTypeOnly = DataTypeMapper.getTypeOnly(rawType);
            String mappedType = DataTypeMapper.getMappedType(rawTypeOnly);
            if (rawType != null && !rawType.isEmpty()) {
                builder = ((ColumnDetailsBuilder)builder).rawType(rawType);
            }
            if (mappedType != null && !mappedType.isEmpty()) {
                builder = ((ColumnDetailsBuilder)builder).mappedType(mappedType);
            }
            return ((ColumnDetailsBuilder)((AssetDetails.AssetDetailsBuilder)builder).stub(false)).build();
        }
        return null;
    }

    public static Set<ContainerDetails> upsert(Map<String, ColumnDetails> columns, int batchSize, boolean updateOnly) {
        HashSet<ContainerDetails> parents = new HashSet<ContainerDetails>();
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "Column", batchSize);
        HashMap<String, List<String>> toClassify = new HashMap<String, List<String>>();
        long totalResults = columns.size();
        long localCount = 0L;
        try {
            for (ColumnDetails details : columns.values()) {
                String parentQualifiedName = details.getParentQualifiedName();
                String parentType = details.getParentType();
                String columnName = details.getName();
                parents.add(ContainerDetails.getHeader(parentQualifiedName, parentType));
                if (updateOnly) {
                    String qualifiedName = Column.generateQualifiedName((String)columnName, (String)parentQualifiedName);
                    try {
                        Column.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
                        Column toUpdate = ((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)Column.updater((String)qualifiedName, (String)columnName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).isPrimary(details.getPrimaryKey()).isForeign(details.getForeignKey()).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassify.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                        }
                        ++localCount;
                        if (batch.add((Asset)toUpdate) == null) continue;
                        log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                    }
                    catch (NotFoundException e) {
                        log.warn("Unable to find existing column \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to lookup whether column exists or not.", (Throwable)e);
                    }
                    continue;
                }
                String mappedType = details.getMappedType();
                String rawType = details.getRawType();
                Column.ColumnBuilder builder = ((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)((Column.ColumnBuilder)Column.creator((String)columnName, (String)parentType, (String)parentQualifiedName, (int)details.getIndex()).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).dataType(mappedType).isPrimary(details.getPrimaryKey()).isForeign(details.getForeignKey());
                Long maxLength = DataTypeMapper.getMaxLength(rawType);
                Integer precision = DataTypeMapper.getPrecision(rawType);
                Double scale = DataTypeMapper.getScale(rawType);
                if (maxLength != null) {
                    builder = builder.maxLength(maxLength);
                }
                if (precision != null) {
                    builder = builder.precision(precision);
                }
                if (scale != null) {
                    builder = builder.numericScale(scale);
                }
                Column column = builder.build();
                if (!details.getAtlanTags().isEmpty()) {
                    toClassify.put(column.getQualifiedName(), details.getAtlanTags());
                }
                ++localCount;
                if (batch.add((Asset)column) == null) continue;
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
            if (batch.flush() != null) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert columns.", (Throwable)e);
        }
        ColumnDetails.appendAtlanTags(toClassify, "Column");
        return parents;
    }

    protected ColumnDetails(ColumnDetailsBuilder<?, ?> b) {
        super(b);
        this.index = b.index;
        this.name = b.name;
        this.parentType = b.parentType;
        this.parentQualifiedName = b.parentQualifiedName;
        this.rawType = b.rawType;
        this.mappedType = b.mappedType;
        this.primaryKey = b.primaryKey;
        this.foreignKey = b.foreignKey;
    }

    public static ColumnDetailsBuilder<?, ?> builder() {
        return new ColumnDetailsBuilderImpl();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getParentType() {
        return this.parentType;
    }

    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    public String getRawType() {
        return this.rawType;
    }

    public String getMappedType() {
        return this.mappedType;
    }

    public Boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDetails)) {
            return false;
        }
        ColumnDetails other = (ColumnDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        Boolean this$primaryKey = this.getPrimaryKey();
        Boolean other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        Boolean this$foreignKey = this.getForeignKey();
        Boolean other$foreignKey = other.getForeignKey();
        if (this$foreignKey == null ? other$foreignKey != null : !((Object)this$foreignKey).equals(other$foreignKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$parentType = this.getParentType();
        String other$parentType = other.getParentType();
        if (this$parentType == null ? other$parentType != null : !this$parentType.equals(other$parentType)) {
            return false;
        }
        String this$parentQualifiedName = this.getParentQualifiedName();
        String other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) {
            return false;
        }
        String this$rawType = this.getRawType();
        String other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        String this$mappedType = this.getMappedType();
        String other$mappedType = other.getMappedType();
        return !(this$mappedType == null ? other$mappedType != null : !this$mappedType.equals(other$mappedType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ColumnDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        Boolean $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        Boolean $foreignKey = this.getForeignKey();
        result = result * 59 + ($foreignKey == null ? 43 : ((Object)$foreignKey).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $parentType = this.getParentType();
        result = result * 59 + ($parentType == null ? 43 : $parentType.hashCode());
        String $parentQualifiedName = this.getParentQualifiedName();
        result = result * 59 + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        String $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        String $mappedType = this.getMappedType();
        result = result * 59 + ($mappedType == null ? 43 : $mappedType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ColumnDetails(super=" + super.toString() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", parentType=" + this.getParentType() + ", parentQualifiedName=" + this.getParentQualifiedName() + ", rawType=" + this.getRawType() + ", mappedType=" + this.getMappedType() + ", primaryKey=" + this.getPrimaryKey() + ", foreignKey=" + this.getForeignKey() + ")";
    }

    private static final class ColumnDetailsBuilderImpl
    extends ColumnDetailsBuilder<ColumnDetails, ColumnDetailsBuilderImpl> {
        private ColumnDetailsBuilderImpl() {
        }

        @Override
        protected ColumnDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ColumnDetails build() {
            return new ColumnDetails(this);
        }
    }

    public static abstract class ColumnDetailsBuilder<C extends ColumnDetails, B extends ColumnDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private int index;
        private String name;
        private String parentType;
        private String parentQualifiedName;
        private String rawType;
        private String mappedType;
        private Boolean primaryKey;
        private Boolean foreignKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B index(int index) {
            this.index = index;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B parentType(String parentType) {
            this.parentType = parentType;
            return (B)this.self();
        }

        public B parentQualifiedName(String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return (B)this.self();
        }

        public B rawType(String rawType) {
            this.rawType = rawType;
            return (B)this.self();
        }

        public B mappedType(String mappedType) {
            this.mappedType = mappedType;
            return (B)this.self();
        }

        public B primaryKey(Boolean primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B foreignKey(Boolean foreignKey) {
            this.foreignKey = foreignKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ColumnDetails.ColumnDetailsBuilder(super=" + super.toString() + ", index=" + this.index + ", name=" + this.name + ", parentType=" + this.parentType + ", parentQualifiedName=" + this.parentQualifiedName + ", rawType=" + this.rawType + ", mappedType=" + this.mappedType + ", primaryKey=" + this.primaryKey + ", foreignKey=" + this.foreignKey + ")";
        }
    }
}

