/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataTypeMapper {
    private static final Set<String> spuriousValues = Set.of("DATA TYPE", "DATA_TYPE", "HIERARCHYID", "NULL");
    private static final Map<String, String> typeMap = Map.ofEntries(Map.entry("NVARCHAR", "VARCHAR"));

    public static String getMappedType(String type) {
        if (spuriousValues.contains(type)) {
            return null;
        }
        return typeMap.getOrDefault(type, type);
    }

    public static String getTypeOnly(String sqlType) {
        if (sqlType != null) {
            if (sqlType.contains("(")) {
                return sqlType.substring(0, sqlType.indexOf("(")).trim().toUpperCase(Locale.ROOT);
            }
            return sqlType.toUpperCase(Locale.ROOT);
        }
        return null;
    }

    public static Long getMaxLength(String sqlType) {
        String length;
        if (sqlType != null && sqlType.contains("(") && !sqlType.contains(",") && !(length = sqlType.substring(sqlType.indexOf("(") + 1, sqlType.indexOf(")")).trim()).equals("MAX")) {
            return Long.parseLong(length);
        }
        return null;
    }

    public static Integer getPrecision(String sqlType) {
        if (sqlType != null && sqlType.contains("(") && sqlType.contains(",")) {
            String precision = sqlType.substring(sqlType.indexOf("(") + 1, sqlType.indexOf(",")).trim();
            return Integer.parseInt(precision);
        }
        return null;
    }

    public static Double getScale(String sqlType) {
        if (sqlType != null && sqlType.contains("(") && sqlType.contains(",")) {
            String scale = sqlType.substring(sqlType.indexOf(",") + 1, sqlType.indexOf(")")).trim();
            return Double.parseDouble(scale);
        }
        return null;
    }
}

