/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.samples.loaders.models.AssetDetails;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrichmentDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(EnrichmentDetails.class);
    private static final String CM_DELIMITER = "|";
    public static final String COL_USER_DESCRIPTION = "USER DESCRIPTION";
    public static final String COL_README = "README";
    private String userDescription;
    private String readme;
    private Map<String, CustomMetadataAttributes> customMetadataValues;

    protected static Map<String, CustomMetadataAttributes> getCustomMetadataValuesFromRow(Map<String, String> row, String delimiter) {
        HashMap<String, CustomMetadataAttributes> cmMap = new HashMap<String, CustomMetadataAttributes>();
        try {
            Map customAttrDefs = Atlan.getDefaultClient().getCustomMetadataCache().getAllCustomAttributes();
            for (String colName : row.keySet()) {
                List<String> toSet;
                String typeName;
                String value;
                if (colName == null || !colName.contains(CM_DELIMITER)) continue;
                String[] tokens = colName.split(Pattern.quote(CM_DELIMITER));
                String cmName = tokens[0];
                String cmAttrName = tokens[1];
                List attrDefs = customAttrDefs.getOrDefault(cmName, Collections.emptyList());
                AttributeDef attrDef = null;
                for (AttributeDef candidate : attrDefs) {
                    if (!candidate.getDisplayName().equals(cmAttrName)) continue;
                    attrDef = candidate;
                    break;
                }
                if (attrDef == null || (value = row.get(colName)) == null || value.isEmpty()) continue;
                if (!cmMap.containsKey(cmName)) {
                    cmMap.put(cmName, CustomMetadataAttributes.builder().build());
                }
                switch (typeName = attrDef.getTypeName()) {
                    case "boolean": {
                        toSet = EnrichmentDetails.getBoolean(value);
                        break;
                    }
                    default: {
                        toSet = value;
                    }
                }
                if (attrDef.getOptions().getMultiValueSelect().booleanValue()) {
                    toSet = Arrays.asList(value.split(Pattern.quote(delimiter)));
                }
                CustomMetadataAttributes cma = ((CustomMetadataAttributes)cmMap.get(cmName)).toBuilder().attribute(cmAttrName, toSet).build();
                cmMap.put(cmName, cma);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to retrieve custom metadata attribute definitions.", (Throwable)e);
        }
        return cmMap;
    }

    protected EnrichmentDetails(EnrichmentDetailsBuilder<?, ?> b) {
        super(b);
        this.userDescription = b.userDescription;
        this.readme = b.readme;
        this.customMetadataValues = b.customMetadataValues;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public String getReadme() {
        return this.readme;
    }

    public Map<String, CustomMetadataAttributes> getCustomMetadataValues() {
        return this.customMetadataValues;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnrichmentDetails)) {
            return false;
        }
        EnrichmentDetails other = (EnrichmentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userDescription = this.getUserDescription();
        String other$userDescription = other.getUserDescription();
        if (this$userDescription == null ? other$userDescription != null : !this$userDescription.equals(other$userDescription)) {
            return false;
        }
        String this$readme = this.getReadme();
        String other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !this$readme.equals(other$readme)) {
            return false;
        }
        Map<String, CustomMetadataAttributes> this$customMetadataValues = this.getCustomMetadataValues();
        Map<String, CustomMetadataAttributes> other$customMetadataValues = other.getCustomMetadataValues();
        return !(this$customMetadataValues == null ? other$customMetadataValues != null : !((Object)this$customMetadataValues).equals(other$customMetadataValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnrichmentDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userDescription = this.getUserDescription();
        result = result * 59 + ($userDescription == null ? 43 : $userDescription.hashCode());
        String $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : $readme.hashCode());
        Map<String, CustomMetadataAttributes> $customMetadataValues = this.getCustomMetadataValues();
        result = result * 59 + ($customMetadataValues == null ? 43 : ((Object)$customMetadataValues).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EnrichmentDetails(super=" + super.toString() + ", userDescription=" + this.getUserDescription() + ", readme=" + this.getReadme() + ", customMetadataValues=" + this.getCustomMetadataValues() + ")";
    }

    public static abstract class EnrichmentDetailsBuilder<C extends EnrichmentDetails, B extends EnrichmentDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String userDescription;
        private String readme;
        private Map<String, CustomMetadataAttributes> customMetadataValues;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B userDescription(String userDescription) {
            this.userDescription = userDescription;
            return (B)this.self();
        }

        public B readme(String readme) {
            this.readme = readme;
            return (B)this.self();
        }

        public B customMetadataValues(Map<String, CustomMetadataAttributes> customMetadataValues) {
            this.customMetadataValues = customMetadataValues;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EnrichmentDetails.EnrichmentDetailsBuilder(super=" + super.toString() + ", userDescription=" + this.userDescription + ", readme=" + this.readme + ", customMetadataValues=" + this.customMetadataValues + ")";
        }
    }
}

