/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(LineageDetails.class);
    public static final String COL_S_CONNECTOR = "CONNECTOR (S)";
    public static final String COL_S_CONNECTION = "CONNECTION (S)";
    public static final String COL_S_ASSET_TYPE = "SOURCE ASSET TYPE";
    public static final String COL_S_ASSET = "SOURCE ASSET";
    public static final String COL_ORCHESTRATOR = "ORCHESTRATOR";
    public static final String COL_PROCESS_ID = "PROCESS ID";
    public static final String COL_PROCESS_TYPE = "PROCESS TYPE";
    public static final String COL_T_ASSET = "TARGET ASSET";
    public static final String COL_T_ASSET_TYPE = "TARGET ASSET TYPE";
    public static final String COL_T_CONNECTOR = "CONNECTOR (T)";
    public static final String COL_T_CONNECTION = "CONNECTION (T)";
    public static final String COL_SQL_CODE = "SQL / CODE";
    public static final String COL_PROCESS_URL = "PROCESS URL";
    private static final Pattern CONNECTION_QN_PREFIX = Pattern.compile("default/[a-z0-9]+/[0-9]{10}/.*");
    private static final List<String> REQUIRED = List.of("SOURCE ASSET TYPE", "SOURCE ASSET", "ORCHESTRATOR", "PROCESS TYPE", "PROCESS ID", "TARGET ASSET", "TARGET ASSET TYPE");
    private AssetHeader sourceAsset;
    private String processConnectionQualifiedName;
    private String processId;
    private AssetHeader targetAsset;
    private String sqlCode;
    private String processUrl;

    @Override
    public String getIdentity() {
        return this.processConnectionQualifiedName + "/" + this.processId;
    }

    public static ConnectionDetails getOrchestratorFromRow(Map<String, String> row) {
        String processType;
        AtlanConnectorType connectorType;
        if (LineageDetails.getMissingFields(row, List.of(COL_ORCHESTRATOR, COL_PROCESS_TYPE)).isEmpty() && (connectorType = AtlanConnectorType.fromValue((String)(processType = row.get(COL_PROCESS_TYPE)))) != null) {
            return ConnectionDetails.getHeader(row.get(COL_ORCHESTRATOR), connectorType);
        }
        return null;
    }

    public static ConnectionDetails getSourceConnectionFromRow(Map<String, String> row) {
        if (LineageDetails.getMissingFields(row, List.of(COL_S_CONNECTOR, COL_S_CONNECTION)).isEmpty()) {
            return ConnectionDetails.getHeader(row.get(COL_S_CONNECTION), AtlanConnectorType.fromValue((String)row.get(COL_S_CONNECTOR).toLowerCase(Locale.ROOT)));
        }
        return null;
    }

    public static ConnectionDetails getTargetConnectionFromRow(Map<String, String> row) {
        if (LineageDetails.getMissingFields(row, List.of(COL_T_CONNECTOR, COL_T_CONNECTION)).isEmpty()) {
            return ConnectionDetails.getHeader(row.get(COL_T_CONNECTION), AtlanConnectorType.fromValue((String)row.get(COL_T_CONNECTOR).toLowerCase(Locale.ROOT)));
        }
        return null;
    }

    static String getProcessConnectionQN(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        ConnectionDetails connection = LineageDetails.getOrchestratorFromRow(row);
        return connectionCache.getOrDefault(connection, null);
    }

    public static LineageDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        LineageDetailsBuilder<?, ?> builder = LineageDetails.getFromRow(LineageDetails.builder(), row, delim);
        if (LineageDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String targetConnectionQN;
            String sourceConnectionQN;
            String sourceAsset = row.get(COL_S_ASSET);
            String sourceType = row.get(COL_S_ASSET_TYPE);
            String targetAsset = row.get(COL_T_ASSET);
            String targetType = row.get(COL_T_ASSET_TYPE);
            Object sourceAssetQN = null;
            Object targetAssetQN = null;
            if (CONNECTION_QN_PREFIX.matcher(sourceAsset).matches()) {
                sourceAssetQN = sourceAsset;
            }
            if (CONNECTION_QN_PREFIX.matcher(targetAsset).matches()) {
                targetAssetQN = targetAsset;
            }
            if (sourceAssetQN == null && (sourceConnectionQN = ConnectionDetails.getQualifiedName(connectionCache, row, COL_S_CONNECTOR, COL_S_CONNECTION)) != null) {
                sourceAssetQN = sourceConnectionQN + "/" + sourceAsset;
            }
            if (targetAssetQN == null && (targetConnectionQN = ConnectionDetails.getQualifiedName(connectionCache, row, COL_T_CONNECTOR, COL_T_CONNECTION)) != null) {
                targetAssetQN = targetConnectionQN + "/" + targetAsset;
            }
            String processId = row.get(COL_PROCESS_ID);
            String processConnectionQN = LineageDetails.getProcessConnectionQN(connectionCache, row);
            AssetHeader source = AssetHeader.of(sourceType, (String)sourceAssetQN);
            AssetHeader target = AssetHeader.of(targetType, (String)targetAssetQN);
            if (source != null && target != null && processConnectionQN != null) {
                return ((LineageDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((LineageDetailsBuilder)((LineageDetailsBuilder)((LineageDetailsBuilder)((LineageDetailsBuilder)((LineageDetailsBuilder)builder.sourceAsset(source)).targetAsset(target)).processConnectionQualifiedName(processConnectionQN)).processId(processId)).sqlCode(row.get(COL_SQL_CODE))).processUrl(row.get(COL_PROCESS_URL))).stub(false)).build();
            }
        }
        return null;
    }

    public static void upsert(Map<String, Set<LineageDetails>> processes, int batchSize) {
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "Process", batchSize);
        HashMap<String, List<String>> toTag = new HashMap<String, List<String>>();
        long totalResults = processes.size();
        long localCount = 0L;
        try {
            for (Map.Entry<String, Set<LineageDetails>> entry : processes.entrySet()) {
                Set<LineageDetails> assets = entry.getValue();
                HashSet<ICatalog> inputs = new HashSet<ICatalog>();
                HashSet<ICatalog> outputs = new HashSet<ICatalog>();
                HashSet<String> atlanTagNames = new HashSet<String>();
                String description = null;
                CertificateStatus certificate = null;
                String certificateMessage = null;
                AtlanAnnouncementType announcementType = null;
                String announcementTitle = null;
                String announcementMessage = null;
                HashSet<String> ownerUsers = new HashSet<String>();
                HashSet<String> ownerGroups = new HashSet<String>();
                String sqlCode = null;
                String processUrl = null;
                String processId = null;
                String processConnectionQN = null;
                for (LineageDetails details : assets) {
                    processId = details.getProcessId();
                    processConnectionQN = details.getProcessConnectionQualifiedName();
                    AssetHeader source = details.getSourceAsset();
                    AssetHeader target = details.getTargetAsset();
                    ICatalog input = ICatalog.getLineageReference((String)source.getTypeName(), (String)source.getQualifiedName());
                    ICatalog output = ICatalog.getLineageReference((String)target.getTypeName(), (String)target.getQualifiedName());
                    inputs.add(input);
                    outputs.add(output);
                    if (details.getDescription() != null && !details.getDescription().isEmpty()) {
                        description = details.getDescription();
                    }
                    if (details.getCertificate() != null) {
                        certificate = details.getCertificate();
                    }
                    if (details.getCertificateStatusMessage() != null && !details.getCertificateStatusMessage().isEmpty()) {
                        certificateMessage = details.getCertificateStatusMessage();
                    }
                    if (details.getAnnouncementType() != null) {
                        announcementType = details.getAnnouncementType();
                    }
                    if (details.getAnnouncementTitle() != null && !details.getAnnouncementTitle().isEmpty()) {
                        announcementTitle = details.getAnnouncementTitle();
                    }
                    if (details.getAnnouncementMessage() != null && !details.getAnnouncementMessage().isEmpty()) {
                        announcementMessage = details.getAnnouncementMessage();
                    }
                    if (details.getOwnerUsers() != null) {
                        ownerUsers.addAll(details.getOwnerUsers());
                    }
                    if (details.getOwnerGroups() != null) {
                        ownerGroups.addAll(details.getOwnerGroups());
                    }
                    if (details.getSqlCode() != null && !details.getSqlCode().isEmpty()) {
                        sqlCode = details.getSqlCode();
                    }
                    if (details.getProcessUrl() != null && !details.getProcessUrl().isEmpty()) {
                        processUrl = details.getProcessUrl();
                    }
                    if (details.getAtlanTags() == null) continue;
                    atlanTagNames.addAll(details.getAtlanTags());
                }
                if (processConnectionQN == null) continue;
                LineageProcess.LineageProcessBuilder builder = (LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)((LineageProcess.LineageProcessBuilder)LineageProcess.creator((String)processId, (String)processConnectionQN, (String)processId, new ArrayList(inputs), new ArrayList(outputs), null).description(description)).certificateStatus(certificate)).certificateStatusMessage(certificateMessage)).announcementType(announcementType)).announcementTitle(announcementTitle)).announcementMessage(announcementMessage)).ownerUsers(ownerUsers)).ownerGroups(ownerGroups)).sql(sqlCode).code(sqlCode).sourceURL(processUrl);
                LineageProcess process = builder.build();
                if (!atlanTagNames.isEmpty()) {
                    toTag.put(process.getQualifiedName(), new ArrayList(atlanTagNames));
                }
                ++localCount;
                if (batch.add((Asset)process) == null) continue;
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
            if (batch.flush() != null) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert lineage processes.", (Throwable)e);
        }
        LineageDetails.appendAtlanTags(toTag, "Process");
    }

    protected LineageDetails(LineageDetailsBuilder<?, ?> b) {
        super(b);
        this.sourceAsset = b.sourceAsset;
        this.processConnectionQualifiedName = b.processConnectionQualifiedName;
        this.processId = b.processId;
        this.targetAsset = b.targetAsset;
        this.sqlCode = b.sqlCode;
        this.processUrl = b.processUrl;
    }

    public static LineageDetailsBuilder<?, ?> builder() {
        return new LineageDetailsBuilderImpl();
    }

    public AssetHeader getSourceAsset() {
        return this.sourceAsset;
    }

    public String getProcessConnectionQualifiedName() {
        return this.processConnectionQualifiedName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public AssetHeader getTargetAsset() {
        return this.targetAsset;
    }

    public String getSqlCode() {
        return this.sqlCode;
    }

    public String getProcessUrl() {
        return this.processUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageDetails)) {
            return false;
        }
        LineageDetails other = (LineageDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetHeader this$sourceAsset = this.getSourceAsset();
        AssetHeader other$sourceAsset = other.getSourceAsset();
        if (this$sourceAsset == null ? other$sourceAsset != null : !((Object)this$sourceAsset).equals(other$sourceAsset)) {
            return false;
        }
        String this$processConnectionQualifiedName = this.getProcessConnectionQualifiedName();
        String other$processConnectionQualifiedName = other.getProcessConnectionQualifiedName();
        if (this$processConnectionQualifiedName == null ? other$processConnectionQualifiedName != null : !this$processConnectionQualifiedName.equals(other$processConnectionQualifiedName)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) {
            return false;
        }
        AssetHeader this$targetAsset = this.getTargetAsset();
        AssetHeader other$targetAsset = other.getTargetAsset();
        if (this$targetAsset == null ? other$targetAsset != null : !((Object)this$targetAsset).equals(other$targetAsset)) {
            return false;
        }
        String this$sqlCode = this.getSqlCode();
        String other$sqlCode = other.getSqlCode();
        if (this$sqlCode == null ? other$sqlCode != null : !this$sqlCode.equals(other$sqlCode)) {
            return false;
        }
        String this$processUrl = this.getProcessUrl();
        String other$processUrl = other.getProcessUrl();
        return !(this$processUrl == null ? other$processUrl != null : !this$processUrl.equals(other$processUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LineageDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetHeader $sourceAsset = this.getSourceAsset();
        result = result * 59 + ($sourceAsset == null ? 43 : ((Object)$sourceAsset).hashCode());
        String $processConnectionQualifiedName = this.getProcessConnectionQualifiedName();
        result = result * 59 + ($processConnectionQualifiedName == null ? 43 : $processConnectionQualifiedName.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        AssetHeader $targetAsset = this.getTargetAsset();
        result = result * 59 + ($targetAsset == null ? 43 : ((Object)$targetAsset).hashCode());
        String $sqlCode = this.getSqlCode();
        result = result * 59 + ($sqlCode == null ? 43 : $sqlCode.hashCode());
        String $processUrl = this.getProcessUrl();
        result = result * 59 + ($processUrl == null ? 43 : $processUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LineageDetails(super=" + super.toString() + ", sourceAsset=" + this.getSourceAsset() + ", processConnectionQualifiedName=" + this.getProcessConnectionQualifiedName() + ", processId=" + this.getProcessId() + ", targetAsset=" + this.getTargetAsset() + ", sqlCode=" + this.getSqlCode() + ", processUrl=" + this.getProcessUrl() + ")";
    }

    private static final class LineageDetailsBuilderImpl
    extends LineageDetailsBuilder<LineageDetails, LineageDetailsBuilderImpl> {
        private LineageDetailsBuilderImpl() {
        }

        @Override
        protected LineageDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public LineageDetails build() {
            return new LineageDetails(this);
        }
    }

    public static abstract class LineageDetailsBuilder<C extends LineageDetails, B extends LineageDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private AssetHeader sourceAsset;
        private String processConnectionQualifiedName;
        private String processId;
        private AssetHeader targetAsset;
        private String sqlCode;
        private String processUrl;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sourceAsset(AssetHeader sourceAsset) {
            this.sourceAsset = sourceAsset;
            return (B)this.self();
        }

        public B processConnectionQualifiedName(String processConnectionQualifiedName) {
            this.processConnectionQualifiedName = processConnectionQualifiedName;
            return (B)this.self();
        }

        public B processId(String processId) {
            this.processId = processId;
            return (B)this.self();
        }

        public B targetAsset(AssetHeader targetAsset) {
            this.targetAsset = targetAsset;
            return (B)this.self();
        }

        public B sqlCode(String sqlCode) {
            this.sqlCode = sqlCode;
            return (B)this.self();
        }

        public B processUrl(String processUrl) {
            this.processUrl = processUrl;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "LineageDetails.LineageDetailsBuilder(super=" + super.toString() + ", sourceAsset=" + this.sourceAsset + ", processConnectionQualifiedName=" + this.processConnectionQualifiedName + ", processId=" + this.processId + ", targetAsset=" + this.targetAsset + ", sqlCode=" + this.sqlCode + ", processUrl=" + this.processUrl + ")";
        }
    }

    public static class AssetHeader {
        private String typeName;
        private String qualifiedName;

        public static AssetHeader of(String typeName, String qualifiedName) {
            if (typeName != null && !typeName.isEmpty() && qualifiedName != null && !qualifiedName.isEmpty()) {
                return AssetHeader.builder().typeName(typeName).qualifiedName(qualifiedName).build();
            }
            return null;
        }

        AssetHeader(String typeName, String qualifiedName) {
            this.typeName = typeName;
            this.qualifiedName = qualifiedName;
        }

        public static AssetHeaderBuilder builder() {
            return new AssetHeaderBuilder();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetHeader)) {
                return false;
            }
            AssetHeader other = (AssetHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssetHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        public static class AssetHeaderBuilder {
            private String typeName;
            private String qualifiedName;

            AssetHeaderBuilder() {
            }

            public AssetHeaderBuilder typeName(String typeName) {
                this.typeName = typeName;
                return this;
            }

            public AssetHeaderBuilder qualifiedName(String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return this;
            }

            public AssetHeader build() {
                return new AssetHeader(this.typeName, this.qualifiedName);
            }

            public String toString() {
                return "LineageDetails.AssetHeader.AssetHeaderBuilder(typeName=" + this.typeName + ", qualifiedName=" + this.qualifiedName + ")";
            }
        }
    }
}

