/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.readers;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.samples.readers.AssetGenerator;
import com.atlan.util.AssetBatch;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CSVReader.class);
    private final CsvReader reader;
    private final List<String> header;
    private final long totalRowCount;
    private final int typeIdx;
    private final int qualifiedNameIdx;

    public CSVReader(String path) throws IOException {
        this(path, ',');
    }

    public CSVReader(String path, char fieldSeparator) throws IOException {
        Path inputFile = Paths.get(path, new String[0]);
        CsvReader.CsvReaderBuilder builder = CsvReader.builder().fieldSeparator(fieldSeparator).quoteCharacter('\"').skipEmptyRows(true).errorOnDifferentFieldCount(true);
        try (CsvReader tmp = builder.build(inputFile);){
            this.totalRowCount = ((Stream)tmp.stream().parallel()).count() - 1L;
        }
        tmp = builder.build(inputFile);
        try {
            Optional<CsvRow> one = tmp.stream().findFirst();
            this.header = one.map(CsvRow::getFields).orElse(Collections.emptyList());
        }
        finally {
            if (tmp != null) {
                tmp.close();
            }
        }
        this.typeIdx = this.header.indexOf("typeName");
        this.qualifiedNameIdx = this.header.indexOf("qualifiedName");
        if (this.typeIdx < 0 || this.qualifiedNameIdx < 0) {
            throw new IOException("Unable to find either (or both) the columns 'typeName' and / or 'qualifiedName'. These are both mandatory columns in the input CSV.");
        }
        this.reader = builder.build(inputFile);
    }

    public void streamRows(AssetGenerator assetForRow, int batchSize) {
        ConcurrentHashMap batchMap = new ConcurrentHashMap();
        log.info("Loading a total of {} assets...", (Object)this.totalRowCount);
        AtomicLong count = new AtomicLong(0L);
        ((Stream)this.reader.stream().skip(1L).parallel()).forEach(r -> {
            long id = Thread.currentThread().getId();
            if (!batchMap.containsKey(id)) {
                batchMap.put(id, new AssetBatch(Atlan.getDefaultClient(), "asset", batchSize, true, AssetBatch.CustomMetadataHandling.MERGE, true));
            }
            AssetBatch localBatch = (AssetBatch)batchMap.get(id);
            long localCount = count.getAndIncrement();
            if (localCount % (long)batchSize == 0L) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, this.totalRowCount, Math.round((double)localCount / (double)this.totalRowCount * 100.0)});
            }
            try {
                localBatch.add(assetForRow.buildFromRow(r.getFields(), this.header, this.typeIdx, this.qualifiedNameIdx));
            }
            catch (AtlanException e) {
                log.error("Unable to load batch.", (Throwable)e);
            }
        });
        AtomicLong totalCreates = new AtomicLong(0L);
        AtomicLong totalUpdates = new AtomicLong(0L);
        AtomicLong totalFailures = new AtomicLong(0L);
        batchMap.values().parallelStream().forEach(b -> {
            try {
                b.flush();
                totalCreates.getAndAdd(b.getCreated().size());
                totalUpdates.getAndAdd(b.getUpdated().size());
                if (!b.getFailures().isEmpty()) {
                    for (AssetBatch.FailedBatch f : b.getFailures()) {
                        log.info("Failed batch reason:", (Throwable)f.getFailureReason());
                        totalFailures.getAndAdd(f.getFailedAssets().size());
                        for (Asset failed : f.getFailedAssets()) {
                            log.info(" ... included asset: {}::{}", (Object)failed.getTypeName(), (Object)failed.getQualifiedName());
                        }
                    }
                }
            }
            catch (AtlanException e) {
                log.error("Unable to flush final batch.", (Throwable)e);
            }
        });
        log.info("Total assets created: {}", (Object)totalCreates);
        log.info("Total assets updated: {}", (Object)totalUpdates);
        log.info("Total assets failed : {}", (Object)totalFailures);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

