/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import com.atlan.Atlan;
import com.atlan.cache.ReflectionCache;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IReadme;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.fields.CustomMetadataField;
import com.atlan.model.structs.AtlanStruct;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporter.class);
    public static final double BYTES_IN_GB = 1.073741824E9;
    public static final String TIMESTAMP_FORMAT = "uuuuMMdd-HHmmss-SSS";
    private int _batchSize = 50;
    private String _delimiter = "|";
    private Region _region = null;
    private String _bucket = null;
    private String _filename = null;

    protected void parseParametersFromEvent(Map<String, String> event) {
        if (event != null) {
            log.debug(" ... event: {}", event);
            String batchSize = event.getOrDefault("BATCH_SIZE", "50");
            try {
                this._batchSize = Integer.parseInt(batchSize);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the BATCH_SIZE value of '{}', falling back to a default of 50.", (Object)batchSize);
                this._batchSize = 50;
            }
            this._delimiter = event.getOrDefault("DELIMITER", "|");
            String region = event.getOrDefault("REGION", "ap-south-1");
            this._region = Region.of((String)region);
            this._bucket = event.getOrDefault("BUCKET", null);
            Atlan.setBaseUrl((String)event.getOrDefault("ATLAN_BASE_URL", null));
            Atlan.setApiToken((String)event.getOrDefault("ATLAN_API_KEY", null));
            String maxRetries = event.getOrDefault("MAX_RETRIES", "20");
            int _maxRetries = 20;
            try {
                _maxRetries = Integer.parseInt(maxRetries);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the MAX_RETRIES value of '{}', falling back to a default of 20.", (Object)maxRetries);
            }
            Atlan.setMaxNetworkRetries((int)_maxRetries);
        }
    }

    protected void setFilenameWithPrefix(Map<String, String> event, String prefix) {
        this.setFilenameWithPrefix(event, prefix, "xlsx");
    }

    protected void setFilenameWithPrefix(Map<String, String> event, String prefix, String extension) {
        String timestamp = ZonedDateTime.now(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(TIMESTAMP_FORMAT));
        Object filename = event.getOrDefault("FILE_PREFIX", prefix);
        if (((String)filename).endsWith("." + extension)) {
            filename = ((String)filename).substring(0, ((String)filename).lastIndexOf("." + extension));
        }
        filename = (String)filename + "-" + timestamp + "." + extension;
        this.setFilename((String)filename);
    }

    protected static String getFormattedDateTime(Long ts) {
        if (ts != null && ts > 0L) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return "";
    }

    protected static String getAssetLink(String guid) {
        return Atlan.getBaseUrl() + "/assets/" + guid + "/overview";
    }

    protected static String getDescription(Asset asset) {
        String description = asset.getUserDescription();
        if (description == null || description.isEmpty()) {
            description = asset.getDescription();
        }
        return description == null ? "" : description;
    }

    protected String getUserOwners(Asset asset) {
        return this.getDelimitedList(asset.getOwnerUsers());
    }

    protected String getGroupOwners(Asset asset) {
        return this.getDelimitedList(asset.getOwnerGroups());
    }

    protected static int getCount(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    protected static String getValue(AtlanEnum e) {
        if (e == null) {
            return "";
        }
        return e.getValue();
    }

    protected static String protectFromNull(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    protected static String getREADME(Asset asset) {
        String content;
        IReadme readme = asset.getReadme();
        if (readme != null && (content = readme.getDescription()) != null && !content.isEmpty()) {
            return content;
        }
        return "";
    }

    protected String getAtlanTags(Asset asset) {
        SortedSet atlanTags = asset.getAtlanTags();
        if (atlanTags != null) {
            Set<String> atlanTagNames = atlanTags.stream().map(AtlanTag::getTypeName).collect(Collectors.toSet());
            return this.getDelimitedList(atlanTagNames);
        }
        return "";
    }

    protected String getDirectAtlanTags(Asset asset) {
        SortedSet atlanTags;
        TreeSet<String> atlanTagNames = new TreeSet<String>();
        if (asset != null && (atlanTags = asset.getAtlanTags()) != null) {
            for (AtlanTag classification : atlanTags) {
                String classifiedEntity = classification.getEntityGuid();
                if (!asset.getGuid().equals(classifiedEntity)) continue;
                atlanTagNames.add(classification.getTypeName());
            }
        }
        return this.getDelimitedList(atlanTagNames);
    }

    protected String getDelimitedList(Collection<String> items) {
        if (items == null) {
            return "";
        }
        return String.join((CharSequence)this.getDelimiter(), items);
    }

    protected String getStringValueForField(Asset from, AtlanField field) {
        try {
            Object value;
            if (field instanceof CustomMetadataField) {
                CustomMetadataField cmf = (CustomMetadataField)field;
                value = from.getCustomMetadata(cmf.getSetName(), cmf.getAttributeName());
            } else {
                String deserializedName = ReflectionCache.getDeserializedName(from.getClass(), (String)field.getAtlanFieldName());
                value = ReflectionCache.getValue((Asset)from, (String)deserializedName);
            }
            return this.serializeValueToCSV(from.getGuid(), value);
        }
        catch (IOException e) {
            log.error("Unable to retrieve attribute {} on: {}::{}", new Object[]{field.getAtlanFieldName(), from.getTypeName(), from.getQualifiedName(), e});
            return "";
        }
    }

    protected String serializeValueToCSV(String fromGuid, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Optional element1 = ((Collection)value).stream().findFirst();
            if (element1.isPresent()) {
                Object first = element1.get();
                if (first instanceof AtlanTag) {
                    Collection tags = (Collection)value;
                    ArrayList<String> directTags = new ArrayList<String>();
                    for (AtlanTag tag : tags) {
                        if (!fromGuid.equals(tag.getEntityGuid())) continue;
                        directTags.add(tag.getTypeName());
                    }
                    return this.getDelimitedList(directTags);
                }
                if (first instanceof Asset) {
                    return this.getDelimitedList(((Collection)value).stream().map(this::serializeAssetRefToCSV).collect(Collectors.toList()));
                }
                if (first instanceof String) {
                    return this.getDelimitedList((Collection)value);
                }
                if (first instanceof AtlanStruct) {
                    return this.getDelimitedList(((Collection)value).stream().map(this::serializeStructToCSV).collect(Collectors.toList()));
                }
                log.warn("Unhandled collection of values: {}", first.getClass());
            }
            return "";
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList<String> values = new ArrayList<String>();
            for (Map.Entry entry : map.entrySet()) {
                values.add(entry.getKey() + "=" + this.serializeValueToCSV(fromGuid, entry.getValue()));
            }
            return this.getDelimitedList(values);
        }
        if (value instanceof Asset) {
            return this.serializeAssetRefToCSV((Asset)value);
        }
        if (value instanceof AtlanEnum) {
            return ((AtlanEnum)value).getValue();
        }
        if (value instanceof AtlanStruct) {
            return this.serializeStructToCSV((AtlanStruct)value);
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected String serializeAssetRefToCSV(Asset asset) {
        String qualifiedName = asset.getQualifiedName();
        if ((qualifiedName == null || qualifiedName.isEmpty()) && asset.getUniqueAttributes() != null) {
            qualifiedName = asset.getUniqueAttributes().getQualifiedName();
        }
        return asset.getTypeName() + "@" + qualifiedName;
    }

    protected String serializeStructToCSV(AtlanStruct struct) {
        return struct.toString();
    }

    public void setFilename(String _filename) {
        this._filename = _filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getBucket() {
        return this._bucket;
    }

    public Region getRegion() {
        return this._region;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public String getDelimiter() {
        return this._delimiter;
    }
}

