/*
 * Decompiled with CFR 0.152.
 */
package com.probable.guacamole.instances;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Database;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.AssetBatch;
import com.probable.guacamole.ExtendedModelGenerator;
import com.probable.guacamole.model.assets.GuacamoleColumn;
import com.probable.guacamole.model.assets.GuacamoleTable;
import com.probable.guacamole.model.enums.GuacamoleTemperature;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager
extends ExtendedModelGenerator {
    private static final Logger log = LoggerFactory.getLogger(InstanceManager.class);
    private static Connection connection = null;

    public static void main(String[] args) {
        InstanceManager im = new InstanceManager();
        im.createConnection();
        im.createOOTBEntities();
        im.createCustomEntities();
        im.readEntities();
        im.updateEntities();
        im.searchEntities();
        im.purgeEntities();
    }

    void createConnection() {
        try {
            List results = Connection.findByName((String)"guacamole", (AtlanConnectorType)AtlanConnectorType.MONGODB);
            if (!results.isEmpty()) {
                connection = (Connection)results.get(0);
                log.info("Connection already exists, reusing it: {}", (Object)connection.getQualifiedName());
            }
        }
        catch (NotFoundException err) {
            try {
                Connection toCreate = Connection.creator((String)"guacamole", (AtlanConnectorType)AtlanConnectorType.MONGODB, List.of(Atlan.getDefaultClient().getRoleCache().getIdForName("$admin")), null, null).build();
                AssetMutationResponse response = toCreate.save().block();
                connection = (Connection)response.getCreatedAssets().get(0);
            }
            catch (AtlanException e) {
                log.error("Unable to create a new connection.", (Throwable)e);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to search for existing connection.", (Throwable)e);
        }
    }

    void createOOTBEntities() {
        Database db = Database.creator((String)"db", (String)connection.getQualifiedName()).build();
        try {
            AssetMutationResponse response = db.save();
            log.info("Created database entity: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create new database.", (Throwable)e);
        }
        Schema schema = Schema.creator((String)"schema", (String)(connection.getQualifiedName() + "/db")).build();
        try {
            AssetMutationResponse response = schema.save();
            log.info("Created schema entity: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create new schema.", (Throwable)e);
        }
    }

    void createCustomEntities() {
        Asset table = ((GuacamoleTable.GuacamoleTableBuilder)((Object)((GuacamoleTable.GuacamoleTableBuilder)((Object)((GuacamoleTable.GuacamoleTableBuilder)((Object)GuacamoleTable.creator("table", connection.getQualifiedName() + "/db/schema").guacamoleTemperature(GuacamoleTemperature.HOT))).guacamoleArchived(false))).guacamoleSize(123L))).build();
        try {
            AssetMutationResponse response = table.save();
            log.info("Created table entity: {}", (Object)response);
            table = (GuacamoleTable)response.getCreatedAssets().get(0);
        }
        catch (AtlanException e) {
            log.error("Failed to create new guacamole table.", (Throwable)e);
        }
        try {
            AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "GuacamoleColumn", 20);
            Asset child1 = ((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)GuacamoleColumn.creator("column1", table.getQualifiedName(), 1).guacamoleConceptualized(123456789L))).guacamoleWidth(100L))).build();
            batch.add(child1);
            Asset child2 = ((GuacamoleColumn.GuacamoleColumnBuilder)((Object)((GuacamoleColumn.GuacamoleColumnBuilder)((Object)GuacamoleColumn.creator("column2", table.getQualifiedName(), 2).guacamoleConceptualized(1234567890L))).guacamoleWidth(200L))).build();
            batch.add(child2);
            AssetMutationResponse response = batch.flush();
            log.info("Created child entities: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert Guacamole columns.", (Throwable)e);
        }
    }

    void readEntities() {
        String parentQN = connection.getQualifiedName() + "/db/schema/table";
        String child1QN = parentQN + "/column1";
        String child2QN = parentQN + "/column2";
        try {
            GuacamoleTable table = GuacamoleTable.get(parentQN);
            assert (table.getQualifiedName().equals(parentQN));
            assert (table.getGuacamoleColumns().size() == 2);
            String tableGuid = table.getGuid();
            GuacamoleColumn one = GuacamoleColumn.get(child1QN);
            assert (one.getQualifiedName().equals(child1QN));
            assert (one.getGuacamoleTable().getGuid().equals(tableGuid));
            GuacamoleColumn two = GuacamoleColumn.get(child2QN);
            assert (two.getQualifiedName().equals(child2QN));
            assert (two.getGuacamoleTable().getGuid().equals(tableGuid));
        }
        catch (AtlanException e) {
            log.error("Unable to read entities.", (Throwable)e);
        }
    }

    void updateEntities() {
        Asset toUpdate = ((GuacamoleTable.GuacamoleTableBuilder)((GuacamoleTable.GuacamoleTableBuilder)GuacamoleTable.updater(connection.getQualifiedName() + "/db/schema/table", "table").description("Now with a description!")).certificateStatus(CertificateStatus.DRAFT)).build();
        try {
            AssetMutationResponse response = toUpdate.save();
            log.info("Updated parent: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Unable to update entity.", (Throwable)e);
        }
    }

    void searchEntities() {
        IndexSearchResponse response;
        AtlanClient client = Atlan.getDefaultClient();
        IndexSearchRequest request = ((FluentSearch.FluentSearchBuilder)client.assets.select().where(FluentSearch.assetTypes(List.of("GuacamoleTable", "GuacamoleColumn")))).toRequest();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 3L);
            assert (response.getAssets().size() == 3);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        request = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)client.assets.select().where(FluentSearch.assetType((String)"GuacamoleColumn"))).where(Asset.NAME.eq("column1"))).toRequest();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        request = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)client.assets.select().where(FluentSearch.assetType((String)"GuacamoleColumn"))).where(GuacamoleColumn.GUACAMOLE_WIDTH.gt((Number)150L))).toRequest();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
        request = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)client.assets.select().where(FluentSearch.assetType((String)"GuacamoleTable"))).where(Asset.DESCRIPTION.startsWith("Now"))).toRequest();
        try {
            response = request.search();
            log.info("Found results: {}", (Object)response);
            assert (response.getApproximateCount() == 1L);
            assert (response.getAssets().size() == 1);
        }
        catch (AtlanException e) {
            log.error("Unable to search.", (Throwable)e);
        }
    }

    void purgeEntities() {
        String parentQN = connection.getQualifiedName() + "/db/schema/table";
        String child1QN = parentQN + "/column1";
        String child2QN = parentQN + "/column2";
        try {
            GuacamoleTable parent = GuacamoleTable.get(parentQN);
            GuacamoleColumn one = GuacamoleColumn.get(child1QN);
            GuacamoleColumn two = GuacamoleColumn.get(child2QN);
            Atlan.getDefaultClient().assets.delete(List.of(parent.getGuid(), one.getGuid(), two.getGuid()), AtlanDeleteType.PURGE);
            log.info("Entities purged.");
        }
        catch (AtlanException e) {
            log.error("Unable to purge entities.", (Throwable)e);
        }
    }
}

