/*
 * Decompiled with CFR 0.152.
 */
package com.probable.guacamole.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISchema;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.ITablePartition;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.probable.guacamole.model.assets.IGuacamoleColumn;
import com.probable.guacamole.model.assets.IGuacamoleTable;
import com.probable.guacamole.model.enums.GuacamoleTemperature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleTable
extends Asset
implements IGuacamoleTable,
ITable,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    private static final Logger log = LoggerFactory.getLogger(GuacamoleTable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GuacamoleTable";
    String typeName;
    @Attribute
    String alias;
    @Attribute
    Long columnCount;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    SortedSet<ITable> dimensions;
    @Attribute
    String externalLocation;
    @Attribute
    String externalLocationFormat;
    @Attribute
    String externalLocationRegion;
    @Attribute
    SortedSet<ITable> facts;
    @Attribute
    Boolean guacamoleArchived;
    @Attribute
    SortedSet<IGuacamoleColumn> guacamoleColumns;
    @Attribute
    Long guacamoleSize;
    @Attribute
    GuacamoleTemperature guacamoleTemperature;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isPartitioned;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Boolean isTemporary;
    @Attribute
    Long lastProfiledAt;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    Long partitionCount;
    @Attribute
    String partitionList;
    @Attribute
    String partitionStrategy;
    @Attribute
    SortedSet<ITablePartition> partitions;
    @Attribute
    SortedSet<IAtlanQuery> queries;
    @Attribute
    Long queryCount;
    @Attribute
    Long queryCountUpdatedAt;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    Long rowCount;
    @Attribute
    @JsonProperty(value="atlanSchema")
    ISchema schema;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    Long sizeBytes;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    public GuacamoleTable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return GuacamoleTable.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return GuacamoleTable.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return GuacamoleTable.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, new String[]{TYPE_NAME, "guid, qualifiedName"});
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return GuacamoleTable.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return GuacamoleTable.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return GuacamoleTable.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder((AtlanClient)client).where(CompoundQuery.assetType((String)TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return GuacamoleTable.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return GuacamoleTable.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return GuacamoleTable.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type((String)TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static GuacamoleTable refByGuid(String guid) {
        return ((GuacamoleTableBuilder)GuacamoleTable._internal().guid(guid)).build();
    }

    public static GuacamoleTable refByQualifiedName(String qualifiedName) {
        return ((GuacamoleTableBuilder)GuacamoleTable._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build())).build();
    }

    @JsonIgnore
    public static GuacamoleTable get(String id) throws AtlanException {
        return GuacamoleTable.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static GuacamoleTable get(AtlanClient client, String id) throws AtlanException {
        return GuacamoleTable.get(client, id, true);
    }

    @JsonIgnore
    public static GuacamoleTable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, new String[]{"(null)"});
        }
        if (StringUtils.isUUID((String)id)) {
            Asset asset = Asset.get((AtlanClient)client, (String)id, (boolean)includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, new String[]{id});
            }
            if (asset instanceof GuacamoleTable) {
                return (GuacamoleTable)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, new String[]{id, TYPE_NAME});
        }
        Asset asset = Asset.get((AtlanClient)client, (String)TYPE_NAME, (String)id, (boolean)includeRelationships);
        if (asset instanceof GuacamoleTable) {
            return (GuacamoleTable)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, new String[]{id, TYPE_NAME});
    }

    @Deprecated
    public static GuacamoleTable retrieveByGuid(String guid) throws AtlanException {
        return GuacamoleTable.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static GuacamoleTable retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return GuacamoleTable.get(client, guid);
    }

    @Deprecated
    public static GuacamoleTable retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return GuacamoleTable.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static GuacamoleTable retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return GuacamoleTable.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return GuacamoleTable.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName);
    }

    public static GuacamoleTableBuilder<?, ?> creator(String name, String schemaQualifiedName) {
        String[] tokens = schemaQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName((String[])tokens);
        String schemaName = StringUtils.getNameFromQualifiedName((String)schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName((String)schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName((String)databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName((String)databaseQualifiedName);
        return (GuacamoleTableBuilder)((GuacamoleTableBuilder)((Object)((GuacamoleTableBuilder)((Object)((GuacamoleTableBuilder)((Object)((GuacamoleTableBuilder)((Object)((GuacamoleTableBuilder)((GuacamoleTableBuilder)((GuacamoleTableBuilder)GuacamoleTable._internal().name(name)).qualifiedName(GuacamoleTable.generateQualifiedName(name, schemaQualifiedName))).connectorType(connectorType)).schemaName(schemaName))).schemaQualifiedName(schemaQualifiedName))).schema((ISchema)Schema.refByQualifiedName((String)schemaQualifiedName)))).databaseName(databaseName))).databaseQualifiedName(databaseQualifiedName).connectionQualifiedName(connectionQualifiedName);
    }

    public static GuacamoleTableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (GuacamoleTableBuilder)((GuacamoleTableBuilder)GuacamoleTable._internal().qualifiedName(qualifiedName)).name(name);
    }

    public static String generateQualifiedName(String name, String schemaQualifiedName) {
        return schemaQualifiedName + "/" + name;
    }

    public GuacamoleTableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, new String[]{TYPE_NAME, String.join((CharSequence)",", missing)});
        }
        return GuacamoleTable.updater(this.getQualifiedName(), this.getName());
    }

    public static GuacamoleTable removeDescription(String qualifiedName, String name) throws AtlanException {
        return GuacamoleTable.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GuacamoleTable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GuacamoleTable)Asset.removeDescription((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name));
    }

    public static GuacamoleTable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return GuacamoleTable.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GuacamoleTable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GuacamoleTable)Asset.removeUserDescription((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name));
    }

    public static GuacamoleTable removeOwners(String qualifiedName, String name) throws AtlanException {
        return GuacamoleTable.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GuacamoleTable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GuacamoleTable)Asset.removeOwners((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name));
    }

    public static GuacamoleTable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return GuacamoleTable.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static GuacamoleTable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (GuacamoleTable)Asset.updateCertificate((AtlanClient)client, GuacamoleTable._internal(), (String)TYPE_NAME, (String)qualifiedName, (CertificateStatus)certificate, (String)message);
    }

    public static GuacamoleTable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return GuacamoleTable.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GuacamoleTable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GuacamoleTable)Asset.removeCertificate((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name));
    }

    public static GuacamoleTable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return GuacamoleTable.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static GuacamoleTable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GuacamoleTable)Asset.updateAnnouncement((AtlanClient)client, GuacamoleTable._internal(), (String)TYPE_NAME, (String)qualifiedName, (AtlanAnnouncementType)type, (String)title, (String)message);
    }

    public static GuacamoleTable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return GuacamoleTable.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static GuacamoleTable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GuacamoleTable)Asset.removeAnnouncement((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name));
    }

    public static GuacamoleTable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return GuacamoleTable.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static GuacamoleTable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (GuacamoleTable)Asset.replaceTerms((AtlanClient)client, GuacamoleTable.updater(qualifiedName, name), terms);
    }

    public static GuacamoleTable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GuacamoleTable.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GuacamoleTable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GuacamoleTable)Asset.appendTerms((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, terms);
    }

    public static GuacamoleTable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return GuacamoleTable.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static GuacamoleTable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GuacamoleTable)Asset.removeTerms((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, terms);
    }

    public static GuacamoleTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return GuacamoleTable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static GuacamoleTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GuacamoleTable)Asset.appendAtlanTags((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, atlanTagNames);
    }

    public static GuacamoleTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return GuacamoleTable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static GuacamoleTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GuacamoleTable)Asset.appendAtlanTags((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, atlanTagNames, (boolean)propagate, (boolean)removePropagationsOnDelete, (boolean)restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        GuacamoleTable.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        GuacamoleTable.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, atlanTagNames, (boolean)propagate, (boolean)removePropagationsOnDelete, (boolean)restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        GuacamoleTable.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag((AtlanClient)client, (String)TYPE_NAME, (String)qualifiedName, (String)atlanTagName);
    }

    private static String $default$typeName() {
        return TYPE_NAME;
    }

    protected GuacamoleTable(GuacamoleTableBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> queryUserMap;
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : GuacamoleTable.$default$typeName();
        this.alias = b.alias;
        this.columnCount = b.columnCount;
        SortedSet<Object> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<Object> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<Object> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<Object> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        SortedSet<Object> dimensions = new TreeSet<ITable>();
        if (b.dimensions != null) {
            dimensions.addAll(b.dimensions);
        }
        dimensions = Collections.unmodifiableSortedSet(dimensions);
        this.dimensions = dimensions;
        this.externalLocation = b.externalLocation;
        this.externalLocationFormat = b.externalLocationFormat;
        this.externalLocationRegion = b.externalLocationRegion;
        SortedSet<Object> facts = new TreeSet<ITable>();
        if (b.facts != null) {
            facts.addAll(b.facts);
        }
        facts = Collections.unmodifiableSortedSet(facts);
        this.facts = facts;
        this.guacamoleArchived = b.guacamoleArchived;
        SortedSet<IGuacamoleColumn> guacamoleColumns = new TreeSet<IGuacamoleColumn>();
        if (b.guacamoleColumns != null) {
            guacamoleColumns.addAll(b.guacamoleColumns);
        }
        guacamoleColumns = Collections.unmodifiableSortedSet(guacamoleColumns);
        this.guacamoleColumns = guacamoleColumns;
        this.guacamoleSize = b.guacamoleSize;
        this.guacamoleTemperature = b.guacamoleTemperature;
        SortedSet<Object> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<Object> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isPartitioned = b.isPartitioned;
        this.isProfiled = b.isProfiled;
        this.isQueryPreview = b.isQueryPreview;
        this.isTemporary = b.isTemporary;
        this.lastProfiledAt = b.lastProfiledAt;
        SortedSet<Object> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<Object> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        this.partitionStrategy = b.partitionStrategy;
        SortedSet<Object> partitions = new TreeSet<ITablePartition>();
        if (b.partitions != null) {
            partitions.addAll(b.partitions);
        }
        partitions = Collections.unmodifiableSortedSet(partitions);
        this.partitions = partitions;
        SortedSet<Object> queries = new TreeSet<IAtlanQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.rowCount = b.rowCount;
        this.schema = b.schema;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.sizeBytes = b.sizeBytes;
        SortedSet<Object> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<Object> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    public static GuacamoleTableBuilder<?, ?> _internal() {
        return new GuacamoleTableBuilderImpl();
    }

    public GuacamoleTableBuilder<?, ?> toBuilder() {
        return new GuacamoleTableBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Override
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    public SortedSet<ITable> getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getExternalLocation() {
        return this.externalLocation;
    }

    @Override
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    @Override
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    @Override
    public SortedSet<ITable> getFacts() {
        return this.facts;
    }

    @Override
    public Boolean getGuacamoleArchived() {
        return this.guacamoleArchived;
    }

    @Override
    public SortedSet<IGuacamoleColumn> getGuacamoleColumns() {
        return this.guacamoleColumns;
    }

    @Override
    public Long getGuacamoleSize() {
        return this.guacamoleSize;
    }

    @Override
    public GuacamoleTemperature getGuacamoleTemperature() {
        return this.guacamoleTemperature;
    }

    @Override
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Override
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Override
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Override
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public String getPartitionList() {
        return this.partitionList;
    }

    @Override
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    @Override
    public SortedSet<ITablePartition> getPartitions() {
        return this.partitions;
    }

    @Override
    public SortedSet<IAtlanQuery> getQueries() {
        return this.queries;
    }

    @Override
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Override
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    public Long getRowCount() {
        return this.rowCount;
    }

    @Override
    public ISchema getSchema() {
        return this.schema;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuacamoleTable)) {
            return false;
        }
        GuacamoleTable other = (GuacamoleTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Boolean this$guacamoleArchived = this.getGuacamoleArchived();
        Boolean other$guacamoleArchived = other.getGuacamoleArchived();
        if (this$guacamoleArchived == null ? other$guacamoleArchived != null : !((Object)this$guacamoleArchived).equals(other$guacamoleArchived)) {
            return false;
        }
        Long this$guacamoleSize = this.getGuacamoleSize();
        Long other$guacamoleSize = other.getGuacamoleSize();
        if (this$guacamoleSize == null ? other$guacamoleSize != null : !((Object)this$guacamoleSize).equals(other$guacamoleSize)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$partitionCount = this.getPartitionCount();
        Long other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        SortedSet<ITable> this$dimensions = this.getDimensions();
        SortedSet<ITable> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        String this$externalLocation = this.getExternalLocation();
        String other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) {
            return false;
        }
        String this$externalLocationFormat = this.getExternalLocationFormat();
        String other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) {
            return false;
        }
        String this$externalLocationRegion = this.getExternalLocationRegion();
        String other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) {
            return false;
        }
        SortedSet<ITable> this$facts = this.getFacts();
        SortedSet<ITable> other$facts = other.getFacts();
        if (this$facts == null ? other$facts != null : !this$facts.equals(other$facts)) {
            return false;
        }
        SortedSet<IGuacamoleColumn> this$guacamoleColumns = this.getGuacamoleColumns();
        SortedSet<IGuacamoleColumn> other$guacamoleColumns = other.getGuacamoleColumns();
        if (this$guacamoleColumns == null ? other$guacamoleColumns != null : !this$guacamoleColumns.equals(other$guacamoleColumns)) {
            return false;
        }
        GuacamoleTemperature this$guacamoleTemperature = this.getGuacamoleTemperature();
        GuacamoleTemperature other$guacamoleTemperature = other.getGuacamoleTemperature();
        if (this$guacamoleTemperature == null ? other$guacamoleTemperature != null : !((Object)((Object)this$guacamoleTemperature)).equals((Object)other$guacamoleTemperature)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$partitionList = this.getPartitionList();
        String other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        SortedSet<ITablePartition> this$partitions = this.getPartitions();
        SortedSet<ITablePartition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !this$partitions.equals(other$partitions)) {
            return false;
        }
        SortedSet<IAtlanQuery> this$queries = this.getQueries();
        SortedSet<IAtlanQuery> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        ISchema this$schema = this.getSchema();
        ISchema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuacamoleTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Boolean $guacamoleArchived = this.getGuacamoleArchived();
        result = result * 59 + ($guacamoleArchived == null ? 43 : ((Object)$guacamoleArchived).hashCode());
        Long $guacamoleSize = this.getGuacamoleSize();
        result = result * 59 + ($guacamoleSize == null ? 43 : ((Object)$guacamoleSize).hashCode());
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        SortedSet<ITable> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        String $externalLocation = this.getExternalLocation();
        result = result * 59 + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        String $externalLocationFormat = this.getExternalLocationFormat();
        result = result * 59 + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        String $externalLocationRegion = this.getExternalLocationRegion();
        result = result * 59 + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        SortedSet<ITable> $facts = this.getFacts();
        result = result * 59 + ($facts == null ? 43 : $facts.hashCode());
        SortedSet<IGuacamoleColumn> $guacamoleColumns = this.getGuacamoleColumns();
        result = result * 59 + ($guacamoleColumns == null ? 43 : $guacamoleColumns.hashCode());
        GuacamoleTemperature $guacamoleTemperature = this.getGuacamoleTemperature();
        result = result * 59 + ($guacamoleTemperature == null ? 43 : ((Object)((Object)$guacamoleTemperature)).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : $partitionList.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        SortedSet<ITablePartition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : $partitions.hashCode());
        SortedSet<IAtlanQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        ISchema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    public String toString() {
        return "GuacamoleTable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", alias=" + this.getAlias() + ", columnCount=" + this.getColumnCount() + ", columns=" + this.getColumns() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", dimensions=" + this.getDimensions() + ", externalLocation=" + this.getExternalLocation() + ", externalLocationFormat=" + this.getExternalLocationFormat() + ", externalLocationRegion=" + this.getExternalLocationRegion() + ", facts=" + this.getFacts() + ", guacamoleArchived=" + this.getGuacamoleArchived() + ", guacamoleColumns=" + this.getGuacamoleColumns() + ", guacamoleSize=" + this.getGuacamoleSize() + ", guacamoleTemperature=" + this.getGuacamoleTemperature() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isPartitioned=" + this.getIsPartitioned() + ", isProfiled=" + this.getIsProfiled() + ", isQueryPreview=" + this.getIsQueryPreview() + ", isTemporary=" + this.getIsTemporary() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", partitionCount=" + this.getPartitionCount() + ", partitionList=" + this.getPartitionList() + ", partitionStrategy=" + this.getPartitionStrategy() + ", partitions=" + this.getPartitions() + ", queries=" + this.getQueries() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryPreviewConfig=" + this.getQueryPreviewConfig() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rowCount=" + this.getRowCount() + ", schema=" + this.getSchema() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sizeBytes=" + this.getSizeBytes() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private static final class GuacamoleTableBuilderImpl
    extends GuacamoleTableBuilder<GuacamoleTable, GuacamoleTableBuilderImpl> {
        private GuacamoleTableBuilderImpl() {
        }

        @Override
        protected GuacamoleTableBuilderImpl self() {
            return this;
        }

        @Override
        public GuacamoleTable build() {
            return new GuacamoleTable(this);
        }
    }

    public static abstract class GuacamoleTableBuilder<C extends GuacamoleTable, B extends GuacamoleTableBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        private boolean typeName$set;
        private String typeName$value;
        private String alias;
        private Long columnCount;
        private ArrayList<IColumn> columns;
        private String databaseName;
        private String databaseQualifiedName;
        private ArrayList<IDbtModel> dbtModels;
        private ArrayList<IDbtSource> dbtSources;
        private ArrayList<IDbtTest> dbtTests;
        private ArrayList<ITable> dimensions;
        private String externalLocation;
        private String externalLocationFormat;
        private String externalLocationRegion;
        private ArrayList<ITable> facts;
        private Boolean guacamoleArchived;
        private ArrayList<IGuacamoleColumn> guacamoleColumns;
        private Long guacamoleSize;
        private GuacamoleTemperature guacamoleTemperature;
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        private ArrayList<ILineageProcess> inputToProcesses;
        private Boolean isPartitioned;
        private Boolean isProfiled;
        private Boolean isQueryPreview;
        private Boolean isTemporary;
        private Long lastProfiledAt;
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        private ArrayList<ILineageProcess> outputFromProcesses;
        private Long partitionCount;
        private String partitionList;
        private String partitionStrategy;
        private ArrayList<ITablePartition> partitions;
        private ArrayList<IAtlanQuery> queries;
        private Long queryCount;
        private Long queryCountUpdatedAt;
        private ArrayList<String> queryPreviewConfig$key;
        private ArrayList<String> queryPreviewConfig$value;
        private Long queryUserCount;
        private ArrayList<String> queryUserMap$key;
        private ArrayList<Long> queryUserMap$value;
        private Long rowCount;
        private ISchema schema;
        private String schemaName;
        private String schemaQualifiedName;
        private Long sizeBytes;
        private ArrayList<IDbtSource> sqlDBTSources;
        private ArrayList<IDbtModel> sqlDbtModels;
        private String tableName;
        private String tableQualifiedName;
        private String viewName;
        private String viewQualifiedName;

        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GuacamoleTableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(GuacamoleTable instance, GuacamoleTableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.alias(instance.alias);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.dimensions(instance.dimensions == null ? Collections.emptySortedSet() : instance.dimensions);
            b.externalLocation(instance.externalLocation);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.facts(instance.facts == null ? Collections.emptySortedSet() : instance.facts);
            b.guacamoleArchived(instance.guacamoleArchived);
            b.guacamoleColumns(instance.guacamoleColumns == null ? Collections.emptySortedSet() : instance.guacamoleColumns);
            b.guacamoleSize(instance.guacamoleSize);
            b.guacamoleTemperature(instance.guacamoleTemperature);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isPartitioned(instance.isPartitioned);
            b.isProfiled(instance.isProfiled);
            b.isQueryPreview(instance.isQueryPreview);
            b.isTemporary(instance.isTemporary);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.partitionStrategy(instance.partitionStrategy);
            b.partitions(instance.partitions == null ? Collections.emptySortedSet() : instance.partitions);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.rowCount(instance.rowCount);
            b.schema(instance.schema);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sizeBytes(instance.sizeBytes);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        protected abstract B self();

        public abstract C build();

        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        public B dimension(ITable dimension) {
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.add(dimension);
            return (B)this.self();
        }

        public B dimensions(Collection<? extends ITable> dimensions) {
            if (dimensions == null) {
                throw new NullPointerException("dimensions cannot be null");
            }
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.addAll(dimensions);
            return (B)this.self();
        }

        public B clearDimensions() {
            if (this.dimensions != null) {
                this.dimensions.clear();
            }
            return (B)this.self();
        }

        public B externalLocation(String externalLocation) {
            this.externalLocation = externalLocation;
            return (B)this.self();
        }

        public B externalLocationFormat(String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return (B)this.self();
        }

        public B externalLocationRegion(String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return (B)this.self();
        }

        public B fact(ITable fact) {
            if (this.facts == null) {
                this.facts = new ArrayList();
            }
            this.facts.add(fact);
            return (B)this.self();
        }

        public B facts(Collection<? extends ITable> facts) {
            if (facts == null) {
                throw new NullPointerException("facts cannot be null");
            }
            if (this.facts == null) {
                this.facts = new ArrayList();
            }
            this.facts.addAll(facts);
            return (B)this.self();
        }

        public B clearFacts() {
            if (this.facts != null) {
                this.facts.clear();
            }
            return (B)this.self();
        }

        public B guacamoleArchived(Boolean guacamoleArchived) {
            this.guacamoleArchived = guacamoleArchived;
            return (B)this.self();
        }

        public B guacamoleColumn(IGuacamoleColumn guacamoleColumn) {
            if (this.guacamoleColumns == null) {
                this.guacamoleColumns = new ArrayList();
            }
            this.guacamoleColumns.add(guacamoleColumn);
            return (B)this.self();
        }

        public B guacamoleColumns(Collection<? extends IGuacamoleColumn> guacamoleColumns) {
            if (guacamoleColumns == null) {
                throw new NullPointerException("guacamoleColumns cannot be null");
            }
            if (this.guacamoleColumns == null) {
                this.guacamoleColumns = new ArrayList();
            }
            this.guacamoleColumns.addAll(guacamoleColumns);
            return (B)this.self();
        }

        public B clearGuacamoleColumns() {
            if (this.guacamoleColumns != null) {
                this.guacamoleColumns.clear();
            }
            return (B)this.self();
        }

        public B guacamoleSize(Long guacamoleSize) {
            this.guacamoleSize = guacamoleSize;
            return (B)this.self();
        }

        public B guacamoleTemperature(GuacamoleTemperature guacamoleTemperature) {
            this.guacamoleTemperature = guacamoleTemperature;
            return (B)this.self();
        }

        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        public B isPartitioned(Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return (B)this.self();
        }

        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        public B partitionCount(Long partitionCount) {
            this.partitionCount = partitionCount;
            return (B)this.self();
        }

        public B partitionList(String partitionList) {
            this.partitionList = partitionList;
            return (B)this.self();
        }

        public B partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return (B)this.self();
        }

        public B partition(ITablePartition partition) {
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.add(partition);
            return (B)this.self();
        }

        public B partitions(Collection<? extends ITablePartition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("partitions cannot be null");
            }
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.addAll(partitions);
            return (B)this.self();
        }

        public B clearPartitions() {
            if (this.partitions != null) {
                this.partitions.clear();
            }
            return (B)this.self();
        }

        public B query(IAtlanQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        public B queries(Collection<? extends IAtlanQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        public B schema(ISchema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        public String toString() {
            return "GuacamoleTable.GuacamoleTableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", alias=" + this.alias + ", columnCount=" + this.columnCount + ", columns=" + this.columns + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", dimensions=" + this.dimensions + ", externalLocation=" + this.externalLocation + ", externalLocationFormat=" + this.externalLocationFormat + ", externalLocationRegion=" + this.externalLocationRegion + ", facts=" + this.facts + ", guacamoleArchived=" + this.guacamoleArchived + ", guacamoleColumns=" + this.guacamoleColumns + ", guacamoleSize=" + this.guacamoleSize + ", guacamoleTemperature=" + this.guacamoleTemperature + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isPartitioned=" + this.isPartitioned + ", isProfiled=" + this.isProfiled + ", isQueryPreview=" + this.isQueryPreview + ", isTemporary=" + this.isTemporary + ", lastProfiledAt=" + this.lastProfiledAt + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", partitionStrategy=" + this.partitionStrategy + ", partitions=" + this.partitions + ", queries=" + this.queries + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rowCount=" + this.rowCount + ", schema=" + this.schema + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sizeBytes=" + this.sizeBytes + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }
}

