/*
 * Decompiled with CFR 0.152.
 */
package com.probable.guacamole.typedefs;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.probable.guacamole.ExtendedModelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefDestroyer
extends ExtendedModelGenerator {
    private static final Logger log = LoggerFactory.getLogger(TypeDefDestroyer.class);

    public static void main(String[] args) {
        TypeDefDestroyer tdd = new TypeDefDestroyer();
        tdd.purgeTypeDefs();
    }

    void purgeTypeDefs() {
        this.purgeTypeDef("GuacamoleTableColumns");
        this.purgeTypeDef("GuacamoleTable");
        this.purgeTypeDef("GuacamoleColumn");
        this.purgeTypeDef("GuacamoleTemperature");
        this.purgeTypeDef("GuacamoleStruct");
    }

    private void purgeTypeDef(String name) {
        try {
            Atlan.getDefaultClient().typeDefs.purge(name);
            log.info("Purged typedef: {}", (Object)name);
        }
        catch (AtlanException e) {
            log.error("Failed to purge typedef: {}", (Object)name, (Object)e);
        }
    }
}

