/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.events;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.events.AtlanEventHandler;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.events.AtlanEvent;
import com.atlan.model.events.AwsEventWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLambdaHandler
implements RequestStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractLambdaHandler.class);
    private static final String SIGNING_SECRET;
    private final AtlanEventHandler handler;

    public AbstractLambdaHandler(AtlanEventHandler handler) {
        this.handler = handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(AtlanEvent event, Context context) throws IOException {
        boolean proceed;
        try {
            proceed = this.handler.validatePrerequisites(event, log);
        }
        catch (AtlanException e) {
            throw new IOException("Unable to validate prerequisites, failing.", e);
        }
        if (!proceed) throw new IOException("Prerequisites failed, will not proceed with processing the event.");
        try {
            Asset current = this.handler.getCurrentState(Atlan.getDefaultClient(), event.getPayload().getAsset(), log);
            Collection updated = this.handler.calculateChanges(current, log);
            if (updated.isEmpty()) return;
            this.handler.saveChanges(Atlan.getDefaultClient(), updated, log);
            return;
        }
        catch (AtlanException e) {
            throw new IOException("Unable to update Atlan asset: " + event.getPayload().getAsset().getQualifiedName(), e);
        }
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        block16: {
            try (InputStream inputStream = input;
                 OutputStream outputStream = output;){
                String request = AbstractLambdaHandler.getRequestAsString(input);
                AwsEventWrapper wrapper = (AwsEventWrapper)Atlan.getDefaultClient().readValue(request, AwsEventWrapper.class);
                String body = wrapper.getBody();
                if (AtlanEventHandler.isValidationRequest((String)body)) {
                    log.info("Matches a validation request \u2014 doing nothing and succeeding.");
                    break block16;
                }
                if (AtlanEventHandler.validSignature((String)SIGNING_SECRET, (Map)wrapper.getHeaders())) {
                    try {
                        this.processEvent(AtlanEventHandler.getAtlanEvent((AtlanClient)Atlan.getDefaultClient(), (String)body), context);
                    }
                    catch (IOException e) {
                        log.error("Unable to process the event.", (Throwable)e);
                    }
                    break block16;
                }
                throw new IOException("Invalid signing secret received \u2014 will not process this request.");
            }
        }
    }

    private static String getRequestAsString(InputStream input) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining());
            return string;
        }
    }

    static {
        Atlan.setBaseUrl((String)System.getenv("ATLAN_BASE_URL"));
        Atlan.setApiToken((String)System.getenv("ATLAN_API_KEY"));
        SIGNING_SECRET = System.getenv("SIGNING_SECRET");
    }
}

