/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.events;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.events.AtlanEventHandler;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.events.AtlanEvent;
import io.numaproj.numaflow.function.handlers.MapHandler;
import io.numaproj.numaflow.function.interfaces.Datum;
import io.numaproj.numaflow.function.types.Message;
import io.numaproj.numaflow.function.types.MessageList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNumaflowHandler
extends MapHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractNumaflowHandler.class);
    public static final String FAILURE = "failure";
    public static final String SUCCESS = "success";
    private final AtlanEventHandler handler;

    public AbstractNumaflowHandler(AtlanEventHandler handler) {
        this.handler = handler;
    }

    public MessageList processEvent(AtlanEvent event, String[] keys, Datum data) {
        try {
            if (!this.handler.validatePrerequisites(event, log)) {
                return AbstractNumaflowHandler.failed(keys, data);
            }
        }
        catch (AtlanException e) {
            log.error("Unable to validate prerequisites, failing.", (Throwable)e);
            return AbstractNumaflowHandler.failed(keys, data);
        }
        try {
            Asset current = this.handler.getCurrentState(Atlan.getDefaultClient(), event.getPayload().getAsset(), log);
            Collection updated = this.handler.calculateChanges(current, log);
            if (!updated.isEmpty()) {
                this.handler.saveChanges(Atlan.getDefaultClient(), updated, log);
                return AbstractNumaflowHandler.succeeded(keys, data);
            }
            return AbstractNumaflowHandler.drop();
        }
        catch (AtlanException e) {
            log.error("Unable to update Atlan asset: {}", (Object)event.getPayload().getAsset().getQualifiedName(), (Object)e);
            return AbstractNumaflowHandler.failed(keys, data);
        }
    }

    public MessageList processMessage(String[] keys, Datum data) {
        try {
            return this.processEvent(AbstractNumaflowHandler.getAtlanEvent(data), keys, data);
        }
        catch (IOException e) {
            log.error("Unable to deserialize event: {}", (Object)new String(data.getValue(), StandardCharsets.UTF_8), (Object)e);
            return AbstractNumaflowHandler.failed(keys, data.getValue());
        }
    }

    protected static AtlanEvent getAtlanEvent(Datum data) throws IOException {
        return AtlanEventHandler.getAtlanEvent((AtlanClient)Atlan.getDefaultClient(), (byte[])data.getValue());
    }

    protected static MessageList failed(String[] keys, Datum data) {
        return AbstractNumaflowHandler.failed(keys, data.getValue());
    }

    protected static MessageList failed(String[] keys, byte[] data) {
        log.info("Routing to: {}", (Object)FAILURE);
        return MessageList.newBuilder().addMessage(new Message(data, keys, new String[]{FAILURE})).build();
    }

    protected static MessageList succeeded(String[] keys, Datum data) {
        return AbstractNumaflowHandler.succeeded(keys, data.getValue());
    }

    protected static MessageList succeeded(String[] keys, byte[] data) {
        log.info("Routing to: {}", (Object)SUCCESS);
        return MessageList.newBuilder().addMessage(new Message(data, keys, new String[]{SUCCESS})).build();
    }

    protected static MessageList forward(Datum data) {
        return AbstractNumaflowHandler.forward(data.getValue());
    }

    protected static MessageList forward(byte[] data) {
        return MessageList.newBuilder().addMessage(new Message(data)).build();
    }

    protected static MessageList drop() {
        return MessageList.newBuilder().addMessage(Message.toDrop()).build();
    }

    public AtlanEventHandler getHandler() {
        return this.handler;
    }

    static {
        Atlan.setBaseUrl((String)System.getenv("ATLAN_BASE_URL"));
        Atlan.setApiToken((String)System.getenv("ATLAN_API_KEY"));
    }
}

