/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.events;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.events.AtlanEventHandler;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PlaybookActionOperator;
import com.atlan.model.enums.PlaybookActionType;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.PlaybookAction;
import com.atlan.model.workflow.PlaybookActionSchema;
import com.atlan.model.workflow.PlaybookRule;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowSearchResponse;
import com.atlan.model.workflow.WorkflowSearchResult;
import com.atlan.model.workflow.WorkflowSearchResultDetail;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.net.HttpClient;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaybookRunner
implements AtlanEventHandler {
    private static final Logger log = LoggerFactory.getLogger(PlaybookRunner.class);
    private static final List<String> MUTABLE_ATTRS = List.of("description", "userDescription", "certificateStatus", "ownerUsers", "ownerGroups", "meanings", "classifications");
    private static final PlaybookRunner INSTANCE = PlaybookRunner.createInstance();

    private static PlaybookRunner createInstance() {
        return new PlaybookRunner();
    }

    public static PlaybookRunner getInstance() {
        return INSTANCE;
    }

    public Asset getCurrentState(AtlanClient client, Asset fromEvent, Logger log) throws AtlanException {
        return Asset.get((AtlanClient)client, (String)fromEvent.getGuid(), (boolean)true);
    }

    public Collection<Asset> calculateChanges(Asset original, Logger log) throws AtlanException {
        long start = System.currentTimeMillis();
        log.info("Picked up event for: {}", (Object)original.getQualifiedName());
        Asset.AssetBuilder full = (Asset.AssetBuilder)original.toBuilder();
        Asset.AssetBuilder trimmed = original.trimToRequired();
        Map<String, List<PlaybookRule>> playbooks = this.fetchPlaybooks();
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed < 2000L) {
            try {
                int wait = elapsed < 1000L ? 3 : 2;
                Thread.sleep(HttpClient.waitTime((int)wait).toMillis());
            }
            catch (InterruptedException e) {
                log.warn("Consistency delay was interrupted, results from here may vary...", (Throwable)e);
            }
        }
        for (Map.Entry<String, List<PlaybookRule>> entry : playbooks.entrySet()) {
            String playbookName = entry.getKey();
            List<PlaybookRule> rules = entry.getValue();
            for (PlaybookRule rule : rules) {
                IndexSearchRequest filter = rule.getConfig().getQuery();
                Query query = filter.getDsl().getQuery();
                IndexSearchRequest match = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Atlan.getDefaultClient().assets.select().where(query)).where(Asset.GUID.eq(original.getGuid()))).toRequest();
                Asset asset = null;
                IndexSearchResponse response = match.search();
                if (response != null && response.getAssets() != null && !response.getAssets().isEmpty()) {
                    asset = (Asset)response.getAssets().get(0);
                }
                if (asset == null) {
                    log.info("Asset {} did not match playbook \"{}\"'s criteria (rule: {}) - skipping its actions.", new Object[]{original.getGuid(), playbookName, rule.getName()});
                    continue;
                }
                List actions = rule.getActions();
                for (PlaybookAction action : actions) {
                    PlaybookActionType type = action.getType();
                    if (type == PlaybookActionType.METADATA_UPDATE) {
                        log.info("Applying actions from \"{}::{}\" to: {}", new Object[]{playbookName, rule.getName(), original.getQualifiedName()});
                        this.applyMetadataUpdate(full, trimmed, action.getActionsSchema());
                        continue;
                    }
                    log.warn("Unhandled playbook action type {} in playbook \"{}\" (rule: {}) - skipping.", new Object[]{type, playbookName, rule.getName()});
                }
            }
        }
        return this.hasChanges(original, full.build(), log) ? Set.of(trimmed.build()) : Collections.emptySet();
    }

    private Map<String, List<PlaybookRule>> fetchPlaybooks() throws AtlanException {
        LinkedHashMap<String, List<PlaybookRule>> map = new LinkedHashMap<String, List<PlaybookRule>>();
        WorkflowSearchResponse response = Atlan.getDefaultClient().playbooks.list(50);
        if (response != null && response.getHits() != null) {
            List hits = response.getHits().getHits();
            for (WorkflowSearchResult hit : hits) {
                WorkflowSearchResultDetail detail = hit.get_source();
                WorkflowSpec spec = detail.getSpec();
                WorkflowMetadata metadata = spec.getWorkflowMetadata();
                Map annotations = metadata.getAnnotations();
                String playbookName = (String)annotations.get("workflows.argoproj.io/atlanName");
                List parameters = ((WorkflowTask)((WorkflowTemplate)spec.getTemplates().get(0)).getDag().getTasks().get(0)).getArguments().getParameters();
                List rules = null;
                for (NameValuePair parameter : parameters) {
                    if (!parameter.getName().equals("rules")) continue;
                    String value = (String)parameter.getValue();
                    try {
                        rules = (List)Atlan.getDefaultClient().readValue(value, (TypeReference)new TypeReference<List<PlaybookRule>>(){});
                    }
                    catch (IOException e) {
                        log.error("Unable to parse rules for playbook \"{}\" - skipping...", (Object)playbookName);
                    }
                }
                if (rules == null) continue;
                map.put(playbookName, rules);
            }
        }
        return map;
    }

    private void applyMetadataUpdate(Asset.AssetBuilder<?, ?> full, Asset.AssetBuilder<?, ?> trimmed, PlaybookActionSchema schema) {
        String operand = schema.getOperand();
        PlaybookActionOperator operator = schema.getOperator();
        Object value = schema.getValue();
        switch (operand) {
            case "certificateStatus": {
                full.certificateStatus(CertificateStatus.fromValue((String)((String)value)));
                trimmed.certificateStatus(CertificateStatus.fromValue((String)((String)value)));
                break;
            }
            case "description": {
                full.description((String)value);
                trimmed.description((String)value);
                break;
            }
            case "userDescription": {
                full.userDescription((String)value);
                trimmed.userDescription((String)value);
                break;
            }
            case "owners": {
                this.changeOwners(full, trimmed, operator, value);
                break;
            }
            default: {
                log.error("Unhandled attribute {} - skipping.", (Object)operand);
            }
        }
    }

    private void changeOwners(Asset.AssetBuilder<?, ?> full, Asset.AssetBuilder<?, ?> trimmed, PlaybookActionOperator operator, Object value) {
        if (value instanceof Map) {
            Map owners = (Map)value;
            switch (operator) {
                case ADD: {
                    if (owners.containsKey("ownerUsers")) {
                        full.ownerUsers((Collection)owners.get("ownerUsers"));
                        trimmed.ownerUsers((Collection)owners.get("ownerUsers"));
                    }
                    if (!owners.containsKey("ownerGroups")) break;
                    full.ownerGroups((Collection)owners.get("ownerGroups"));
                    trimmed.ownerGroups((Collection)owners.get("ownerGroups"));
                    break;
                }
                case REMOVE: {
                    Asset current = full.build();
                    if (owners.containsKey("ownerUsers")) {
                        full.clearOwnerUsers();
                        trimmed.clearOwnerUsers();
                        List usersToRemove = (List)owners.get("ownerUsers");
                        ArrayList<String> usersToKeep = new ArrayList<String>();
                        for (String user : current.getOwnerUsers()) {
                            if (usersToRemove.contains(user)) continue;
                            usersToKeep.add(user);
                        }
                        if (!usersToKeep.isEmpty()) {
                            full.ownerUsers(usersToKeep);
                            trimmed.ownerUsers(usersToKeep);
                        } else {
                            full.nullField("ownerUsers");
                            trimmed.nullField("ownerUsers");
                        }
                    }
                    if (!owners.containsKey("ownerGroups")) break;
                    full.clearOwnerGroups();
                    trimmed.clearOwnerGroups();
                    List groupsToRemove = (List)owners.get("ownerGroups");
                    ArrayList<String> groupsToKeep = new ArrayList<String>();
                    for (String group : current.getOwnerGroups()) {
                        if (groupsToRemove.contains(group)) continue;
                        groupsToKeep.add(group);
                    }
                    if (!groupsToKeep.isEmpty()) {
                        full.ownerGroups(groupsToKeep);
                        trimmed.ownerGroups(groupsToKeep);
                        break;
                    }
                    full.nullField("ownerGroups");
                    trimmed.nullField("ownerGroups");
                    break;
                }
                case REPLACE: {
                    full.clearOwnerGroups().clearOwnerUsers();
                    trimmed.clearOwnerGroups().clearOwnerUsers();
                    if (owners.containsKey("ownerUsers")) {
                        full.ownerUsers((Collection)owners.get("ownerUsers"));
                        trimmed.ownerUsers((Collection)owners.get("ownerUsers"));
                    } else {
                        full.nullField("ownerUsers");
                        trimmed.nullField("ownerUsers");
                    }
                    if (owners.containsKey("ownerGroups")) {
                        full.ownerGroups((Collection)owners.get("ownerGroups"));
                        trimmed.ownerGroups((Collection)owners.get("ownerGroups"));
                        break;
                    }
                    full.nullField("ownerGroups");
                    trimmed.nullField("ownerGroups");
                    break;
                }
                default: {
                    log.error("Unknown operation for owners - skipping: {}", (Object)operator);
                }
            }
        }
    }
}

