/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.structs.AtlanStruct;
import com.atlan.serde.Serde;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class AbstractLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    private int _batchSize = 50;
    private String _delimiter = "|";
    private Region _region = null;
    private String _bucket = null;
    private String _filename = null;
    private boolean _updateOnly = false;

    protected void parseParametersFromEvent(Map<String, String> event) {
        if (event != null) {
            log.debug(" ... event: {}", event);
            String batchSize = event.getOrDefault("BATCH_SIZE", "50");
            try {
                this._batchSize = Integer.parseInt(batchSize);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the BATCH_SIZE value of '{}', falling back to a default of 50.", (Object)batchSize);
                this._batchSize = 50;
            }
            String updateOnly = event.getOrDefault("UPDATE_ONLY", "false");
            this._updateOnly = updateOnly.toUpperCase(Locale.ROOT).equals("TRUE");
            this._delimiter = event.getOrDefault("DELIMITER", "|");
            String region = event.getOrDefault("REGION", "ap-south-1");
            this._region = Region.of((String)region);
            this._bucket = event.getOrDefault("BUCKET", null);
            this._filename = event.getOrDefault("FILENAME", "atlan-documentation-template.xlsx");
            Atlan.setBaseUrl((String)event.getOrDefault("ATLAN_BASE_URL", null));
            Atlan.setApiToken((String)event.getOrDefault("ATLAN_API_KEY", null));
            String maxRetries = event.getOrDefault("MAX_RETRIES", "20");
            int _maxRetries = 20;
            try {
                _maxRetries = Integer.parseInt(maxRetries);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to determine a number from the MAX_RETRIES value of '{}', falling back to a default of 20.", (Object)maxRetries);
            }
            Atlan.setMaxNetworkRetries((int)_maxRetries);
        }
    }

    protected void appendAtlanTags(Map<String, List<String>> assetMap, String typeName) {
        List<Object> atlanTags;
        String qn;
        HashMap<String, List<Object>> toRetag = new HashMap<String, List<Object>>();
        if (!assetMap.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : assetMap.entrySet()) {
                qn = entry.getKey();
                atlanTags = new ArrayList(entry.getValue());
                try {
                    Asset column = Asset.get((AtlanClient)Atlan.getDefaultClient(), (String)typeName, (String)qn, (boolean)false);
                    SortedSet existing = column.getAtlanTags();
                    ArrayList<String> toRemove = new ArrayList<String>();
                    for (AtlanTag one : existing) {
                        if (!atlanTags.contains(one.getTypeName())) continue;
                        toRemove.add(one.getTypeName());
                    }
                    atlanTags.removeAll(toRemove);
                    if (atlanTags.isEmpty()) continue;
                    toRetag.put(qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to find {} {} \u2014 cannot retag it.", new Object[]{typeName, qn, e});
                }
            }
        }
        if (!toRetag.isEmpty()) {
            log.info("... tagging {} {}s:", (Object)toRetag.size(), (Object)typeName);
            for (Map.Entry<String, List<String>> entry : toRetag.entrySet()) {
                qn = entry.getKey();
                atlanTags = entry.getValue();
                try {
                    log.info("...... tagging: {}", (Object)qn);
                    Atlan.getDefaultClient().assets.addAtlanTags(typeName, qn, atlanTags);
                }
                catch (AtlanException e) {
                    log.error("Unable to tag {} {} with: {}", new Object[]{typeName, qn, atlanTags, e});
                }
            }
        }
    }

    protected static List<String> getEmbeddedList(String value, String delimiter) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(Pattern.quote(delimiter)));
    }

    protected Object deserializeCMValueFromCSV(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.contains(this.getDelimiter())) {
            return AbstractLoader.getEmbeddedList(value, this.getDelimiter());
        }
        return value;
    }

    protected Object deserializeValueFromCSV(String value, Method setter) throws IOException {
        Class paramClass = ReflectionCache.getParameterOfMethod((Method)setter);
        Class innerClass = null;
        String fieldName = setter.getName();
        if (Collection.class.isAssignableFrom(paramClass) || Map.class.isAssignableFrom(paramClass)) {
            Type paramType = ReflectionCache.getParameterizedTypeOfMethod((Method)setter);
            innerClass = ReflectionCache.getClassOfParameterizedType((Type)paramType);
        }
        return this.deserializeValueFromCSV(value, paramClass, innerClass, fieldName);
    }

    private Object deserializeValueFromCSV(String value, Class<?> type, Class<?> innerType, String fieldName) throws IOException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.parseBoolean(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return Integer.parseInt(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return Long.parseLong(value);
        }
        if (Double.class.isAssignableFrom(type)) {
            return Double.parseDouble(value);
        }
        if (Collection.class.isAssignableFrom(type)) {
            String[] values = value.split(Pattern.quote(this.getDelimiter()));
            ArrayList<Object> results = new ArrayList<Object>();
            if (AtlanTag.class.isAssignableFrom(innerType)) {
                for (String tag : values) {
                    results.add(AtlanTag.of((String)tag));
                }
            } else if (AtlanStruct.class.isAssignableFrom(innerType)) {
                for (String struct : values) {
                    results.add(this.deserializeStructToCSV(struct, innerType));
                }
            } else if (AtlanEnum.class.isAssignableFrom(innerType)) {
                for (String enumVal : values) {
                    results.add(this.deserializeEnumFromCSV(enumVal, innerType));
                }
            } else if (innerType.isInterface()) {
                for (String asset : values) {
                    results.add(this.deserializeAssetRefFromCSV(asset));
                }
            } else if (String.class.isAssignableFrom(innerType)) {
                results.addAll(Arrays.asList(values));
            } else {
                throw new IOException("Unhandled collection of values: " + innerType);
            }
            if (type == Collection.class || type == List.class) {
                return results;
            }
            if (type == Set.class || type == SortedSet.class) {
                return new TreeSet(results);
            }
            throw new IOException("Unable to deserialize CSV list to Java class: " + type);
        }
        if (Asset.class.isAssignableFrom(type)) {
            return this.deserializeAssetRefFromCSV(value);
        }
        if (AtlanEnum.class.isAssignableFrom(type)) {
            return this.deserializeEnumFromCSV(value, type);
        }
        if (AtlanStruct.class.isAssignableFrom(type)) {
            return this.deserializeStructToCSV(value, type);
        }
        throw new IOException("Unhandled data type for " + fieldName + ": " + type);
    }

    protected Object deserializeAssetRefFromCSV(String assetRef) throws IOException {
        String[] tokens = assetRef.split(Pattern.quote("@"));
        String typeName = tokens[0];
        try {
            Class assetClass = Serde.getAssetClassForType((String)typeName);
            Method method = assetClass.getMethod("refByQualifiedName", String.class);
            String qualifiedName = String.join((CharSequence)"@", Arrays.copyOfRange(tokens, 1, tokens.length));
            return method.invoke(null, qualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("No class " + typeName + " found \u2014 unable to translate to an asset reference: " + assetRef, e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Unable to translate to an asset reference: " + assetRef, e);
        }
    }

    protected Object deserializeStructToCSV(String struct, Class<?> structClass) throws IOException {
        throw new IOException("Structs are currently unhandled in the loader.");
    }

    protected Object deserializeEnumFromCSV(String enumValue, Class<?> enumClass) throws IOException {
        try {
            Method method = enumClass.getMethod("fromValue", String.class);
            return method.invoke(null, enumValue);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Unable to translate to an enumerated value: " + enumValue, e);
        }
    }

    public void setFilename(String _filename) {
        this._filename = _filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getBucket() {
        return this._bucket;
    }

    public Region getRegion() {
        return this._region;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public boolean isUpdateOnly() {
        return this._updateOnly;
    }
}

