/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.samples.loaders.caches.TermCache;
import com.atlan.samples.loaders.models.EnrichmentDetails;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetEnrichmentDetails
extends EnrichmentDetails {
    private static final Logger log = LoggerFactory.getLogger(AssetEnrichmentDetails.class);
    public static final String COL_QUALIFIED_NAME = "QUALIFIED NAME";
    public static final String COL_TYPE = "TYPE";
    public static final String COL_NAME = "NAME";
    public static final String COL_ASSIGNED_TERMS = "ASSIGNED TERMS";
    private static final List<String> REQUIRED = List.of("QUALIFIED NAME", "TYPE", "NAME");
    private String qualifiedName;
    private String type;
    private String name;
    private List<Asset> terms;

    @Override
    public String getIdentity() {
        return AssetEnrichmentDetails.getIdentity(this.type, this.qualifiedName);
    }

    public static String getIdentity(String typeName, String qualifiedName) {
        return qualifiedName + "@" + typeName;
    }

    public static AssetEnrichmentDetails getFromRow(TermCache termCache, Map<String, String> row, String delim) {
        AssetEnrichmentDetailsBuilder builder = AssetEnrichmentDetails.getFromRow(AssetEnrichmentDetails.builder(), row, delim);
        if (AssetEnrichmentDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String qualifiedName = row.get(COL_QUALIFIED_NAME);
            builder = (AssetEnrichmentDetailsBuilder)((AssetEnrichmentDetailsBuilder)((AssetEnrichmentDetailsBuilder)((EnrichmentDetails.EnrichmentDetailsBuilder)((AssetEnrichmentDetailsBuilder)((AssetEnrichmentDetailsBuilder)builder.qualifiedName(qualifiedName)).type(row.get(COL_TYPE))).name(row.get(COL_NAME))).userDescription(row.get("USER DESCRIPTION"))).readme(row.get("README"))).customMetadataValues(AssetEnrichmentDetails.getCustomMetadataValuesFromRow(row, delim));
            List<String> termIdentities = AssetEnrichmentDetails.getMultiValuedList(row.get(COL_ASSIGNED_TERMS), delim);
            ArrayList<Asset> terms = new ArrayList<Asset>();
            for (String termIdentity : termIdentities) {
                Asset term = termCache.get(termIdentity);
                if (term != null) {
                    terms.add(term);
                    continue;
                }
                log.warn("Unable to find term {} for asset {} \u2014 skipping this assignment.", (Object)termIdentity, (Object)qualifiedName);
            }
            builder = builder.terms(terms);
            return ((AssetEnrichmentDetailsBuilder)builder.stub(false)).build();
        }
        return null;
    }

    public static void upsert(Map<String, AssetEnrichmentDetails> assets, int batchSize, boolean replaceAtlanTags, boolean replaceCM, boolean updateOnly) {
        HashMap toTagMap = new HashMap();
        HashMap<String, Map<String, CustomMetadataAttributes>> cmToUpdate = new HashMap<String, Map<String, CustomMetadataAttributes>>();
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "asset", batchSize, replaceAtlanTags, AssetBatch.CustomMetadataHandling.OVERWRITE);
        HashMap<String, String> readmes = new HashMap<String, String>();
        HashMap<String, Asset> assetIdentityToResult = new HashMap<String, Asset>();
        try {
            for (AssetEnrichmentDetails details : assets.values()) {
                String string;
                Asset.AssetBuilder builder = null;
                if (updateOnly) {
                    String typeName = details.getType();
                    String string2 = details.getQualifiedName();
                    try {
                        Asset.get((AtlanClient)Atlan.getDefaultClient(), (String)typeName, (String)string2, (boolean)false);
                        builder = IndistinctAsset._internal().typeName(typeName).qualifiedName(string2);
                    }
                    catch (NotFoundException e) {
                        log.warn("Unable to find existing asset \u2014 skipping: {}", (Object)string2);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to lookup whether asset exists or not.", (Throwable)e);
                    }
                } else {
                    builder = IndistinctAsset._internal().typeName(details.getType()).qualifiedName(details.getQualifiedName());
                }
                if (builder == null) continue;
                builder.name(details.getName()).description(details.getDescription()).userDescription(details.getUserDescription()).certificateStatus(details.getCertificate()).certificateStatusMessage(details.getCertificateStatusMessage()).announcementType(details.getAnnouncementType()).announcementTitle(details.getAnnouncementTitle()).announcementMessage(details.getAnnouncementMessage()).ownerUsers(details.getOwnerUsers()).ownerGroups(details.getOwnerGroups());
                for (Asset asset : details.getTerms()) {
                    builder = builder.assignedTerm((IGlossaryTerm)GlossaryTerm.refByGuid((String)asset.getGuid()));
                }
                if (details.getCustomMetadataValues() != null) {
                    builder = builder.customMetadataSets(details.getCustomMetadataValues());
                }
                if (details.getAtlanTags() != null) {
                    List<String> clsNames = details.getAtlanTags();
                    for (String clsName : clsNames) {
                        builder = builder.atlanTag(AtlanTag.of((String)clsName));
                    }
                }
                Asset asset = builder.build();
                if (!replaceAtlanTags && !details.getAtlanTags().isEmpty()) {
                    List<String> list;
                    if (!toTagMap.containsKey(details.getType())) {
                        toTagMap.put(details.getType(), new HashMap());
                    }
                    if ((list = ((Map)toTagMap.get(details.getType())).put(details.getQualifiedName(), details.getAtlanTags())) != null) {
                        log.warn("Multiple entries with the same qualifiedName: {}", (Object)details.getQualifiedName());
                    }
                }
                if ((string = details.getReadme()) != null && !string.isEmpty()) {
                    readmes.put(details.getIdentity(), string);
                    assetIdentityToResult.put(details.getIdentity(), asset);
                }
                AssetEnrichmentDetails.cacheResult(assetIdentityToResult, batch.add(asset), assets.size());
                if (replaceCM || details.getCustomMetadataValues().isEmpty()) continue;
                cmToUpdate.put(details.getIdentity(), details.getCustomMetadataValues());
            }
            AssetEnrichmentDetails.cacheResult(assetIdentityToResult, batch.flush(), assets.size());
        }
        catch (AtlanException e) {
            log.error("Unable to batch-upsert assets.", (Throwable)e);
        }
        if (!replaceAtlanTags) {
            for (Map.Entry entry : toTagMap.entrySet()) {
                String typeName = (String)entry.getKey();
                Map toTag = (Map)entry.getValue();
                AssetEnrichmentDetails.appendAtlanTags(toTag, typeName);
            }
        }
        if (!replaceCM) {
            HashMap<String, Map<String, CustomMetadataAttributes>> toUpdate = new HashMap<String, Map<String, CustomMetadataAttributes>>();
            for (Map.Entry entry : cmToUpdate.entrySet()) {
                String identity = (String)entry.getKey();
                Asset asset = (Asset)assetIdentityToResult.get(identity);
                if (asset == null) continue;
                toUpdate.put(asset.getGuid(), (Map)entry.getValue());
            }
            AssetEnrichmentDetails.selectivelyUpdateCustomMetadata(toUpdate);
        }
        try {
            AssetBatch readmeBatch = new AssetBatch(Atlan.getDefaultClient(), "Readme", batchSize);
            for (Map.Entry entry : readmes.entrySet()) {
                String assetIdentity = (String)entry.getKey();
                String string = (String)entry.getValue();
                Asset asset = (Asset)assetIdentityToResult.get(assetIdentity);
                if (asset != null) {
                    Readme readme = Readme.creator((Asset)asset, (String)asset.getName(), (String)string).build();
                    readmeBatch.add((Asset)readme);
                    continue;
                }
                log.error("Unable to find asset GUID for {} \u2014 cannot add README.", (Object)assetIdentity);
            }
            readmeBatch.flush();
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert the READMEs for assets.", (Throwable)e);
        }
    }

    private static void cacheResult(Map<String, Asset> cache, AssetMutationResponse response, long totalResults) {
        HashSet<String> cachedGuids = new HashSet<String>();
        if (response != null) {
            int localCount = cache.size();
            log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            List created = response.getCreatedAssets();
            for (Asset one : created) {
                String identity = AssetEnrichmentDetails.getIdentity(one.getTypeName(), one.getQualifiedName());
                cache.put(identity, one);
                cachedGuids.add(one.getGuid());
            }
            List updated = response.getUpdatedAssets();
            for (Asset one : updated) {
                String identity = AssetEnrichmentDetails.getIdentity(one.getTypeName(), one.getQualifiedName());
                cache.put(identity, one);
                cachedGuids.add(one.getGuid());
            }
            for (String guid : response.getGuidAssignments().values()) {
                if (cachedGuids.contains(guid)) continue;
                try {
                    Asset minimal = Asset.get((AtlanClient)Atlan.getDefaultClient(), (String)guid, (boolean)false);
                    String identity = AssetEnrichmentDetails.getIdentity(minimal.getTypeName(), minimal.getQualifiedName());
                    cache.put(identity, minimal);
                }
                catch (AtlanException e) {
                    log.warn("Mapped GUID from bulk upsert does not appear to exist in Atlan: {}", (Object)guid, (Object)e);
                }
            }
        }
    }

    protected AssetEnrichmentDetails(AssetEnrichmentDetailsBuilder<?, ?> b) {
        super((EnrichmentDetails.EnrichmentDetailsBuilder<?, ?>)b);
        this.qualifiedName = b.qualifiedName;
        this.type = b.type;
        this.name = b.name;
        this.terms = b.terms;
    }

    public static AssetEnrichmentDetailsBuilder<?, ?> builder() {
        return new AssetEnrichmentDetailsBuilderImpl();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Asset> getTerms() {
        return this.terms;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetEnrichmentDetails)) {
            return false;
        }
        AssetEnrichmentDetails other = (AssetEnrichmentDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$qualifiedName = this.getQualifiedName();
        String other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Asset> this$terms = this.getTerms();
        List<Asset> other$terms = other.getTerms();
        return !(this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AssetEnrichmentDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $qualifiedName = this.getQualifiedName();
        result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Asset> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AssetEnrichmentDetails(super=" + super.toString() + ", qualifiedName=" + this.getQualifiedName() + ", type=" + this.getType() + ", name=" + this.getName() + ", terms=" + this.getTerms() + ")";
    }

    private static final class AssetEnrichmentDetailsBuilderImpl
    extends AssetEnrichmentDetailsBuilder<AssetEnrichmentDetails, AssetEnrichmentDetailsBuilderImpl> {
        private AssetEnrichmentDetailsBuilderImpl() {
        }

        @Override
        protected AssetEnrichmentDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public AssetEnrichmentDetails build() {
            return new AssetEnrichmentDetails(this);
        }
    }

    public static abstract class AssetEnrichmentDetailsBuilder<C extends AssetEnrichmentDetails, B extends AssetEnrichmentDetailsBuilder<C, B>>
    extends EnrichmentDetails.EnrichmentDetailsBuilder<C, B> {
        private String qualifiedName;
        private String type;
        private String name;
        private List<Asset> terms;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B qualifiedName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return (B)this.self();
        }

        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B terms(List<Asset> terms) {
            this.terms = terms;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AssetEnrichmentDetails.AssetEnrichmentDetailsBuilder(super=" + super.toString() + ", qualifiedName=" + this.qualifiedName + ", type=" + this.type + ", name=" + this.name + ", terms=" + this.terms + ")";
        }
    }
}

