/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.ADLSAccount;
import com.atlan.model.assets.ADLSContainer;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.IS3;
import com.atlan.model.assets.S3Bucket;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.samples.loaders.models.AccountDetails;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(BucketDetails.class);
    public static final String COL_BUCKET_NAME = "BUCKET NAME";
    public static final String COL_BUCKET_ARN = "BUCKET ARN";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "BUCKET NAME");
    private static final List<String> REQUIRED_EMPTY = List.of("OBJECT NAME");
    private String connectionQualifiedName;
    private String accountName;
    private String name;
    private String arn;

    @Override
    public String getIdentity() {
        return this.connectionQualifiedName + "/" + (this.accountName == null ? "" : this.accountName) + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        String connectionQualifiedName = ConnectionDetails.getQualifiedName(connectionCache, row);
        AtlanConnectorType type = Connection.getConnectorTypeFromQualifiedName((String)connectionQualifiedName);
        String bucketName = row.get(COL_BUCKET_NAME);
        switch (type) {
            case S3: {
                String bucketARN = row.get(COL_BUCKET_ARN);
                if (bucketARN == null || bucketARN.isEmpty() || bucketName == null || bucketName.isEmpty()) break;
                return IS3.generateQualifiedName((String)connectionQualifiedName, (String)bucketARN);
            }
            case GCS: {
                if (bucketName == null || bucketName.isEmpty()) break;
                return connectionQualifiedName + "/" + bucketName;
            }
            case ADLS: {
                String accountQN = AccountDetails.getQualifiedName(connectionCache, row);
                if (accountQN == null || accountQN.isEmpty() || bucketName == null || bucketName.isEmpty()) break;
                return accountQN + "/" + bucketName;
            }
            default: {
                log.error("Unknown connector type for object stores: {}", (Object)type);
            }
        }
        return null;
    }

    public static BucketDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        if (BucketDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String connectionQualifiedName = ConnectionDetails.getQualifiedName(connectionCache, row);
            if (BucketDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((BucketDetailsBuilder)((BucketDetailsBuilder)((BucketDetailsBuilder)((BucketDetailsBuilder)BucketDetails.getFromRow(BucketDetails.builder(), row, delim).connectionQualifiedName(connectionQualifiedName)).accountName(row.get("ACCOUNT NAME"))).name(row.get(COL_BUCKET_NAME))).arn(row.get(COL_BUCKET_ARN))).build();
            }
            return ((BucketDetailsBuilder)((BucketDetailsBuilder)((BucketDetailsBuilder)((BucketDetailsBuilder)BucketDetails.builder().connectionQualifiedName(connectionQualifiedName)).accountName(row.get("ACCOUNT NAME"))).name(row.get(COL_BUCKET_NAME))).arn(row.get(COL_BUCKET_ARN))).build();
        }
        return null;
    }

    public static void upsert(Map<String, BucketDetails> buckets, int batchSize, boolean updateOnly) {
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "bucket", batchSize);
        HashMap<String, List<String>> toClassifyS3 = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyGCS = new HashMap<String, List<String>>();
        HashMap<String, List<String>> toClassifyADLS = new HashMap<String, List<String>>();
        long totalResults = buckets.size();
        long localCount = 0L;
        try {
            block16: for (BucketDetails details : buckets.values()) {
                String connectionQualifiedName = details.getConnectionQualifiedName();
                String accountName = details.getAccountName();
                String bucketName = details.getName();
                String bucketARN = details.getArn();
                AtlanConnectorType bucketType = Connection.getConnectorTypeFromQualifiedName((String)connectionQualifiedName);
                switch (bucketType) {
                    case S3: {
                        GCSBucket toUpdate;
                        String qualifiedName;
                        if (bucketARN != null && !bucketARN.isEmpty()) {
                            if (updateOnly) {
                                qualifiedName = IS3.generateQualifiedName((String)connectionQualifiedName, (String)bucketARN);
                                try {
                                    S3Bucket.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
                                    toUpdate = ((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)S3Bucket.updater((String)qualifiedName, (String)bucketName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                    if (!details.getAtlanTags().isEmpty()) {
                                        toClassifyS3.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                    }
                                    ++localCount;
                                    if (batch.add((Asset)toUpdate) == null) continue block16;
                                    log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                                }
                                catch (NotFoundException e) {
                                    log.warn("Unable to find existing bucket \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                                }
                                catch (AtlanException e) {
                                    log.error("Unable to lookup whether bucket exists or not.", (Throwable)e);
                                }
                                break;
                            }
                            S3Bucket s3 = ((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)((S3Bucket.S3BucketBuilder)S3Bucket.creator((String)bucketName, (String)connectionQualifiedName, (String)bucketARN).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                            if (!details.getAtlanTags().isEmpty()) {
                                toClassifyS3.put(s3.getQualifiedName(), details.getAtlanTags());
                            }
                            ++localCount;
                            if (batch.add((Asset)s3) == null) continue block16;
                            log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                            break;
                        }
                        log.error("Unable to create or update an S3 bucket without an ARN: {}", (Object)details);
                        break;
                    }
                    case GCS: {
                        GCSBucket toUpdate;
                        String qualifiedName;
                        if (updateOnly) {
                            qualifiedName = GCSBucket.generateQualifiedName((String)bucketName, (String)connectionQualifiedName);
                            try {
                                GCSBucket.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
                                toUpdate = ((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)GCSBucket.updater((String)qualifiedName, (String)bucketName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                if (!details.getAtlanTags().isEmpty()) {
                                    toClassifyGCS.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                }
                                ++localCount;
                                if (batch.add((Asset)toUpdate) == null) continue block16;
                                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                            }
                            catch (NotFoundException e) {
                                log.warn("Unable to find existing bucket \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                            }
                            catch (AtlanException e) {
                                log.error("Unable to lookup whether bucket exists or not.", (Throwable)e);
                            }
                            break;
                        }
                        GCSBucket gcs = ((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)((GCSBucket.GCSBucketBuilder)GCSBucket.creator((String)bucketName, (String)connectionQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassifyGCS.put(gcs.getQualifiedName(), details.getAtlanTags());
                        }
                        ++localCount;
                        if (batch.add((Asset)gcs) == null) continue block16;
                        log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                        break;
                    }
                    case ADLS: {
                        if (accountName != null && !accountName.isEmpty()) {
                            String accountQN = ADLSAccount.generateQualifiedName((String)accountName, (String)connectionQualifiedName);
                            if (updateOnly) {
                                String qualifiedName = ADLSContainer.generateQualifiedName((String)bucketName, (String)accountQN);
                                try {
                                    ADLSContainer.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
                                    ADLSContainer toUpdate = ((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)ADLSContainer.updater((String)qualifiedName, (String)bucketName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                                    if (!details.getAtlanTags().isEmpty()) {
                                        toClassifyADLS.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                                    }
                                    ++localCount;
                                    if (batch.add((Asset)toUpdate) == null) continue block16;
                                    log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                                }
                                catch (NotFoundException e) {
                                    log.warn("Unable to find existing container \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                                }
                                catch (AtlanException e) {
                                    log.error("Unable to lookup whether container exists or not.", (Throwable)e);
                                }
                                break;
                            }
                            ADLSContainer adls = ((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)((ADLSContainer.ADLSContainerBuilder)ADLSContainer.creator((String)bucketName, (String)accountQN).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                            if (!details.getAtlanTags().isEmpty()) {
                                toClassifyADLS.put(adls.getQualifiedName(), details.getAtlanTags());
                            }
                            ++localCount;
                            if (batch.add((Asset)adls) == null) continue block16;
                            log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                            break;
                        }
                        log.error("Unable to create or update an ADLS container without an account: {}", (Object)details);
                        break;
                    }
                    default: {
                        log.error("Invalid bucket type ({}) \u2014 skipping: {}", (Object)bucketType, (Object)details);
                    }
                }
            }
            if (batch.flush() != null) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert bucket details.", (Throwable)e);
        }
        BucketDetails.appendAtlanTags(toClassifyS3, "S3Bucket");
        BucketDetails.appendAtlanTags(toClassifyGCS, "GCSBucket");
        BucketDetails.appendAtlanTags(toClassifyADLS, "ADLSContainer");
    }

    protected BucketDetails(BucketDetailsBuilder<?, ?> b) {
        super(b);
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.accountName = b.accountName;
        this.name = b.name;
        this.arn = b.arn;
    }

    public static BucketDetailsBuilder<?, ?> builder() {
        return new BucketDetailsBuilderImpl();
    }

    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getName() {
        return this.name;
    }

    public String getArn() {
        return this.arn;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketDetails)) {
            return false;
        }
        BucketDetails other = (BucketDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$arn = this.getArn();
        String other$arn = other.getArn();
        return !(this$arn == null ? other$arn != null : !this$arn.equals(other$arn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BucketDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $arn = this.getArn();
        result = result * 59 + ($arn == null ? 43 : $arn.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BucketDetails(super=" + super.toString() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", accountName=" + this.getAccountName() + ", name=" + this.getName() + ", arn=" + this.getArn() + ")";
    }

    private static final class BucketDetailsBuilderImpl
    extends BucketDetailsBuilder<BucketDetails, BucketDetailsBuilderImpl> {
        private BucketDetailsBuilderImpl() {
        }

        @Override
        protected BucketDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public BucketDetails build() {
            return new BucketDetails(this);
        }
    }

    public static abstract class BucketDetailsBuilder<C extends BucketDetails, B extends BucketDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String connectionQualifiedName;
        private String accountName;
        private String name;
        private String arn;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        public B accountName(String accountName) {
            this.accountName = accountName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B arn(String arn) {
            this.arn = arn;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BucketDetails.BucketDetailsBuilder(super=" + super.toString() + ", connectionQualifiedName=" + this.connectionQualifiedName + ", accountName=" + this.accountName + ", name=" + this.name + ", arn=" + this.arn + ")";
        }
    }
}

