/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(ConnectionDetails.class);
    protected static final String COL_CONNECTOR = "CONNECTOR";
    protected static final String COL_CONNECTION = "CONNECTION NAME";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME");
    private static final List<String> REQUIRED_EMPTY = List.of("DATABASE NAME", "SCHEMA NAME", "CONTAINER NAME", "COLUMN NAME", "ACCOUNT NAME", "BUCKET NAME", "OBJECT NAME");
    private String name;
    private AtlanConnectorType type;

    @Override
    public String getIdentity() {
        return this.type.getValue() + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        return ConnectionDetails.getQualifiedName(connectionCache, row, COL_CONNECTOR, COL_CONNECTION);
    }

    static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String connectorCol, String connectionCol) {
        ConnectionDetails connection = ConnectionDetails.getHeaderFromRow(row, connectorCol, connectionCol);
        return connectionCache.getOrDefault(connection, null);
    }

    public static ConnectionDetails getFromRow(Map<String, String> row, String delim) {
        if (ConnectionDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String type = row.get(COL_CONNECTOR);
            String name = row.get(COL_CONNECTION);
            if (ConnectionDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((ConnectionDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ConnectionDetailsBuilder)ConnectionDetails.getFromRow(ConnectionDetails.builder(), row, delim).type(AtlanConnectorType.fromValue((String)type.toLowerCase(Locale.ROOT)))).name(name)).stub(false)).build();
            }
            return ((ConnectionDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ConnectionDetailsBuilder)ConnectionDetails.builder().type(AtlanConnectorType.fromValue((String)type.toLowerCase(Locale.ROOT)))).name(name)).stub(true)).build();
        }
        return null;
    }

    static ConnectionDetails getHeaderFromRow(Map<String, String> row, String connectorCol, String connectionCol) {
        if (ConnectionDetails.getMissingFields(row, List.of(connectorCol, connectionCol)).isEmpty()) {
            return ConnectionDetails.getHeader(row.get(connectionCol), AtlanConnectorType.fromValue((String)row.get(connectorCol).toLowerCase(Locale.ROOT)));
        }
        return null;
    }

    static ConnectionDetails getHeader(String name, AtlanConnectorType type) {
        return ((ConnectionDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((ConnectionDetailsBuilder)ConnectionDetails.builder().name(name)).type(type)).stub(true)).build();
    }

    public static Map<ConnectionDetails, String> upsert(Map<String, ConnectionDetails> connections, int batchSize, boolean updateOnly) {
        HashMap<ConnectionDetails, String> cache = new HashMap<ConnectionDetails, String>();
        long totalResults = connections.size();
        long localCount = 0L;
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "Connection", batchSize);
        log.info("... looking for existing ({}) connections...", (Object)totalResults);
        try {
            for (ConnectionDetails details : connections.values()) {
                AtlanConnectorType type;
                String name = details.getName();
                ConnectionDetails header = ConnectionDetails.getHeader(name, type = details.getType());
                if (cache.containsKey(header)) continue;
                try {
                    ConnectionDetails.findAndCache(cache, name, type);
                    Connection toUpdate = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.updater((String)((String)cache.get(header)), (String)name).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).build();
                    ++localCount;
                    if (batch.add((Asset)toUpdate) == null) continue;
                    log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                }
                catch (NotFoundException e) {
                    if (!updateOnly) {
                        try {
                            ArrayList<String> leftOverGroups = new ArrayList<String>();
                            ArrayList<String> ownerRoles = new ArrayList<String>();
                            List<String> ownerUsers = details.getOwnerUsers();
                            List<String> ownerGroups = details.getOwnerGroups();
                            if (!ownerGroups.isEmpty()) {
                                for (String groupName : ownerGroups) {
                                    if (groupName.startsWith("$")) {
                                        ownerRoles.add(Atlan.getDefaultClient().getRoleCache().getIdForName(groupName));
                                        continue;
                                    }
                                    leftOverGroups.add(groupName);
                                }
                            }
                            if (leftOverGroups.isEmpty() && ownerRoles.isEmpty() && ownerUsers.isEmpty()) {
                                ownerRoles.add(Atlan.getDefaultClient().getRoleCache().getIdForName("$admin"));
                            }
                            Connection toCreate = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator((String)header.getName(), (AtlanConnectorType)header.getType(), ownerRoles, leftOverGroups, ownerUsers).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).build();
                            ++localCount;
                            AssetMutationResponse response = batch.add((Asset)toCreate);
                            if (response != null) {
                                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                            }
                            ConnectionDetails.cacheConnections(cache, response);
                            Thread.sleep(2000L);
                        }
                        catch (AtlanException | InterruptedException inner) {
                            log.error("Unexpected exception while trying to create connection ({}) or batch: {}", new Object[]{header, batch, inner});
                        }
                        continue;
                    }
                    log.warn("Unable to find existing connection \u2014 skipping: {}/{}", (Object)type, (Object)name);
                }
            }
            AssetMutationResponse response = batch.flush();
            if (response != null) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
            ConnectionDetails.cacheConnections(cache, response);
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert connection details.", (Throwable)e);
        }
        for (String qualifiedName : cache.values()) {
            try {
                Connection.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
            }
            catch (AtlanException e) {
                log.error("Unable to access connection: {}", (Object)qualifiedName, (Object)e);
            }
        }
        return cache;
    }

    public static void findAndCache(Map<ConnectionDetails, String> cache, String name, AtlanConnectorType type) throws AtlanException {
        ConnectionDetails header = ConnectionDetails.getHeader(name, type);
        if (!cache.containsKey(header)) {
            List found = Connection.findByName((String)name, (AtlanConnectorType)type);
            if (found.size() == 1) {
                log.info("...... found: {} ({})", (Object)name, (Object)((Connection)found.get(0)).getQualifiedName());
                cache.put(header, ((Connection)found.get(0)).getQualifiedName());
            } else if (found.size() > 1) {
                log.warn("...... found multiple connections with name {} \u2014 using only the first: {}", (Object)name, (Object)found);
                cache.put(header, ((Connection)found.get(0)).getQualifiedName());
            }
        }
    }

    private static void cacheConnections(Map<ConnectionDetails, String> cache, AssetMutationResponse response) {
        if (response != null) {
            List results = response.getCreatedAssets();
            for (Asset created : results) {
                if (!(created instanceof Connection)) continue;
                Connection connection = (Connection)created;
                cache.put(ConnectionDetails.getHeader(connection.getName(), connection.getConnectorType()), connection.getQualifiedName());
            }
        }
    }

    protected ConnectionDetails(ConnectionDetailsBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.type = b.type;
    }

    public static ConnectionDetailsBuilder<?, ?> builder() {
        return new ConnectionDetailsBuilderImpl();
    }

    public String getName() {
        return this.name;
    }

    public AtlanConnectorType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AtlanConnectorType this$type = this.getType();
        AtlanConnectorType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConnectionDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AtlanConnectorType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ConnectionDetails(super=" + super.toString() + ", name=" + this.getName() + ", type=" + this.getType() + ")";
    }

    private static final class ConnectionDetailsBuilderImpl
    extends ConnectionDetailsBuilder<ConnectionDetails, ConnectionDetailsBuilderImpl> {
        private ConnectionDetailsBuilderImpl() {
        }

        @Override
        protected ConnectionDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ConnectionDetails build() {
            return new ConnectionDetails(this);
        }
    }

    public static abstract class ConnectionDetailsBuilder<C extends ConnectionDetails, B extends ConnectionDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String name;
        private AtlanConnectorType type;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B type(AtlanConnectorType type) {
            this.type = type;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ConnectionDetails.ConnectionDetailsBuilder(super=" + super.toString() + ", name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

