/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.loaders.models;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Database;
import com.atlan.samples.loaders.models.AssetDetails;
import com.atlan.samples.loaders.models.ConnectionDetails;
import com.atlan.util.AssetBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDetails
extends AssetDetails {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDetails.class);
    public static final String COL_DB = "DATABASE NAME";
    private static final List<String> REQUIRED = List.of("CONNECTOR", "CONNECTION NAME", "DATABASE NAME");
    private static final List<String> REQUIRED_EMPTY = List.of("SCHEMA NAME", "CONTAINER NAME", "COLUMN NAME");
    private String connectionQualifiedName;
    private String name;

    @Override
    public String getIdentity() {
        return this.connectionQualifiedName + "/" + this.name;
    }

    public static String getQualifiedName(Map<ConnectionDetails, String> connectionCache, Map<String, String> row) {
        String dbName;
        String connectionQN = ConnectionDetails.getQualifiedName(connectionCache, row);
        if (connectionQN != null && (dbName = row.get(COL_DB)) != null) {
            return connectionQN + "/" + dbName;
        }
        return null;
    }

    public static DatabaseDetails getFromRow(Map<ConnectionDetails, String> connectionCache, Map<String, String> row, String delim) {
        if (DatabaseDetails.getMissingFields(row, REQUIRED).isEmpty()) {
            String connectionQualifiedName = ConnectionDetails.getQualifiedName(connectionCache, row);
            if (DatabaseDetails.getRequiredEmptyFields(row, REQUIRED_EMPTY).isEmpty()) {
                return ((DatabaseDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((DatabaseDetailsBuilder)DatabaseDetails.getFromRow(DatabaseDetails.builder(), row, delim).connectionQualifiedName(connectionQualifiedName)).name(row.get(COL_DB))).stub(false)).build();
            }
            return ((DatabaseDetailsBuilder)((AssetDetails.AssetDetailsBuilder)((DatabaseDetailsBuilder)DatabaseDetails.builder().connectionQualifiedName(connectionQualifiedName)).name(row.get(COL_DB))).stub(true)).build();
        }
        return null;
    }

    public static void upsert(Map<String, DatabaseDetails> databases, int batchSize, boolean updateOnly) {
        AssetBatch batch = new AssetBatch(Atlan.getDefaultClient(), "Database", batchSize);
        HashMap<String, List<String>> toClassify = new HashMap<String, List<String>>();
        long totalResults = databases.size();
        long localCount = 0L;
        try {
            for (DatabaseDetails details : databases.values()) {
                String connectionQualifiedName = details.getConnectionQualifiedName();
                String databaseName = details.getName();
                if (updateOnly) {
                    String qualifiedName = Database.generateQualifiedName((String)databaseName, (String)connectionQualifiedName);
                    try {
                        Database.get((AtlanClient)Atlan.getDefaultClient(), (String)qualifiedName, (boolean)false);
                        Database toUpdate = ((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)Database.updater((String)qualifiedName, (String)databaseName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                        if (!details.getAtlanTags().isEmpty()) {
                            toClassify.put(toUpdate.getQualifiedName(), details.getAtlanTags());
                        }
                        ++localCount;
                        if (batch.add((Asset)toUpdate) == null) continue;
                        log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
                    }
                    catch (NotFoundException e) {
                        log.warn("Unable to find existing database \u2014 skipping: {}", (Object)qualifiedName, (Object)e);
                    }
                    catch (AtlanException e) {
                        log.error("Unable to lookup whether database exists or not.", (Throwable)e);
                    }
                    continue;
                }
                Database database = ((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)((Database.DatabaseBuilder)Database.creator((String)databaseName, (String)connectionQualifiedName).description(details.getDescription())).certificateStatus(details.getCertificate())).certificateStatusMessage(details.getCertificateStatusMessage())).announcementType(details.getAnnouncementType())).announcementTitle(details.getAnnouncementTitle())).announcementMessage(details.getAnnouncementMessage())).ownerUsers(details.getOwnerUsers())).ownerGroups(details.getOwnerGroups())).build();
                if (!details.getAtlanTags().isEmpty()) {
                    toClassify.put(database.getQualifiedName(), details.getAtlanTags());
                }
                ++localCount;
                if (batch.add((Asset)database) == null) continue;
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
            if (batch.flush() != null) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
        }
        catch (AtlanException e) {
            log.error("Unable to bulk-upsert database details.", (Throwable)e);
        }
        DatabaseDetails.appendAtlanTags(toClassify, "Database");
    }

    protected DatabaseDetails(DatabaseDetailsBuilder<?, ?> b) {
        super(b);
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.name = b.name;
    }

    public static DatabaseDetailsBuilder<?, ?> builder() {
        return new DatabaseDetailsBuilderImpl();
    }

    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseDetails)) {
            return false;
        }
        DatabaseDetails other = (DatabaseDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DatabaseDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DatabaseDetails(super=" + super.toString() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", name=" + this.getName() + ")";
    }

    private static final class DatabaseDetailsBuilderImpl
    extends DatabaseDetailsBuilder<DatabaseDetails, DatabaseDetailsBuilderImpl> {
        private DatabaseDetailsBuilderImpl() {
        }

        @Override
        protected DatabaseDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public DatabaseDetails build() {
            return new DatabaseDetails(this);
        }
    }

    public static abstract class DatabaseDetailsBuilder<C extends DatabaseDetails, B extends DatabaseDetailsBuilder<C, B>>
    extends AssetDetails.AssetDetailsBuilder<C, B> {
        private String connectionQualifiedName;
        private String name;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DatabaseDetails.DatabaseDetailsBuilder(super=" + super.toString() + ", connectionQualifiedName=" + this.connectionQualifiedName + ", name=" + this.name + ")";
        }
    }
}

