/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.fields.CustomMetadataField;
import com.atlan.model.search.FluentSearch;
import com.atlan.samples.reporters.AbstractReporter;
import com.atlan.samples.writers.CSVWriter;
import com.atlan.samples.writers.RowGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssetReporter
extends AbstractReporter
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(AssetReporter.class);

    public abstract FluentSearch.FluentSearchBuilder<?, ?> getAssetsToExtract(Map<String, String> var1);

    public abstract List<AtlanField> getAttributesToExtract(Map<String, String> var1);

    public List<AtlanField> getRelatedAttributesToExtract(Map<String, String> event) {
        return Collections.emptyList();
    }

    public RowGenerator getAssetToValueTranslator(Map<String, String> event) {
        return a -> {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.getStringValueForField(a, (AtlanField)Asset.QUALIFIED_NAME));
            values.add(this.getStringValueForField(a, (AtlanField)Asset.TYPE_NAME));
            for (AtlanField field : this.getAttributesToExtract(event)) {
                if (field.equals(Asset.QUALIFIED_NAME) || field.equals(Asset.TYPE_NAME)) continue;
                values.add(this.getStringValueForField(a, field));
            }
            return values;
        };
    }

    public String handleRequest(Map<String, String> event, Context context) {
        if (context != null && context.getClientContext() != null) {
            log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
            log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
        }
        this.parseParametersFromEvent(event);
        FluentSearch.FluentSearchBuilder assets = this.getAssetsToExtract(event).pageSize(Integer.valueOf(this.getBatchSize())).includesOnResults(this.getAttributesToExtract(event)).includeOnRelations((AtlanField)Asset.QUALIFIED_NAME).includesOnRelations(this.getRelatedAttributesToExtract(event));
        try (CSVWriter csv = new CSVWriter(this.getFilename());){
            List<String> headerNames = Stream.of(Asset.QUALIFIED_NAME, Asset.TYPE_NAME).map(AtlanField::getAtlanFieldName).collect(Collectors.toList());
            headerNames.addAll(this.getAttributesToExtract(event).stream().map(AssetReporter::getHeaderForField).collect(Collectors.toList()));
            csv.writeHeader(headerNames);
            long start = System.currentTimeMillis();
            csv.streamAssets(assets.stream(true), this.getAssetToValueTranslator(event), assets.count(), this.getBatchSize());
            long finish = System.currentTimeMillis();
            log.info("Total time taken: {} ms", (Object)(finish - start));
        }
        catch (AtlanException e) {
            log.error("Unable to stream assets.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to create or write to file: {}", (Object)this.getFilename());
        }
        return this.getFilename();
    }

    private static String getHeaderForField(AtlanField field) {
        if (field instanceof CustomMetadataField) {
            CustomMetadataField cm = (CustomMetadataField)field;
            return cm.getSetName() + "::" + cm.getAttributeName();
        }
        return field.getAtlanFieldName();
    }

    public static Map<String, String> envVarsAsEvent() {
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("DELIMITER")) {
            event.put("DELIMITER", "|");
        }
        return event;
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            this.setFilenameWithPrefix(event, "asset-report", "csv");
        }
    }
}

