/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import co.elastic.clients.elasticsearch._types.SortOrder;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.Link;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.FluentSearch;
import com.atlan.samples.reporters.AbstractReporter;
import com.atlan.samples.writers.ExcelWriter;
import com.atlan.samples.writers.S3Writer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class SlackDiscussionReporter
extends AbstractReporter
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(SlackDiscussionReporter.class);
    private static final Map<String, String> SLACK_DISCUSSIONS = SlackDiscussionReporter.createSlackDiscussionHeader();
    private static final Map<String, Long> assetToSlackDiscussions = new ConcurrentHashMap<String, Long>();
    private static final Map<String, IAsset> guidToLinkedAsset = new ConcurrentHashMap<String, IAsset>();

    public static void main(String[] args) {
        SlackDiscussionReporter sdr = new SlackDiscussionReporter();
        sdr.handleRequest(System.getenv(), null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            this.setFilenameWithPrefix(event, "slack-discussion-report");
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            log.info("Creating Excel file (streaming)...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            this.parseParametersFromEvent(event);
            ExcelWriter xlsx = new ExcelWriter(this.getBatchSize());
            Sheet assets = xlsx.createSheet("Slack discussions");
            xlsx.addHeader(assets, SLACK_DISCUSSIONS);
            this.getSlackDiscussions(xlsx, assets);
            if (this.getBucket() != null) {
                S3Client s3Client = (S3Client)((S3ClientBuilder)S3Client.builder().region(this.getRegion())).build();
                S3Writer s3 = new S3Writer(s3Client);
                s3.putExcelFile(xlsx.asByteArray(), this.getBucket(), this.getFilename());
            } else {
                log.info("Writing report to file: {}", (Object)this.getFilename());
                xlsx.create(this.getFilename());
            }
        }
        catch (AtlanException e) {
            log.error("Failed to retrieve asset details from: {}", (Object)Atlan.getBaseUrl(), (Object)e);
            System.exit(1);
        }
        catch (IOException e) {
            log.error("Failed to write Excel file to: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }

    void getSlackDiscussions(ExcelWriter xlsx, Sheet sheet) throws AtlanException {
        FluentSearch.FluentSearchBuilder builder = Link.select().pageSize(Integer.valueOf(this.getBatchSize())).sort(Asset.GUID.order(SortOrder.Asc)).includeOnResults((AtlanField)Link.ASSET).includeOnResults((AtlanField)Link.LINK).includeOnResults((AtlanField)Link.REFERENCE).includeOnRelations((AtlanField)Asset.QUALIFIED_NAME).includeOnRelations((AtlanField)Asset.TYPE_NAME).includeOnRelations((AtlanField)Asset.NAME);
        long totalResults = builder.count();
        AtomicLong count = new AtomicLong(0L);
        log.info("Investigating {} linked resources in {} in batches of: {}", new Object[]{totalResults, Atlan.getBaseUrl(), this.getBatchSize()});
        builder.stream(true).filter(a -> a instanceof Link).forEach(l -> {
            Link link;
            long localCount = count.getAndIncrement();
            if (localCount % (long)this.getBatchSize() == 0L) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalResults, Math.round((double)localCount / (double)totalResults * 100.0)});
            }
            if ((link = (Link)l).getAsset() != null) {
                String assetGuid = link.getAsset().getGuid();
                String url = link.getLink();
                if (url.contains("slack.com")) {
                    if (!assetToSlackDiscussions.containsKey(assetGuid)) {
                        assetToSlackDiscussions.put(assetGuid, 0L);
                    }
                    assetToSlackDiscussions.put(assetGuid, assetToSlackDiscussions.get(assetGuid) + 1L);
                    guidToLinkedAsset.put(assetGuid, link.getAsset());
                }
            }
        });
        for (Map.Entry<String, Long> entry : assetToSlackDiscussions.entrySet()) {
            String assetGuid = entry.getKey();
            Long linkCount = entry.getValue();
            IAsset asset = guidToLinkedAsset.get(assetGuid);
            if (asset == null) continue;
            xlsx.appendRow(sheet, List.of(ExcelWriter.DataCell.of(asset.getUniqueAttributes().getQualifiedName()), ExcelWriter.DataCell.of(asset.getTypeName()), ExcelWriter.DataCell.of(asset.getName()), ExcelWriter.DataCell.of(linkCount), ExcelWriter.DataCell.of(SlackDiscussionReporter.getAssetLink(assetGuid))));
        }
    }

    static Map<String, String> createSlackDiscussionHeader() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Qualified name", "Unique name of the asset");
        map.put("Type", "Type of asset");
        map.put("Name", "Name of the asset");
        map.put("Slack", "Number of discussions through Slack linked to this asset");
        map.put("Link", "Link to the detailed asset within Atlan");
        return map;
    }
}

