/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.reporters;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.AtlanUser;
import com.atlan.model.admin.GroupResponse;
import com.atlan.samples.reporters.AbstractReporter;
import com.atlan.samples.writers.ExcelWriter;
import com.atlan.samples.writers.S3Writer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class UserReporter
extends AbstractReporter
implements RequestHandler<Map<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(UserReporter.class);
    private static final Map<String, String> USER_REPORT_HEADERS = UserReporter.createUserDetailsReportHeaders();
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);

    public static void main(String[] args) {
        UserReporter ur = new UserReporter();
        HashMap<String, String> event = new HashMap<String, String>(System.getenv());
        if (!event.containsKey("DELIMITER")) {
            event.put("DELIMITER", "|");
        }
        ur.handleRequest(event, null);
    }

    @Override
    protected void parseParametersFromEvent(Map<String, String> event) {
        super.parseParametersFromEvent(event);
        if (event != null) {
            this.setFilenameWithPrefix(event, "user-details-report");
        }
    }

    public String handleRequest(Map<String, String> event, Context context) {
        try {
            this.parseParametersFromEvent(event);
            log.info("Retrieving user details for tenant: {}", (Object)Atlan.getBaseUrl());
            List users = AtlanUser.list();
            users.sort(Comparator.comparing(AtlanUser::getFirstName, stringComparator).thenComparing(AtlanUser::getLastName, stringComparator));
            log.info("Creating Excel file (streaming)...");
            if (context != null && context.getClientContext() != null) {
                log.debug(" ... client environment: {}", (Object)context.getClientContext().getEnvironment());
                log.debug(" ... client custom: {}", (Object)context.getClientContext().getCustom());
            }
            ExcelWriter xlsx = new ExcelWriter(this.getBatchSize());
            Sheet userinfo = xlsx.createSheet("User Details");
            xlsx.addHeader(userinfo, USER_REPORT_HEADERS);
            this.addUserDetailRecords(xlsx, userinfo, users);
            if (this.getBucket() != null) {
                log.info("Putting file: {} into S3", (Object)this.getFilename());
                S3Client s3Client = (S3Client)((S3ClientBuilder)S3Client.builder().region(this.getRegion())).build();
                S3Writer s3 = new S3Writer(s3Client);
                s3.putExcelFile(xlsx.asByteArray(), this.getBucket(), this.getFilename());
            } else {
                log.info("Writing report to file: {}", (Object)this.getFilename());
                xlsx.create(this.getFilename());
            }
        }
        catch (AtlanException e) {
            log.error("Failed to retrieve asset details from: {}", (Object)Atlan.getBaseUrl(), (Object)e);
            System.exit(1);
        }
        catch (IOException e) {
            log.error("Failed to write Excel file to: {}", (Object)this.getFilename(), (Object)e);
            System.exit(1);
        }
        return this.getFilename();
    }

    static Map<String, String> createUserDetailsReportHeaders() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("GUID", "Unique identifier for the user.");
        map.put("Username", "Unique username for the user.");
        map.put("First Name", "First name of the user.");
        map.put("Last Name", "Last name of the user.");
        map.put("Email", "Email address of the user.");
        map.put("Verified", "When true, the user's email has been verified.");
        map.put("Enabled", "When true, the user is enabled and allowed to log in to Atlan. When false, the user will be prevented from logging in to Atlan.");
        map.put("Role", "User roles, including login roles and custom roles emerging from persona associations.");
        map.put("Logins", "Number of successful logins by the user account.");
        map.put("Last Login", "Timestamp of the last successful login for the user.");
        map.put("Groups", "Atlan Groups the user is part of.");
        map.put("Personas", "Personas the user is part, directly and by virtue of group membership.");
        return map;
    }

    void addUserDetailRecords(ExcelWriter xlsx, Sheet sheet, List<AtlanUser> users) throws AtlanException {
        for (AtlanUser user : users) {
            if (user == null) continue;
            Long userLastLoginTime = user.getLastLoginTime();
            String reportLastLoginTime = "";
            if (userLastLoginTime != null && userLastLoginTime > 0L) {
                LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(userLastLoginTime), ZoneOffset.UTC);
                reportLastLoginTime = ldt.format(DateTimeFormatter.ISO_DATE_TIME);
            }
            List roles = user.getRoles();
            roles.remove("default-roles-default");
            String reportRoles = String.join((CharSequence)"|", roles).replace("$", "");
            List groupNames = Collections.emptyList();
            try {
                List groupList;
                GroupResponse groupResponse = user.fetchGroups();
                if (groupResponse != null && (groupList = groupResponse.getRecords()) != null) {
                    groupNames = groupList.stream().map(AtlanGroup::getAlias).collect(Collectors.toList());
                }
            }
            catch (AtlanException e) {
                log.warn("Failed to retrieve group information for user {}.", (Object)user.getUsername(), (Object)e);
            }
            String reportGroupNames = String.join((CharSequence)"|", groupNames);
            List personaNames = Collections.emptyList();
            try {
                SortedSet userPersonas = user.getPersonas();
                if (userPersonas != null) {
                    personaNames = userPersonas.stream().map(AtlanUser.Persona::getDisplayName).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                log.warn("Failed to retrieve persona details for user {}.", (Object)user.getUsername(), (Object)e);
            }
            String reportPersonaNames = String.join((CharSequence)"|", personaNames);
            xlsx.appendRow(sheet, List.of(ExcelWriter.DataCell.of(user.getId()), ExcelWriter.DataCell.of(user.getUsername()), ExcelWriter.DataCell.of(user.getFirstName()), ExcelWriter.DataCell.of(user.getLastName()), ExcelWriter.DataCell.of(user.getEmail()), ExcelWriter.DataCell.of(user.getEmailVerified()), ExcelWriter.DataCell.of(user.getEnabled()), ExcelWriter.DataCell.of(reportRoles), ExcelWriter.DataCell.of(user.getLoginEvents().size()), ExcelWriter.DataCell.of(reportLastLoginTime), ExcelWriter.DataCell.of(reportGroupNames), ExcelWriter.DataCell.of(reportPersonaNames)));
        }
    }
}

