/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.samples.writers;

import com.atlan.model.assets.Asset;
import com.atlan.samples.writers.RowGenerator;
import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import de.siegmar.fastcsv.writer.QuoteStrategy;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVWriter
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CSVWriter.class);
    private final CsvWriter writer;

    public CSVWriter(String path) throws IOException {
        this(path, ',');
    }

    public CSVWriter(String path, char fieldSeparator) throws IOException {
        this.writer = CsvWriter.builder().fieldSeparator(fieldSeparator).quoteCharacter('\"').quoteStrategy(QuoteStrategy.REQUIRED).lineDelimiter(LineDelimiter.PLATFORM).build((Writer)new ThreadSafeWriter(path));
    }

    public void writeHeader(Iterable<String> values) {
        this.writer.writeRow(values);
    }

    public void streamAssets(Stream<Asset> stream, RowGenerator valuesForRow, long totalAssetCount, int pageSize) {
        log.info("Extracting a total of {} assets...", (Object)totalAssetCount);
        AtomicLong count = new AtomicLong(0L);
        ConcurrentHashMap map = new ConcurrentHashMap();
        stream.forEach(a -> {
            String duplicate;
            long localCount = count.getAndIncrement();
            if (localCount % (long)pageSize == 0L) {
                log.info(" ... processed {}/{} ({}%)", new Object[]{localCount, totalAssetCount, Math.round((double)localCount / (double)totalAssetCount * 100.0)});
            }
            if ((duplicate = (String)((Object)map.put(a.getGuid(), a.getTypeName() + "::" + a.getGuid()))) != null) {
                log.warn("Hit a duplicate asset entry \u2014 there could be page skew: {}", (Object)duplicate);
            }
            Iterable<String> values = valuesForRow.valuesFromAsset((Asset)a);
            CsvWriter csvWriter = this.writer;
            synchronized (csvWriter) {
                this.writer.writeRow(values);
            }
        });
        log.info("Total unique assets extracted: {}", (Object)map.size());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static final class ThreadSafeWriter
    extends Writer
    implements Closeable {
        private final BufferedWriter writer;

        public ThreadSafeWriter(String filePath) throws IOException {
            this.writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
        }

        @Override
        public synchronized void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
        }

        @Override
        public synchronized void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.writer.close();
        }
    }
}

