/*
 * Decompiled with CFR 0.152.
 */
package com.probable.guacamole.typedefs;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanAttributeType;
import com.atlan.model.enums.AtlanCustomAttributeCardinality;
import com.atlan.model.enums.RelationshipCategory;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.RelationshipDef;
import com.atlan.model.typedefs.RelationshipEndDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.probable.guacamole.ExtendedModelGenerator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefCreator
extends ExtendedModelGenerator {
    private static final Logger log = LoggerFactory.getLogger(TypeDefCreator.class);
    static final String STRUCT_DEF_NAME = "GuacamoleStruct";
    static final String ENUM_DEF_NAME = "GuacamoleTemperature";
    static final String ENTITY_DEF_PARENT_NAME = "GuacamoleTable";
    static final String ENTITY_DEF_CHILD_NAME = "GuacamoleColumn";
    static final String RELATIONSHIP_DEF_NAME = "GuacamoleTableColumns";

    public static void main(String[] args) {
        TypeDefCreator tdc = new TypeDefCreator();
        tdc.createEnumDef();
        tdc.createStructDef();
        tdc.createEntityDef();
        tdc.createRelationshipDef();
        tdc.updateEntityDef();
    }

    void createStructDef() {
        List<AttributeDef> attrs = List.of(AttributeDef.creator((String)"guacamoleComplexOne", (AtlanAttributeType)AtlanAttributeType.STRING).build(), AttributeDef.creator((String)"guacamoleComplexTwo", (AtlanAttributeType)AtlanAttributeType.LONG).build());
        StructDef sd = ((StructDef.StructDefBuilder)((StructDef.StructDefBuilder)StructDef.creator((String)STRUCT_DEF_NAME, attrs).serviceType("guacamole")).description("Complex embedded attributes for Guacamole objects.")).build();
        try {
            TypeDefResponse response = Atlan.getDefaultClient().typeDefs._create((TypeDef)sd);
            log.info("Created structDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create StructDef.", (Throwable)e);
        }
    }

    void createEnumDef() {
        EnumDef enumDef = ((EnumDef.EnumDefBuilder)((EnumDef.EnumDefBuilder)EnumDef.creator((String)ENUM_DEF_NAME, List.of("Hot", "Mild", "Cold")).serviceType("guacamole")).description("Valid values for the temperature of a Guacamole table.")).build();
        try {
            EnumDef response = enumDef.create();
            log.info("Created enumDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create EnumDef.", (Throwable)e);
        }
    }

    void createEntityDef() {
        TypeDefResponse response;
        List<AttributeDef> attrs = List.of(AttributeDef.creator((String)"guacamoleSize", (AtlanAttributeType)AtlanAttributeType.LONG).description("Consolidated quantification metric spanning number of columns, rows, and sparsity of population.").build(), AttributeDef.creator((String)"guacamoleTemperature", (AtlanAttributeType)AtlanAttributeType.ENUM, (String)ENUM_DEF_NAME, (AtlanCustomAttributeCardinality)AtlanCustomAttributeCardinality.SINGLE).description("Rough measure of the IOPS allocated to the table's processing.").build());
        EntityDef ed = ((EntityDef.EntityDefBuilder)((EntityDef.EntityDefBuilder)EntityDef.creator((String)ENTITY_DEF_PARENT_NAME, attrs).serviceType("guacamole")).description("Specialized form of a table specific to Guacamole.")).superTypes(List.of("Table")).build();
        try {
            response = Atlan.getDefaultClient().typeDefs._create((TypeDef)ed);
            log.info("Created entityDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create EntityDef.", (Throwable)e);
        }
        attrs = List.of(AttributeDef.creator((String)"guacamoleWidth", (AtlanAttributeType)AtlanAttributeType.LONG).description("Maximum size of a Guacamole column.").build(), AttributeDef.creator((String)"guacamoleConceptualized", (AtlanAttributeType)AtlanAttributeType.DATE).description("Time (epoch) when this column was imagined, in milliseconds.").build());
        ed = ((EntityDef.EntityDefBuilder)((EntityDef.EntityDefBuilder)EntityDef.creator((String)ENTITY_DEF_CHILD_NAME, attrs).serviceType("guacamole")).description("Specialized form of a column specific to Guacamole.")).superTypes(List.of("Column")).build();
        try {
            response = Atlan.getDefaultClient().typeDefs._create((TypeDef)ed);
            log.info("Created entityDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create EntityDef.", (Throwable)e);
        }
    }

    void createRelationshipDef() {
        List<AttributeDef> attrs = List.of(AttributeDef.creator((String)"guacamolePartition", (AtlanAttributeType)AtlanAttributeType.STRING).description("Table partition within which the column exists.").build());
        RelationshipEndDef one = RelationshipEndDef.creator((String)"guacamoleColumns", (String)ENTITY_DEF_PARENT_NAME, (boolean)true, (AtlanCustomAttributeCardinality)AtlanCustomAttributeCardinality.SET).description("Specialized columns contained within this specialized table.").build();
        RelationshipEndDef two = RelationshipEndDef.creator((String)"guacamoleTable", (String)ENTITY_DEF_CHILD_NAME, (boolean)false, (AtlanCustomAttributeCardinality)AtlanCustomAttributeCardinality.SINGLE).description("Specialized table that contains this specialized column.").build();
        RelationshipDef rd = ((RelationshipDef.RelationshipDefBuilder)((RelationshipDef.RelationshipDefBuilder)RelationshipDef.creator((String)RELATIONSHIP_DEF_NAME, (RelationshipEndDef)one, (RelationshipEndDef)two, attrs).serviceType("guacamole")).relationshipCategory(RelationshipCategory.AGGREGATION).description("Parent-child relationship between specialized table and its columns.")).build();
        try {
            TypeDefResponse response = Atlan.getDefaultClient().typeDefs._create((TypeDef)rd);
            log.info("Created relationshipDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to create RelationshipDef.", (Throwable)e);
        }
    }

    void updateEntityDef() {
        try {
            EntityDef parent = (EntityDef)Atlan.getDefaultClient().typeDefs.get(ENTITY_DEF_PARENT_NAME);
            parent = ((EntityDef.EntityDefBuilder)((EntityDef.EntityDefBuilder)parent.toBuilder().attributeDef(AttributeDef.creator((String)"guacamoleArchived", (AtlanAttributeType)AtlanAttributeType.BOOLEAN).description("Whether this table is currently archived (true) or not (false).").build())).typeVersion("1.1")).build();
            TypeDefResponse response = Atlan.getDefaultClient().typeDefs._update((TypeDef)parent);
            log.info("Updated entityDef: {}", (Object)response);
        }
        catch (AtlanException e) {
            log.error("Failed to update entityDef.", (Throwable)e);
        }
    }
}

