/*
 * Decompiled with CFR 0.152.
 */
package com.atlan;

import com.atlan.exception.ApiConnectionException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class Atlan {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 80000;
    public static final String VERSION = "0.0.2";
    public static volatile String clientId;
    public static volatile boolean enableTelemetry;
    public static volatile String partnerId;
    private static volatile int connectTimeout;
    private static volatile int readTimeout;
    private static volatile int maxNetworkRetries;
    private static volatile String apiToken;
    private static volatile String apiBase;
    private static volatile Proxy connectionProxy;
    private static volatile PasswordAuthentication proxyCredential;
    private static volatile Map<String, String> appInfo;

    public static void setBaseUrl(String baseURL) {
        apiBase = baseURL;
    }

    public static String getBaseUrl() throws ApiConnectionException {
        if (apiBase == null) {
            throw new ApiConnectionException("No base URL is configured. You must first use Atlan.setBaseUrl() before making an API call.");
        }
        return apiBase;
    }

    public static String getBaseUrlSafe() {
        return apiBase;
    }

    public static void setApiToken(String token) {
        apiToken = token;
    }

    public static String getApiToken() {
        return apiToken;
    }

    public static void setConnectionProxy(Proxy proxy) {
        connectionProxy = proxy;
    }

    public static Proxy getConnectionProxy() {
        return connectionProxy;
    }

    public static int getConnectTimeout() {
        if (connectTimeout == -1) {
            return 30000;
        }
        return connectTimeout;
    }

    public static void setConnectTimeout(int timeout) {
        connectTimeout = timeout;
    }

    public static int getReadTimeout() {
        if (readTimeout == -1) {
            return 80000;
        }
        return readTimeout;
    }

    public static void setReadTimeout(int timeout) {
        readTimeout = timeout;
    }

    public static int getMaxNetworkRetries() {
        return maxNetworkRetries;
    }

    public static void setMaxNetworkRetries(int numRetries) {
        maxNetworkRetries = numRetries;
    }

    public static void setProxyCredential(PasswordAuthentication auth) {
        proxyCredential = auth;
    }

    public static PasswordAuthentication getProxyCredential() {
        return proxyCredential;
    }

    public static void setAppInfo(String name) {
        Atlan.setAppInfo(name, null, null, null);
    }

    public static void setAppInfo(String name, String version) {
        Atlan.setAppInfo(name, version, null, null);
    }

    public static void setAppInfo(String name, String version, String url) {
        Atlan.setAppInfo(name, version, url, null);
    }

    public static void setAppInfo(String name, String version, String url, String partnerId) {
        if (appInfo == null) {
            appInfo = new HashMap<String, String>();
        }
        appInfo.put("name", name);
        appInfo.put("version", version);
        appInfo.put("url", url);
        appInfo.put("partner_id", partnerId);
    }

    public static Map<String, String> getAppInfo() {
        return appInfo;
    }

    static {
        enableTelemetry = true;
        connectTimeout = -1;
        readTimeout = -1;
        maxNetworkRetries = 10;
        apiToken = null;
        apiBase = null;
        connectionProxy = null;
        proxyCredential = null;
        appInfo = null;
    }
}

