/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.Entity;
import com.atlan.model.core.EntityMutationResponse;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.net.ApiResource;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class EntityBulkEndpoint {
    private static final String endpoint = "/api/meta/entity/bulk";

    public static EntityMutationResponse upsert(Entity value, boolean replaceClassifications, boolean replaceCustomMetadata) throws AtlanException {
        return EntityBulkEndpoint.upsert(Collections.singletonList(value), replaceClassifications, replaceCustomMetadata);
    }

    public static EntityMutationResponse upsert(List<Entity> values, boolean replaceClassifications, boolean replaceCustomMetadata) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s?replaceClassifications=%s&replaceBusinessAttributes=%s&overwriteBusinessAttributes=%s", endpoint, replaceClassifications, replaceCustomMetadata, replaceCustomMetadata));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        return ApiResource.request(ApiResource.RequestMethod.POST, url, beq, EntityMutationResponse.class, null);
    }

    public static EntityMutationResponse delete(String guid, AtlanDeleteType deleteType) throws AtlanException {
        return EntityBulkEndpoint.delete(Collections.singletonList(guid), deleteType);
    }

    public static EntityMutationResponse delete(List<String> guids, AtlanDeleteType deleteType) throws AtlanException {
        if (guids != null) {
            StringBuilder guidList = new StringBuilder();
            for (String guid : guids) {
                if (guid == null) continue;
                guidList.append("guid=").append(guid).append("&");
            }
            if (guidList.length() > 0) {
                guidList.setLength(guidList.length() - 1);
                String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s?%s&deleteType=%s", endpoint, guidList, deleteType));
                return ApiResource.request(ApiResource.RequestMethod.DELETE, url, "", EntityMutationResponse.class, null);
            }
        }
        throw new InvalidRequestException("Insufficient information provided to delete entities: no GUID provided.", "guid", "ATLAN-JAVA-CLIENT-400", 400, null);
    }

    static class BulkEntityRequest
    extends AtlanObject {
        List<Entity> entities;

        @Generated
        protected BulkEntityRequest(BulkEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entities = b.entities;
        }

        @Generated
        public static BulkEntityRequestBuilder<?, ?> builder() {
            return new BulkEntityRequestBuilderImpl();
        }

        @Generated
        public List<Entity> getEntities() {
            return this.entities;
        }

        @Generated
        public void setEntities(List<Entity> entities) {
            this.entities = entities;
        }

        @Override
        @Generated
        public String toString() {
            return "EntityBulkEndpoint.BulkEntityRequest(entities=" + this.getEntities() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkEntityRequest)) {
                return false;
            }
            BulkEntityRequest other = (BulkEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Entity> this$entities = this.getEntities();
            List<Entity> other$entities = other.getEntities();
            return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Entity> $entities = this.getEntities();
            result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
            return result;
        }

        @Generated
        private static final class BulkEntityRequestBuilderImpl
        extends BulkEntityRequestBuilder<BulkEntityRequest, BulkEntityRequestBuilderImpl> {
            @Generated
            private BulkEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected BulkEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BulkEntityRequest build() {
                return new BulkEntityRequest(this);
            }
        }

        @Generated
        public static abstract class BulkEntityRequestBuilder<C extends BulkEntityRequest, B extends BulkEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<Entity> entities;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B entities(List<Entity> entities) {
                this.entities = entities;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "EntityBulkEndpoint.BulkEntityRequest.BulkEntityRequestBuilder(super=" + super.toString() + ", entities=" + this.entities + ")";
            }
        }
    }
}

