/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.cache.CustomMetadataCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.core.EntityResponse;
import com.atlan.net.ApiResource;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityGuidEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGuidEndpoint.class);
    private static final String endpoint = "/api/meta/entity/guid/";

    public static EntityResponse retrieve(String guid, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s?ignoreRelationships=%s&minExtInfo=%s", endpoint, ApiResource.urlEncodeId(guid), ignoreRelationships, minExtInfo));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", EntityResponse.class, null);
    }

    public static void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        String cmId = CustomMetadataCache.getIdForName(cmName);
        if (cmId != null) {
            if (values != null) {
                String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s/businessmetadata?isOverwrite=false", endpoint, ApiResource.urlEncodeId(guid)));
                CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, values.getAttributes(), true);
                ApiResource.request(ApiResource.RequestMethod.POST, url, cmur, null, null);
            }
        } else {
            throw new InvalidRequestException("No custom metadata found with the provided name: " + cmName, "customMetadataName", "ATLAN-JAVA-CLIENT-400-030", 400, null);
        }
    }

    public static void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        String cmId = CustomMetadataCache.getIdForName(cmName);
        if (cmId != null) {
            if (values != null) {
                String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s/businessmetadata/%s", endpoint, ApiResource.urlEncodeId(guid), ApiResource.urlEncodeId(cmId)));
                CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, values.getAttributes(), false);
                ApiResource.request(ApiResource.RequestMethod.POST, url, cmur, null, null);
            }
        } else {
            throw new InvalidRequestException("No custom metadata found with the provided name: " + cmName, "customMetadataName", "ATLAN-JAVA-CLIENT-400-030", 400, null);
        }
    }

    public static void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        String cmId = CustomMetadataCache.getIdForName(cmName);
        if (cmId == null) {
            throw new InvalidRequestException("No custom metadata found with the provided name: " + cmName, "customMetadataName", "ATLAN-JAVA-CLIENT-400-030", 400, null);
        }
        Map<String, Object> map = CustomMetadataCache.getEmptyAttributes(cmName);
        AtlanObject cma = ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)CustomMetadataAttributes.builder().attributes(map)).build();
        EntityGuidEndpoint.updateCustomMetadataAttributes(guid, cmName, (CustomMetadataAttributes)cma);
    }

    static class CustomMetadataUpdateRequest
    extends AtlanObject {
        private final transient boolean includeName;
        private final transient String name;
        private final transient Map<String, Object> attributes;

        public CustomMetadataUpdateRequest(String name, Map<String, Object> attributes, boolean includeName) {
            this.name = name;
            this.attributes = attributes;
            this.includeName = includeName;
        }

        @Override
        public String toJson() {
            LinkedHashMap<String, Object> businessMetadataAttributes = new LinkedHashMap<String, Object>();
            try {
                CustomMetadataCache.getIdMapFromNameMap(this.name, this.attributes, businessMetadataAttributes);
                if (this.includeName) {
                    LinkedHashMap<String, LinkedHashMap<String, Object>> wrapped = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                    String cmId = CustomMetadataCache.getIdForName(this.name);
                    wrapped.put(cmId, businessMetadataAttributes);
                    return Serde.mapper.writeValueAsString(wrapped);
                }
                return Serde.mapper.writeValueAsString(businessMetadataAttributes);
            }
            catch (AtlanException | JsonProcessingException e) {
                log.error("Unable to serialize custom metadata for '{}' with: {}", new Object[]{this.name, this.attributes, e});
                return null;
            }
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomMetadataUpdateRequest)) {
                return false;
            }
            CustomMetadataUpdateRequest other = (CustomMetadataUpdateRequest)o;
            return other.canEqual(this);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomMetadataUpdateRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

