/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.cache.ClassificationCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.Classification;
import com.atlan.model.core.Entity;
import com.atlan.model.core.EntityMutationResponse;
import com.atlan.model.core.EntityResponse;
import com.atlan.net.ApiResource;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUniqueAttributesEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityUniqueAttributesEndpoint.class);
    private static final String endpoint = "/api/meta/entity/uniqueAttribute/type/";

    public static EntityResponse retrieve(String typeName, String qualifiedName, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s&ignoreRelationships=%s&minExtInfo=%s", endpoint, ApiResource.urlEncodeId(typeName), ApiResource.urlEncodeId(qualifiedName), ignoreRelationships, minExtInfo));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", EntityResponse.class, null);
    }

    public static EntityMutationResponse updateAttributes(String typeName, String qualifiedName, Entity value) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s", endpoint, typeName, ApiResource.urlEncode(qualifiedName)));
        AtlanObject seq = ((SingleEntityRequest.SingleEntityRequestBuilder)SingleEntityRequest.builder().entity(value)).build();
        return ApiResource.request(ApiResource.RequestMethod.PUT, url, seq, EntityMutationResponse.class, null);
    }

    public static void addClassifications(String typeName, String qualifiedName, List<String> classificationNames) throws AtlanException {
        EntityUniqueAttributesEndpoint.addClassifications(typeName, qualifiedName, classificationNames, true, true, false);
    }

    public static void addClassifications(String typeName, String qualifiedName, List<String> classificationNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        for (String classificationName : classificationNames) {
            classifications.add((Classification)((Classification.ClassificationBuilder)((Classification.ClassificationBuilder)((Classification.ClassificationBuilder)((Classification.ClassificationBuilder)Classification.builder().typeName(classificationName)).propagate(propagate)).removePropagationsOnEntityDelete(removePropagationsOnDelete)).restrictPropagationThroughLineage(restrictLineagePropagation)).build());
        }
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s/classifications?attr:qualifiedName=%s", endpoint, typeName, ApiResource.urlEncode(qualifiedName)));
        ApiResource.request(ApiResource.RequestMethod.POST, url, new ClassificationList(classifications), null, null);
    }

    public static void removeClassification(String typeName, String qualifiedName, String classificationName, boolean idempotent) throws AtlanException {
        String classificationId = ClassificationCache.getIdForName(classificationName);
        if (classificationId != null) {
            String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s%s/classification/%s?attr:qualifiedName=%s", endpoint, typeName, classificationId, ApiResource.urlEncode(qualifiedName)));
            try {
                ApiResource.request(ApiResource.RequestMethod.DELETE, url, "", null, null);
            }
            catch (InvalidRequestException e) {
                if (idempotent && e.getMessage().equals("ATLAS-400-00-06D")) {
                    log.debug("Attempted to remove classification '{}' from asset that does not have the classification, ignoring: {}", (Object)classificationName, (Object)qualifiedName);
                }
                throw e;
            }
        } else {
            throw new InvalidRequestException("No classification found with the provided name: " + classificationName, "classificationName", "ATLAN-JAVA-CLIENT-400-020", 400, null);
        }
    }

    static class SingleEntityRequest
    extends AtlanObject {
        Entity entity;

        @Generated
        protected SingleEntityRequest(SingleEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entity = b.entity;
        }

        @Generated
        public static SingleEntityRequestBuilder<?, ?> builder() {
            return new SingleEntityRequestBuilderImpl();
        }

        @Generated
        public Entity getEntity() {
            return this.entity;
        }

        @Generated
        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        @Override
        @Generated
        public String toString() {
            return "EntityUniqueAttributesEndpoint.SingleEntityRequest(entity=" + this.getEntity() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleEntityRequest)) {
                return false;
            }
            SingleEntityRequest other = (SingleEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Entity this$entity = this.getEntity();
            Entity other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SingleEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Entity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            return result;
        }

        @Generated
        private static final class SingleEntityRequestBuilderImpl
        extends SingleEntityRequestBuilder<SingleEntityRequest, SingleEntityRequestBuilderImpl> {
            @Generated
            private SingleEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected SingleEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public SingleEntityRequest build() {
                return new SingleEntityRequest(this);
            }
        }

        @Generated
        public static abstract class SingleEntityRequestBuilder<C extends SingleEntityRequest, B extends SingleEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Entity entity;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B entity(Entity entity) {
                this.entity = entity;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "EntityUniqueAttributesEndpoint.SingleEntityRequest.SingleEntityRequestBuilder(super=" + super.toString() + ", entity=" + this.entity + ")";
            }
        }
    }

    public static class ClassificationList
    extends AtlanObject {
        private final List<Classification> classifications;

        public ClassificationList(List<Classification> classifications) {
            this.classifications = classifications;
        }

        @Override
        public String toJson() {
            try {
                return Serde.mapper.writeValueAsString(this.classifications);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to serialize list of classifications.", e);
            }
        }
    }
}

