/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.CreateGroupResponse;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import java.util.List;
import lombok.Generated;

public class GroupsEndpoint {
    private static final String endpoint = "/api/service/groups";

    public static GroupResponse getGroups(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s?filter=%s&sort=%s&count=%s&offset=%s&limit=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter), ApiResource.urlEncode(sort), count, offset, limit);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", GroupResponse.class, null);
    }

    public static GroupResponse getGroups(String filter) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        String url = String.format("%s%s?filter=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", GroupResponse.class, null);
    }

    public static GroupResponse getAllGroups() throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", GroupResponse.class, null);
    }

    public static String createGroup(AtlanGroup group) throws AtlanException {
        CreateGroupResponse response = GroupsEndpoint.createGroup(group, null);
        if (response != null) {
            return response.getGroup();
        }
        return null;
    }

    public static CreateGroupResponse createGroup(AtlanGroup group, List<String> userIds) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        Object cgr = CreateGroupRequest.builder().group(group);
        if (userIds != null && !userIds.isEmpty()) {
            cgr = ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).users(userIds);
        }
        return ApiResource.request(ApiResource.RequestMethod.POST, url, ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).build(), CreateGroupResponse.class, null);
    }

    public static void updateGroup(String id, AtlanGroup group) throws AtlanException {
        String url = String.format("%s%s/%s", Atlan.getBaseUrl(), endpoint, id);
        ApiResource.request(ApiResource.RequestMethod.POST, url, group, null, null);
    }

    public static void deleteGroup(String id) throws AtlanException {
        String url = String.format("%s%s/%s/delete", Atlan.getBaseUrl(), endpoint, id);
        ApiResource.request(ApiResource.RequestMethod.POST, url, "", null, null);
    }

    static final class CreateGroupRequest
    extends AtlanObject {
        AtlanGroup group;
        List<String> users;

        @Generated
        protected CreateGroupRequest(CreateGroupRequestBuilder<?, ?> b) {
            super(b);
            this.group = b.group;
            this.users = b.users;
        }

        @Generated
        public static CreateGroupRequestBuilder<?, ?> builder() {
            return new CreateGroupRequestBuilderImpl();
        }

        @Generated
        public AtlanGroup getGroup() {
            return this.group;
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Generated
        public void setGroup(AtlanGroup group) {
            this.group = group;
        }

        @Generated
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @Override
        @Generated
        public String toString() {
            return "GroupsEndpoint.CreateGroupRequest(group=" + this.getGroup() + ", users=" + this.getUsers() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateGroupRequest)) {
                return false;
            }
            CreateGroupRequest other = (CreateGroupRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtlanGroup this$group = this.getGroup();
            AtlanGroup other$group = other.getGroup();
            if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
                return false;
            }
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateGroupRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanGroup $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        private static final class CreateGroupRequestBuilderImpl
        extends CreateGroupRequestBuilder<CreateGroupRequest, CreateGroupRequestBuilderImpl> {
            @Generated
            private CreateGroupRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateGroupRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateGroupRequest build() {
                return new CreateGroupRequest(this);
            }
        }

        @Generated
        public static abstract class CreateGroupRequestBuilder<C extends CreateGroupRequest, B extends CreateGroupRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private AtlanGroup group;
            @Generated
            private List<String> users;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B group(AtlanGroup group) {
                this.group = group;
                return (B)this.self();
            }

            @Generated
            public B users(List<String> users) {
                this.users = users;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "GroupsEndpoint.CreateGroupRequest.CreateGroupRequestBuilder(super=" + super.toString() + ", group=" + this.group + ", users=" + this.users + ")";
            }
        }
    }
}

