/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AbstractPolicy;
import com.atlan.model.admin.GlossaryPolicy;
import com.atlan.model.admin.Persona;
import com.atlan.model.admin.PersonaDataPolicy;
import com.atlan.model.admin.PersonaMetadataPolicy;
import com.atlan.model.admin.PersonaResponse;
import com.atlan.model.admin.PurposeDataPolicy;
import com.atlan.model.admin.PurposeMetadataPolicy;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.DataPolicyAction;
import com.atlan.net.ApiResource;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import lombok.Generated;

public class PersonasEndpoint {
    private static final String endpoint = "/api/service/personas";

    public static PersonaResponse getPersonas(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s?filter=%s&sort=%s&count=%s&offset=%s&limit=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter), ApiResource.urlEncode(sort), count, offset, limit);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", PersonaResponse.class, null);
    }

    public static PersonaResponse getPersonas(String filter) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        String url = String.format("%s%s?filter=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", PersonaResponse.class, null);
    }

    public static PersonaResponse getAllPersonas() throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", PersonaResponse.class, null);
    }

    public static Persona createPersona(Persona persona) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        WrappedPersona wrapped = ApiResource.request(ApiResource.RequestMethod.POST, url, persona, WrappedPersona.class, null);
        if (wrapped != null) {
            return wrapped.getPersona();
        }
        return null;
    }

    public static void updatePersona(String id, Persona persona) throws AtlanException {
        String url = String.format("%s%s/%s", Atlan.getBaseUrl(), endpoint, id);
        ApiResource.request(ApiResource.RequestMethod.POST, url, persona, null, null);
    }

    public static void deletePersona(String id) throws AtlanException {
        String url = String.format("%s%s/%s", Atlan.getBaseUrl(), endpoint, id);
        ApiResource.request(ApiResource.RequestMethod.DELETE, url, "", null, null);
    }

    public static AbstractPolicy addPolicyToPersona(String id, AbstractPolicy policy) throws AtlanException {
        String url = String.format("%s%s/%s/policies", Atlan.getBaseUrl(), endpoint, id);
        Object pr = PolicyRequest.builder().policy(policy);
        if (policy instanceof GlossaryPolicy) {
            pr = ((PolicyRequest.PolicyRequestBuilder)pr).type("glossaryPolicy");
        } else if (policy instanceof PersonaDataPolicy) {
            pr = ((PolicyRequest.PolicyRequestBuilder)pr).type("dataPolicy");
        } else if (policy instanceof PersonaMetadataPolicy) {
            pr = ((PolicyRequest.PolicyRequestBuilder)pr).type("metadataPolicy");
        }
        WrappedPolicy wrapped = ApiResource.request(ApiResource.RequestMethod.POST, url, ((PolicyRequest.PolicyRequestBuilder)pr).build(), WrappedPolicy.class, null);
        if (wrapped != null) {
            return wrapped.getPolicy();
        }
        return null;
    }

    private static class WrappedPolicySerializer
    extends StdSerializer<WrappedPolicy> {
        private static final long serialVersionUID = 2L;

        public WrappedPolicySerializer() {
            this(null);
        }

        public WrappedPolicySerializer(Class<WrappedPolicy> t) {
            super(t);
        }

        public void serialize(WrappedPolicy wrappedPolicy, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            AbstractPolicy policy = wrappedPolicy.getPolicy();
            Serde.mapper.writeValue(gen, (Object)policy);
        }
    }

    private static class WrappedPolicyDeserializer
    extends StdDeserializer<WrappedPolicy> {
        private static final long serialVersionUID = 2L;

        public WrappedPolicyDeserializer() {
            this(null);
        }

        public WrappedPolicyDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedPolicy deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            TreeNode tree = parser.getCodec().readTree(parser);
            TreeNode connectionId = tree.get("connectionId");
            TreeNode glossaryQNs = tree.get("glossaryQualifiedNames");
            AbstractPolicy policy = null;
            if (connectionId != null && !connectionId.isMissingNode()) {
                TreeNode actions = tree.get("actions");
                if (actions.isArray()) {
                    ArrayNode actionsList = (ArrayNode)actions;
                    String firstAction = actionsList.get(0).asText();
                    policy = firstAction != null && firstAction.equals(DataPolicyAction.SELECT.getValue()) ? (AbstractPolicy)parser.getCodec().treeToValue(tree, PersonaDataPolicy.class) : (AbstractPolicy)parser.getCodec().treeToValue(tree, PersonaMetadataPolicy.class);
                }
            } else if (glossaryQNs != null && !glossaryQNs.isMissingNode()) {
                policy = (AbstractPolicy)parser.getCodec().treeToValue(tree, GlossaryPolicy.class);
            } else {
                TreeNode actions = tree.get("actions");
                if (actions.isArray()) {
                    ArrayNode actionsList = (ArrayNode)actions;
                    String firstAction = actionsList.get(0).asText();
                    policy = firstAction != null && firstAction.equals(DataPolicyAction.SELECT.getValue()) ? (AbstractPolicy)parser.getCodec().treeToValue(tree, PurposeDataPolicy.class) : (AbstractPolicy)parser.getCodec().treeToValue(tree, PurposeMetadataPolicy.class);
                }
            }
            return new WrappedPolicy(policy);
        }
    }

    @JsonSerialize(using=WrappedPolicySerializer.class)
    @JsonDeserialize(using=WrappedPolicyDeserializer.class)
    private static final class WrappedPolicy
    extends ApiResource {
        AbstractPolicy policy;

        public WrappedPolicy(AbstractPolicy policy) {
            this.policy = policy;
        }

        @Generated
        public AbstractPolicy getPolicy() {
            return this.policy;
        }

        @Generated
        public void setPolicy(AbstractPolicy policy) {
            this.policy = policy;
        }

        @Override
        @Generated
        public String toString() {
            return "PersonasEndpoint.WrappedPolicy(policy=" + this.getPolicy() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedPolicy)) {
                return false;
            }
            WrappedPolicy other = (WrappedPolicy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AbstractPolicy this$policy = this.getPolicy();
            AbstractPolicy other$policy = other.getPolicy();
            return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedPolicy;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AbstractPolicy $policy = this.getPolicy();
            result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
            return result;
        }
    }

    private static class WrappedPersonaSerializer
    extends StdSerializer<WrappedPersona> {
        private static final long serialVersionUID = 2L;

        public WrappedPersonaSerializer() {
            this(null);
        }

        public WrappedPersonaSerializer(Class<WrappedPersona> t) {
            super(t);
        }

        public void serialize(WrappedPersona wrappedPersona, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            Persona persona = wrappedPersona.getPersona();
            Serde.mapper.writeValue(gen, (Object)persona);
        }
    }

    private static class WrappedPersonaDeserializer
    extends StdDeserializer<WrappedPersona> {
        private static final long serialVersionUID = 2L;

        public WrappedPersonaDeserializer() {
            this(null);
        }

        public WrappedPersonaDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedPersona deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Persona persona = (Persona)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<Persona>(){});
            return new WrappedPersona(persona);
        }
    }

    @JsonSerialize(using=WrappedPersonaSerializer.class)
    @JsonDeserialize(using=WrappedPersonaDeserializer.class)
    private static final class WrappedPersona
    extends ApiResource {
        Persona persona;

        public WrappedPersona(Persona persona) {
            this.persona = persona;
        }

        @Generated
        public Persona getPersona() {
            return this.persona;
        }

        @Generated
        public void setPersona(Persona persona) {
            this.persona = persona;
        }

        @Override
        @Generated
        public String toString() {
            return "PersonasEndpoint.WrappedPersona(persona=" + this.getPersona() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedPersona)) {
                return false;
            }
            WrappedPersona other = (WrappedPersona)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Persona this$persona = this.getPersona();
            Persona other$persona = other.getPersona();
            return !(this$persona == null ? other$persona != null : !((Object)this$persona).equals(other$persona));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedPersona;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Persona $persona = this.getPersona();
            result = result * 59 + ($persona == null ? 43 : ((Object)$persona).hashCode());
            return result;
        }
    }

    static class PolicyRequest
    extends AtlanObject {
        String type;
        AbstractPolicy policy;

        @Generated
        protected PolicyRequest(PolicyRequestBuilder<?, ?> b) {
            super(b);
            this.type = b.type;
            this.policy = b.policy;
        }

        @Generated
        public static PolicyRequestBuilder<?, ?> builder() {
            return new PolicyRequestBuilderImpl();
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public AbstractPolicy getPolicy() {
            return this.policy;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setPolicy(AbstractPolicy policy) {
            this.policy = policy;
        }

        @Override
        @Generated
        public String toString() {
            return "PersonasEndpoint.PolicyRequest(type=" + this.getType() + ", policy=" + this.getPolicy() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PolicyRequest)) {
                return false;
            }
            PolicyRequest other = (PolicyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            AbstractPolicy this$policy = this.getPolicy();
            AbstractPolicy other$policy = other.getPolicy();
            return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PolicyRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            AbstractPolicy $policy = this.getPolicy();
            result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
            return result;
        }

        @Generated
        private static final class PolicyRequestBuilderImpl
        extends PolicyRequestBuilder<PolicyRequest, PolicyRequestBuilderImpl> {
            @Generated
            private PolicyRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected PolicyRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public PolicyRequest build() {
                return new PolicyRequest(this);
            }
        }

        @Generated
        public static abstract class PolicyRequestBuilder<C extends PolicyRequest, B extends PolicyRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String type;
            @Generated
            private AbstractPolicy policy;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B type(String type) {
                this.type = type;
                return (B)this.self();
            }

            @Generated
            public B policy(AbstractPolicy policy) {
                this.policy = policy;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "PersonasEndpoint.PolicyRequest.PolicyRequestBuilder(super=" + super.toString() + ", type=" + this.type + ", policy=" + this.policy + ")";
            }
        }
    }
}

