/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.ClassificationDef;
import com.atlan.model.typedefs.CustomMetadataDef;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.ApiResource;
import java.util.List;

public class TypeDefsEndpoint {
    private static final String endpoint = "/api/meta/types/typedefs";
    private static final String endpoint_singular = "/api/meta/types/typedef";

    public static TypeDefResponse getTypeDefs(AtlanTypeCategory category) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s?type=%s", endpoint, category.getValue().toLowerCase()));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", TypeDefResponse.class, null);
    }

    public static TypeDefResponse createTypeDef(TypeDef typeDef) throws AtlanException {
        TypeDefResponse wrapper = new TypeDefResponse();
        if (typeDef != null) {
            switch (typeDef.getCategory()) {
                case CLASSIFICATION: {
                    wrapper.setClassificationDefs(List.of((ClassificationDef)typeDef));
                    break;
                }
                case CUSTOM_METADATA: {
                    wrapper.setCustomMetadataDefs(List.of((CustomMetadataDef)typeDef));
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unable to create new type definitions of category: " + typeDef.getCategory(), "category", "ATLAN-CLIENT-400-010", 400, null);
                }
            }
            String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
            return ApiResource.request(ApiResource.RequestMethod.POST, url, wrapper, TypeDefResponse.class, null);
        }
        return wrapper;
    }

    public static TypeDefResponse updateTypeDef(TypeDef typeDef) throws AtlanException {
        TypeDefResponse wrapper = new TypeDefResponse();
        if (typeDef != null) {
            switch (typeDef.getCategory()) {
                case CLASSIFICATION: {
                    wrapper.setClassificationDefs(List.of((ClassificationDef)typeDef));
                    break;
                }
                case CUSTOM_METADATA: {
                    wrapper.setCustomMetadataDefs(List.of((CustomMetadataDef)typeDef));
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unable to update type definitions of category: " + typeDef.getCategory(), "category", "ATLAN-CLIENT-400-011", 400, null);
                }
            }
            String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
            return ApiResource.request(ApiResource.RequestMethod.PUT, url, wrapper, TypeDefResponse.class, null);
        }
        return wrapper;
    }

    public static void purgeTypeDef(String internalName) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s/name/%s", endpoint_singular, internalName));
        ApiResource.request(ApiResource.RequestMethod.DELETE, url, "", null, null);
    }
}

